/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.adobe.xmp.XMPException;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.FileNamerContext;
import se.datadosen.jalbum.StandardFileNamer;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.IO;

public class SEOFileNamer
extends StandardFileNamer {
    private char separator = (char)45;
    private boolean useFolderName = true;
    private boolean useTitle = true;
    private boolean useCaption = true;
    private boolean useKeywords = true;
    private int maxLength = 64;

    public String createName(AlbumObject ao, FileNamerContext context) {
        StringBuilder buf = new StringBuilder();
        if (this.useFolderName) {
            buf.append(context.getFolder().getName());
        }
        if (this.useTitle) {
            this.append(ao.getTitle(), buf);
        }
        if (this.useCaption) {
            this.append(ao.getComment(), buf);
        }
        if (this.useKeywords) {
            String keywords = "";
            XmpManager mgr = ao.getXmpManager();
            if (mgr != null) {
                try {
                    keywords = mgr.getKeywords();
                }
                catch (XMPException ex) {
                    // empty catch block
                }
            }
            this.append(keywords, buf);
        }
        buf.append('.').append(IO.extensionOf(ao.getFile()));
        return this.makeWebSafe(this.cropLength(buf.toString()));
    }

    protected StringBuilder append(String part, StringBuilder buf) {
        if (part != null && part.length() > 0) {
            if (buf.length() > 0) {
                buf.append(this.separator);
            }
            buf.append(part.trim());
        }
        return buf;
    }

    protected String cropLength(String name) {
        if (name.length() > this.maxLength) {
            String base = IO.baseName(name);
            String ext = IO.extensionOf(name);
            name = base.substring(0, this.maxLength - (ext.length() + 1)) + '.' + ext;
        }
        return name;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public boolean isUseCaption() {
        return this.useCaption;
    }

    public void setUseCaption(boolean useCaption) {
        this.useCaption = useCaption;
    }

    public boolean isUseFolderName() {
        return this.useFolderName;
    }

    public void setUseFolderName(boolean useFolderName) {
        this.useFolderName = useFolderName;
    }

    public boolean isUseKeywords() {
        return this.useKeywords;
    }

    public void setUseKeywords(boolean useKeywords) {
        this.useKeywords = useKeywords;
    }

    public boolean isUseTitle() {
        return this.useTitle;
    }

    public void setUseTitle(boolean useTitle) {
        this.useTitle = useTitle;
    }
}

