/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.DigestUtil;

public class LicenseManagerImpl
implements LicenseManager {
    protected final JAlbumContext context;
    protected Preferences preferences = Preferences.userNodeForPackage(SignInManager.class);
    public static final String JALBUM_SUPPORTER = "jAlbumSupporter";

    LicenseManagerImpl(JAlbumContext context) {
        this.context = context;
    }

    public String getLicenseCode() {
        boolean ok = false;
        try {
            if (this.keyExists("validLicense")) {
                ok = (this.getWindow() == null || SignInManager.getInstance().isSignedIn()) && this.preferences.getBoolean("validLicense", false);
            } else {
                Date accountExpires = new Date(this.preferences.getLong("accountExpires", 0L));
                if ((this.getWindow() == null || SignInManager.getInstance().isSignedIn()) && new Date().before(accountExpires)) {
                    ok = true;
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return ok ? DigestUtil.md5(SignInManager.getInstance().getUserName() + "part" + "of" + "it") : "";
    }

    private boolean keyExists(String key) throws BackingStoreException {
        for (String k : this.preferences.keys()) {
            if (!k.equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isLicenseValid() {
        return this.getLicenseCode().length() > 0;
    }

    public boolean isOldDonor() {
        return this.preferences.getBoolean(JALBUM_SUPPORTER, false);
    }

    protected JAlbumFrame getWindow() {
        return this.context.getFrame();
    }
}

