/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPSchemaRegistry;
import com.adobe.xmp.XMPVersionInfo;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPMetaParser;
import com.adobe.xmp.impl.XMPSchemaRegistryImpl;
import com.adobe.xmp.impl.XMPSerializerHelper;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;

public final class XMPMetaFactory {
    private static XMPSchemaRegistry schema = new XMPSchemaRegistryImpl();
    private static XMPVersionInfo versionInfo = null;

    private XMPMetaFactory() {
    }

    public static XMPSchemaRegistry getSchemaRegistry() {
        return schema;
    }

    public static XMPMeta create() {
        return new XMPMetaImpl();
    }

    public static XMPMeta parse(InputStream inputStream) throws XMPException {
        return XMPMetaFactory.parse(inputStream, null);
    }

    public static XMPMeta parse(InputStream inputStream, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(inputStream, parseOptions);
    }

    public static XMPMeta parseFromString(String string) throws XMPException {
        return XMPMetaFactory.parseFromString(string, null);
    }

    public static XMPMeta parseFromString(String string, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(string, parseOptions);
    }

    public static XMPMeta parseFromBuffer(byte[] byArray) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(byArray, null);
    }

    public static XMPMeta parseFromBuffer(byte[] byArray, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(byArray, parseOptions);
    }

    public static void serialize(XMPMeta xMPMeta, OutputStream outputStream) throws XMPException {
        XMPMetaFactory.serialize(xMPMeta, outputStream, null);
    }

    public static void serialize(XMPMeta xMPMeta, OutputStream outputStream, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        XMPSerializerHelper.serialize((XMPMetaImpl)xMPMeta, outputStream, serializeOptions);
    }

    public static byte[] serializeToBuffer(XMPMeta xMPMeta, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        return XMPSerializerHelper.serializeToBuffer((XMPMetaImpl)xMPMeta, serializeOptions);
    }

    public static String serializeToString(XMPMeta xMPMeta, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        return XMPSerializerHelper.serializeToString((XMPMetaImpl)xMPMeta, serializeOptions);
    }

    private static void assertImplementation(XMPMeta xMPMeta) {
        if (!(xMPMeta instanceof XMPMetaImpl)) {
            throw new UnsupportedOperationException("The serializing service works onlywith the XMPMeta implementation of this library");
        }
    }

    public static void reset() {
        schema = new XMPSchemaRegistryImpl();
    }

    public static synchronized XMPVersionInfo getVersionInfo() {
        if (versionInfo == null) {
            try {
                versionInfo = new XMPVersionInfo(){

                    public int getMajor() {
                        return 5;
                    }

                    public int getMinor() {
                        return 1;
                    }

                    public int getMicro() {
                        return 0;
                    }

                    public boolean isDebug() {
                        return false;
                    }

                    public int getBuild() {
                        return 3;
                    }

                    public String getMessage() {
                        return "Adobe XMP Core 5.1.0-jc003";
                    }

                    public String toString() {
                        return "Adobe XMP Core 5.1.0-jc003";
                    }
                };
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
        }
        return versionInfo;
    }
}

