/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.MultipleResizableBoxPanel;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.TextBox;
import net.jalbum.filters.TextControl;
import se.datadosen.jalbum.Msg;

public class TextFilterPlugin
extends MultipleResizableBoxPanel {
    private static final long serialVersionUID = -2877909947583115228L;
    protected TextControl textControl;
    protected TextBox textBox = new TextBox();

    public TextFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.text.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.text.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/text.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.text.description");
        this.category = FilterProperties.FilterCategory.BASIC;
        this.prescale = true;
        this.postscale = false;
        this.namePrefix = "Text Box ";
        this.textControl = new TextControl(this);
        this.multipleResizableObjectControl = this.textControl;
        this.multipleResizableBoxControl = this.textControl;
        this.resizableObjectControl = this.textControl;
        this.emptyClickCreatesNewObject = true;
    }

    public void init() {
        this.textBox = new TextBox();
        this.textBox.setName(this.namePrefix + this.counter);
        this.textBox.setParentPanel(this);
        this.objectVector.clear();
        this.objectVector.add(this.textBox);
        this.resizableBox = this.textBox;
        this.hoveredOverObject = this.resizableObject = this.resizableBox;
    }

    public JPanel getControls() {
        return this.textControl;
    }

    public void addObject() {
        this.resizableObject.setState(10);
        this.textBox = new TextBox(this.width, this.height);
        this.textBox.setName(this.namePrefix + (this.counter - 1));
        this.textBox.setParentPanel(this);
        this.textBox.setInitial(true);
        this.objectVector.add(0, this.textBox);
        this.resizableBox = this.textBox;
        this.resizableObject = this.textBox;
        this.multipleResizableObjectControl.adjustResizableObject(this.resizableObject);
        ++this.counter;
        this.renderPreview();
    }

    public TextBox getTextBox() {
        return (TextBox)this.resizableObject;
    }

    public void paint(Graphics g) {
        for (int i = this.objectVector.size() - 1; i >= 0; --i) {
            if (this.objectVector.get(i) == this.resizableObject && this.outlineSelected) {
                ((TextBox)this.resizableObject).paintSelected(g);
                continue;
            }
            ((ResizableObject)this.objectVector.get(i)).paint(g);
        }
    }

    public void renderPreview() {
        this.outputImage = this.cloneBufferedImage(this.inputImage);
        this.paint(this.outputImage.getGraphics());
        this.filterManager.setGUIImage(this.outputImage);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        Graphics g = bi.getGraphics();
        for (int i = this.objectVector.size() - 1; i >= 0; --i) {
            ((TextBox)this.objectVector.get(i)).setHeight(bi.getHeight());
            ((TextBox)this.objectVector.get(i)).setWidth(bi.getWidth());
            ((TextBox)this.objectVector.get(i)).prepareTextDrawing(g, true);
            ((TextBox)this.objectVector.get(i)).drawText(g);
        }
        return bi;
    }

    public void setTextBox(TextBox textBox) {
        this.textBox = textBox;
    }

    public void setPreviewImage(BufferedImage bi) {
        super.setPreviewImage(bi);
        this.textControl.adjustTextBox(this.textBox);
    }

    public void dispose() {
        super.dispose();
        this.textControl.dispose();
    }
}

