/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import se.datadosen.jalbum.Msg;

public class InvertFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 1L;

    public InvertFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.invert.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.invert.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/invert.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.invert.description");
        this.category = FilterProperties.FilterCategory.FUN;
        this.prescale = true;
        this.postscale = true;
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage biOut = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        for (int x = 0; x < bi.getWidth(); ++x) {
            for (int y = 0; y < bi.getHeight(); ++y) {
                int rgb = bi.getRGB(x, y);
                int alpha = (int)(((long)rgb & 0xFF000000L) >> 24);
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                r = 255 - r;
                g = 255 - g;
                b = 255 - b;
                rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                biOut.setRGB(x, y, rgb);
            }
        }
        return biOut;
    }
}

