/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import se.datadosen.jalbum.Msg;

public class GrayScaleFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 1720559385062856569L;

    public GrayScaleFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.grayScale.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.grayScale.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/grayscale.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.grayScale.description");
        this.category = FilterProperties.FilterCategory.OTHER;
        this.prescale = true;
        this.postscale = true;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        Graphics2D g = bi.createGraphics();
        RenderingHints rhs = g.getRenderingHints();
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        BufferedImage dstImg = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
        theOp.filter(bi, dstImg);
        return dstImg;
    }
}

