/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.GammaControl;
import se.datadosen.jalbum.Msg;

public class GammaFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 7863546541947760848L;
    protected GammaControl gammaControl;
    protected double gammaAlpha = 1.0;
    protected double gammaR = 1.0;
    protected double gammaG = 1.0;
    protected double gammaB = 1.0;

    public GammaFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.gamma.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.gamma.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/gamma.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.gamma.description");
        this.category = FilterProperties.FilterCategory.ADVANCED;
        this.prescale = true;
        this.postscale = false;
        this.gammaControl = new GammaControl(this);
    }

    public JPanel getControls() {
        return this.gammaControl;
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage out = new BufferedImage(w, h, bi.getType());
        int[] alphas = new int[256];
        int[] reds = new int[256];
        int[] greens = new int[256];
        int[] blues = new int[256];
        for (int i = 0; i < 256; ++i) {
            alphas[i] = this.calculateGamma(i, this.gammaAlpha);
            reds[i] = this.calculateGamma(i, this.gammaR);
            greens[i] = this.calculateGamma(i, this.gammaG);
            blues[i] = this.calculateGamma(i, this.gammaB);
        }
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = bi.getRGB(x, y);
                int alpha = (int)(((long)rgb & 0xFF000000L) >> 24);
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                alpha = alphas[alpha];
                r = reds[r];
                g = greens[g];
                b = blues[b];
                rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                out.setRGB(x, y, rgb);
            }
        }
        return out;
    }

    private int calculateGamma(int color, double gamma) {
        int val = (int)(255.0 * Math.pow(color, 1.0 / gamma) / Math.pow(255.0, 1.0 / gamma));
        if (val > 255) {
            val = 255;
        } else if (val < 0) {
            val = 0;
        }
        return val;
    }

    public double getGammaAlpha() {
        return this.gammaAlpha;
    }

    public void setGammaAlpha(double gammaAlpha) {
        this.gammaAlpha = gammaAlpha;
    }

    public double getGammaR() {
        return this.gammaR;
    }

    public void setGammaR(double gammaR) {
        this.gammaR = gammaR;
    }

    public double getGammaG() {
        return this.gammaG;
    }

    public void setGammaG(double gammaG) {
        this.gammaG = gammaG;
    }

    public double getGammaB() {
        return this.gammaB;
    }

    public void setGammaB(double gammaB) {
        this.gammaB = gammaB;
    }
}

