/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class NetwareFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: NetwareFileParser.java,v 1.2 2010-03-31 00:54:48 bruceb Exp $";
    private static Logger log = Logger.getLogger("NetwareFileParser");
    private static final char FILE_CHAR = '-';
    private static final char DIRECTORY_CHAR = 'd';
    private static final String CURRENT_DIR_PREFIX = "./";
    private SimpleDateFormat dateFormatter;
    private static final int MIN_FIELD_COUNT = 8;

    public NetwareFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public void setLocale(Locale locale) {
        this.dateFormatter = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
    }

    public String toString() {
        return "NETWARE";
    }

    public boolean isValidFormat(String[] listing) {
        int count = Math.min(listing.length, 10);
        for (int i = 0; i < count; ++i) {
            if (listing[i].trim().length() == 0 || !NetwareFileParser.isNetware(listing[i])) continue;
            return true;
        }
        log.debug("Not in Netware format");
        return false;
    }

    public static boolean isNetware(String raw) {
        if ((raw = raw.trim()).length() < 3) {
            return false;
        }
        char ch1 = raw.charAt(0);
        char ch2 = raw.charAt(2);
        return (ch1 == '-' || ch1 == 'd') && ch2 == '[';
    }

    public FTPFile parse(String raw) throws ParseException {
        Date lastModified;
        Calendar cal;
        long size;
        String owner;
        String permissions;
        boolean isDir;
        block13: {
            if (!NetwareFileParser.isNetware(raw)) {
                return null;
            }
            String[] fields = this.split(raw);
            if (fields.length < 8) {
                StringBuffer msg = new StringBuffer("Unexpected number of fields in listing '");
                msg.append(raw).append("' - expected minimum ").append(8).append(" fields but found ").append(fields.length).append(" fields");
                log.warn(msg.toString());
                return null;
            }
            int index = 0;
            isDir = false;
            char ch = raw.charAt(0);
            if (ch == 'd') {
                isDir = true;
            }
            if ((permissions = fields[++index]).charAt(0) == '[' && permissions.charAt(permissions.length() - 1) == ']') {
                permissions = permissions.substring(1);
                permissions = permissions.substring(0, permissions.length() - 1);
            }
            owner = fields[++index];
            size = 0L;
            String sizeStr = fields[++index];
            try {
                size = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException ex) {
                log.warn("Failed to parse size: " + sizeStr);
            }
            String month = fields[++index];
            String day = fields[++index];
            String year = fields[++index];
            String time = "00:00";
            cal = Calendar.getInstance();
            if (year.indexOf(58) > 0) {
                time = year;
                year = Integer.toString(cal.get(1));
            }
            StringBuffer stamp = new StringBuffer(month);
            stamp.append('-');
            stamp.append(day);
            stamp.append('-');
            stamp.append(year);
            stamp.append('-');
            stamp.append(time);
            lastModified = null;
            try {
                lastModified = this.dateFormatter.parse(stamp.toString());
            }
            catch (ParseException ex) {
                if (this.ignoreDateParseErrors) break block13;
                throw new DateParseException(ex.getMessage());
            }
        }
        cal.add(5, 2);
        if (lastModified != null && lastModified.after(cal.getTime())) {
            cal.setTime(lastModified);
            cal.add(1, -1);
            lastModified = cal.getTime();
        }
        String name = raw.trim();
        for (int i = 0; i < 7; ++i) {
            int pos = name.indexOf(32);
            if (pos <= 0) {
                name = null;
                log.debug("Failed to extract filename");
                break;
            }
            name = name.substring(pos).trim();
        }
        if (name.startsWith(CURRENT_DIR_PREFIX)) {
            name = name.substring(CURRENT_DIR_PREFIX.length());
        }
        FTPFile file = new FTPFile(raw, name, size, isDir, lastModified);
        file.setOwner(owner);
        file.setPermissions(permissions);
        return file;
    }
}

