/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.jalbum.editor.JTextPad;
import net.jalbum.editor.JTextPadDocument;
import net.jalbum.editor.OperationCanceledException;
import nl.tomcee.skinprops.SkinPropsEditor;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.BasicCompletion;
import se.datadosen.component.ControlPanel;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.TextEditor;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.IO;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.WindowUtilities;

public class JTextPadPlugin
implements JAlbumPlugin,
TextEditor.Editor {
    private PluginContext context;
    private JAlbumFrame window;
    private Set<String> ignoreNames = new HashSet<String>();
    Action reloadSkin;
    Action editSkinFiles;
    Action editSkinProps;
    Action openEmptyEditor;
    Action createNewSkin;
    Action packSkin;
    Action prepareForOnlineUse;
    Action deleteSkin;

    public JTextPadPlugin() {
        this.ignoreNames.add("Thumbs.db");
        this.ignoreNames.add(".DS_Store");
        this.ignoreNames.add(".svn");
        this.ignoreNames.add(".cvs");
        this.reloadSkin = new AbstractAction("Reload skin"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, JTextPad.menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                ((JTextPadPlugin)JTextPadPlugin.this).window.mainSettingsPanel.reloadSkin();
            }
        };
        this.editSkinFiles = new AbstractAction("Edit skin files"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, JTextPad.menuShortcutKeyMask | 1));
            }

            public void actionPerformed(ActionEvent e) {
                Tracer.getInstance().trace("edit skin files");
                final JTextPad textpad = JTextPad.getLastUsedInstance();
                File skinDir = JTextPadPlugin.this.context.getJAlbumContext().getSkinDir();
                final File[] files = skinDir.listFiles();
                new Thread("loader thread"){

                    public void run() {
                        for (File f : files) {
                            String ext = IO.extensionOf(f).toLowerCase();
                            if (!JTextPad.fileTypes.containsKey(ext)) continue;
                            JTextPadDocument document = JTextPadPlugin.this.getConfiguredDocument(textpad, f);
                            if (!"index.htt".equals(f.getName())) continue;
                            textpad.setCurrentDocument(document);
                            textpad.toFront();
                        }
                    }
                }.start();
            }
        };
        this.editSkinProps = new AbstractAction("Edit skin properties"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 8));
            }

            public void actionPerformed(ActionEvent e) {
                new SkinPropsEditor();
            }
        };
        this.openEmptyEditor = new AbstractAction("Open empty editor"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, JTextPad.menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                Tracer.getInstance().trace("open empty editor");
                JTextPad textpad = JTextPad.getLastUsedInstance();
                if (textpad.isVisible()) {
                    textpad.toFront();
                    return;
                }
                File skinDir = JTextPadPlugin.this.context.getJAlbumContext().getSkinDir();
                JTextPadDocument document = JTextPadPlugin.this.getConfiguredDocument(textpad, skinDir);
                textpad.setCurrentDocument(document);
            }
        };
        this.createNewSkin = new AbstractAction("Create new skin..."){

            public void actionPerformed(ActionEvent e) {
                ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
                if (!chainedSkinsDir.exists()) {
                    chainedSkinsDir.mkdir();
                }
                ControlPanel panel = new ControlPanel();
                panel.add((Component)new JLabel("Please enter name for new skin:"));
                JTextField nameField = new JTextField();
                WindowUtilities.setDefaultFocus((Component)nameField);
                panel.add("br hfill", (Component)nameField);
                panel.add("br", (Component)new JLabel("Base new skin on following skin:"));
                JComboBox<String> skinBox = new JComboBox<String>(JTextPadPlugin.namesOf(chainedSkinsDir.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })));
                skinBox.setSelectedItem("Base");
                panel.add("br hfill", skinBox);
                int reply = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, panel, "Create new skin", 2, 1);
                if (reply != 0) {
                    return;
                }
                String name = nameField.getText();
                String baseSkin = skinBox.getSelectedItem().toString();
                File newSkinDir = new File(chainedSkinsDir.getDirectory(), name);
                if (newSkinDir.exists()) {
                    JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Skin " + name + " already exists", "Create new skin", 0);
                    return;
                }
                File sourceSkinDir = chainedSkinsDir.getFile(baseSkin);
                if (!sourceSkinDir.exists()) {
                    JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Can't find skin " + baseSkin + " to use as template for new skin creation", "Create new skin", 0);
                    return;
                }
                try {
                    newSkinDir.mkdir();
                    IO.copyFile(sourceSkinDir, newSkinDir);
                    ((JTextPadPlugin)JTextPadPlugin.this).window.mainSettingsPanel.scanSkins();
                    JTextPadPlugin.this.window.ui2Engine();
                    JTextPadPlugin.this.context.getJAlbumContext().getEngine().setSkin(name);
                    JTextPadPlugin.this.window.engine2UI();
                    int answer = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, "Skin " + name + " created ok with " + baseSkin + " skin as base.\nDo you want to edit it now?", "Create new skin", 0);
                    if (answer == 0) {
                        JTextPadPlugin.this.editSkinFiles.actionPerformed(null);
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Error creating new skin: " + ex.getMessage(), "Create new skin", 0);
                }
            }
        };
        this.packSkin = new AbstractAction("Pack as .jaskin file"){

            public void actionPerformed(ActionEvent e) {
                final String name = JTextPadPlugin.this.context.getJAlbumContext().getEngine().getSkin();
                final String packedName = name + ".jaskin";
                ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Packing skin " + name + " to " + packedName + "...");
                new Thread("Skin packer"){

                    public void run() {
                        ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
                        File skinDir = chainedSkinsDir.getFile(name);
                        try {
                            File skinFile = new File(skinDir.getParentFile(), packedName);
                            ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(skinFile)));
                            this.packDir(skinDir, skinDir.getParentFile(), zout);
                            zout.finish();
                            zout.close();
                            ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Skin " + name + " packed as " + packedName);
                            BrowserLauncher.showInFileSystem(skinFile);
                        }
                        catch (IOException ex) {
                            ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Skin " + name + " packing aborted due to error");
                            JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Error packing skin: " + ex.getMessage(), "Pack skin", 0);
                        }
                    }
                }.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void packDir(File dir, File rel, ZipOutputStream zout) throws IOException {
                byte[] buffer = new byte[65536];
                ZipEntry e = new ZipEntry(IO.relativePath(dir, rel) + '/');
                e.setTime(dir.lastModified());
                zout.putNextEntry(e);
                for (File f : dir.listFiles(new FileFilter(){

                    public boolean accept(File test) {
                        String s = test.getName();
                        return !s.equals(".DS_Store") && !s.toLowerCase().equals(".svn") && !s.toLowerCase().equals(".cvs");
                    }
                })) {
                    if (f.isDirectory()) {
                        this.packDir(f, rel, zout);
                        continue;
                    }
                    e = new ZipEntry(IO.relativePath(f, rel));
                    e.setTime(f.lastModified());
                    zout.putNextEntry(e);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                    try {
                        int bytes;
                        while ((bytes = ((InputStream)in).read(buffer)) >= 0) {
                            zout.write(buffer, 0, bytes);
                        }
                        zout.closeEntry();
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            }
        };
        this.prepareForOnlineUse = new AbstractAction("Prepare for online and console use..."){

            public void actionPerformed(ActionEvent e) {
                JTextPadPlugin.this.window.ui2Engine();
                String name = JTextPadPlugin.this.context.getJAlbumContext().getEngine().getSkin();
                int answer = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, "This will make this skin also work in situations where jAlbum's window isn't present\nlike console mode and online use (embedded inside a web server)\n\nA property file called 'headless-properties.jap' is stored in the skin's directory.\nThis file contains all current skin settings. It will seed the album engine\nwith all required variables, which are normally seeded from the user interface.\n\nDo you want to prepare skin?", "Prepare for online and console use", 0, 1);
                if (answer != 0) {
                    return;
                }
                ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
                File skinDir = chainedSkinsDir.getFile(name);
                ControlPanel skinUI = JTextPadPlugin.this.window.getSkinUI();
                if (skinUI != null) {
                    Properties props = new Properties();
                    for (Map.Entry<Object, Object> item : PropertyBinder.getProperties((JComponentHolder)skinUI).entrySet()) {
                        props.setProperty("skin." + item.getKey(), item.getValue().toString());
                    }
                    File headlessFile = new File(skinDir, "headless-settings.jap");
                    try {
                        FileOutputStream fout = new FileOutputStream(headlessFile);
                        props.store(fout, "These settings are applied when running jAlbum without its window");
                        fout.close();
                        ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Skin settings saved to " + headlessFile);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        };
        this.deleteSkin = new AbstractAction("Delete selected skin..."){

            public void actionPerformed(ActionEvent e) {
                JTextPadPlugin.this.window.ui2Engine();
                String name = JTextPadPlugin.this.context.getJAlbumContext().getEngine().getSkin();
                int answer = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, "Are you sure you wish to delete the " + name + " skin?", "Delete selected skin", 0, 2);
                if (answer != 0) {
                    return;
                }
                ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
                File skinDir = chainedSkinsDir.getFile(name);
                JTextPadPlugin.this.context.getJAlbumContext().getEngine().unloadCurrentSkin();
                JTextPadPlugin.this.context.getJAlbumContext().getEngine().setSkin("");
                IO.recycle(skinDir);
                File remainingSkinDir = chainedSkinsDir.getFile(name);
                if (remainingSkinDir.exists() && !remainingSkinDir.equals(skinDir)) {
                    JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "The " + name + " skin is now deleted. You are now left with the bundled version of the same skin.\n" + "Run this operation again to delete that version too", "Delete selected skin", 1);
                }
                ((JTextPadPlugin)JTextPadPlugin.this).window.mainSettingsPanel.scanSkins();
            }
        };
    }

    private static String[] namesOf(File[] files) {
        Object[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        Arrays.sort(names);
        return names;
    }

    private JTextPadDocument getConfiguredDocument(JTextPad textpad, File f) {
        JTextPadDocument document = textpad.getOpenDocumentFor(f);
        if (document == null) {
            document = textpad.openDocument(f);
            this.configureDocument(document);
        }
        return document;
    }

    public void init(PluginContext context) {
        this.context = context;
        this.window = context.getJAlbumContext().getFrame();
        TextEditor.install((TextEditor.Editor)this);
        JMenu menu = new JMenu("Skin developer");
        menu.add(new JMenuItem(this.editSkinFiles));
        menu.add(new JMenuItem(this.editSkinProps));
        menu.add(new JMenuItem(this.openEmptyEditor));
        menu.addSeparator();
        menu.add(new JMenuItem(this.reloadSkin));
        menu.addSeparator();
        menu.add(new JMenuItem(this.createNewSkin));
        menu.add(new JMenuItem(this.prepareForOnlineUse));
        menu.add(new JMenuItem(this.packSkin));
        menu.add(new JMenuItem(this.deleteSkin));
        context.addToolsMenuItem((JMenuItem)menu);
    }

    public void configureDocument(JTextPadDocument document) {
        AbstractCompletionProvider provider = document.getCompletionProvider();
        this.context.getJAlbumContext().getFrame().ui2Engine();
        LinkedList<BasicCompletion> list = new LinkedList<BasicCompletion>();
        Map skinVars = this.context.getJAlbumContext().getEngine().getSkinVariables();
        Set entries = skinVars.entrySet();
        for (Map.Entry e : entries) {
            BasicCompletion cpl = new BasicCompletion(provider, e.getKey().toString(), this.context.getJAlbumContext().getEngine().getSkin(), "Sample value: " + e.getValue());
            list.add(cpl);
        }
        Map userVars = this.context.getJAlbumContext().getEngine().getUserVariables();
        entries = userVars.entrySet();
        for (Map.Entry e : entries) {
            BasicCompletion cpl = new BasicCompletion(provider, e.getKey().toString(), "User variable", "Sample value: " + e.getValue());
            list.add(cpl);
        }
        provider.addCompletions(list);
    }

    public boolean onExit() {
        try {
            LinkedList<JTextPad> editorsClone = new LinkedList<JTextPad>(JTextPad.editors);
            for (JTextPad textpad : editorsClone) {
                textpad.exitAction.actionPerformed(null);
            }
            return true;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
    }

    public void openDocument(File f) {
        JTextPad editor = JTextPad.getLastUsedInstance();
        if (editor.isVisible()) {
            editor.toFront();
        }
        JTextPadDocument document = this.getConfiguredDocument(editor, f);
        editor.setCurrentDocument(document);
    }

    public JTextComponent getCurrentEditorComponent() {
        JTextPad editor = JTextPad.getLastUsedInstance();
        return editor.getCurrentDocument().getTextArea();
    }

    public JTextComponent newDocument() {
        JTextPad editor = JTextPad.getLastUsedInstance();
        JTextPadDocument document = editor.openDocument(null);
        editor.setCurrentDocument(document);
        return document.getTextArea();
    }
}

