/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import mx4j.log.CommonsLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import net.sbbi.upnp.jmx.UPNPDiscovery;
import org.apache.commons.logging.LogFactory;

public class JMXManager {
    private static final JMXManager instance = new JMXManager();
    private static final org.apache.commons.logging.Log log = LogFactory.getLog((Class)JMXManager.class);
    private ObjectName discBeanName = null;
    private MBeanServer server;

    public static final JMXManager getInstance() {
        return instance;
    }

    public static final JMXManager getNewInstance(MBeanServer server) {
        JMXManager manager = new JMXManager();
        manager.setMBeanserver(server);
        return manager;
    }

    private void setMBeanserver(MBeanServer server) {
        this.server = server;
    }

    public void startup(int discoveryTimeout) throws Exception {
        this.discBeanName = new ObjectName("UPNPLib discovery:name=Discovery MBean_" + this.hashCode());
        UPNPDiscovery bean = new UPNPDiscovery(discoveryTimeout, true, true);
        this.server.registerMBean(bean, this.discBeanName);
    }

    public void shutdown() {
        try {
            this.server.unregisterMBean(this.discBeanName);
        }
        catch (Exception ex) {
            log.error((Object)"Error occured during UPNPDiscoveryMBean unregistration", (Throwable)ex);
        }
    }

    private MBeanServer initMBeanServer(MBeanServerConfig conf) throws Exception {
        Log.redirectTo((Logger)new CommonsLogger());
        String oldSysProp = System.getProperty("javax.management.builder.initial");
        System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        MBeanServer server = MBeanServerFactory.createMBeanServer("UPNPLib");
        if (oldSysProp != null) {
            System.setProperty("javax.management.builder.initial", oldSysProp);
        }
        ObjectName serverName = new ObjectName("Http:name=HttpAdaptor");
        server.createMBean("mx4j.tools.adaptor.http.HttpAdaptor", serverName, null);
        server.setAttribute(serverName, new Attribute("Port", new Integer(conf.adapterAdapterPort)));
        Boolean allowWanBool = new Boolean(conf.allowWan);
        if (allowWanBool.booleanValue()) {
            server.setAttribute(serverName, new Attribute("Host", "0.0.0.0"));
        } else {
            server.setAttribute(serverName, new Attribute("Host", "localhost"));
        }
        ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
        server.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", processorName, null);
        server.setAttribute(processorName, new Attribute("LocaleString", conf.locale));
        server.setAttribute(processorName, new Attribute("UseCache", Boolean.FALSE));
        server.setAttribute(processorName, new Attribute("PathInJar", "net/sbbi/jmx/xsl"));
        server.setAttribute(serverName, new Attribute("ProcessorName", processorName));
        server.invoke(serverName, "addAuthorization", new Object[]{conf.adapterUserName, conf.adapterPassword}, new String[]{"java.lang.String", "java.lang.String"});
        server.setAttribute(serverName, new Attribute("AuthenticationMethod", "basic"));
        server.invoke(serverName, "start", null, null);
        return server;
    }

    public static final void main(String[] args) {
        if (args.length != 6) {
            log.info((Object)"Usage : JMXManager <AdapterPort> <UserName> <Password> <AllowWan> <Locale> <discoveryTimeout>");
            System.exit(0);
        }
        try {
            JMXManager manager = JMXManager.getInstance();
            MBeanServerConfig conf = new MBeanServerConfig(args);
            manager.setMBeanserver(manager.initMBeanServer(conf));
            manager.startup(conf.discoveryTimeout);
        }
        catch (Exception ex) {
            log.error((Object)"Error during startup", (Throwable)ex);
        }
    }

    private static final class MBeanServerConfig {
        private String adapterAdapterPort;
        private String adapterUserName;
        private String adapterPassword;
        private String allowWan;
        private String locale;
        private int discoveryTimeout;

        private MBeanServerConfig(String[] args) {
            this.adapterAdapterPort = args[0];
            this.adapterUserName = args[1];
            this.adapterPassword = args[2];
            this.allowWan = args[3];
            this.locale = args[4];
            this.discoveryTimeout = Integer.parseInt(args[5]);
        }
    }
}

