/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.devices;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.sbbi.upnp.JXPathParser;
import net.sbbi.upnp.devices.DeviceIcon;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.services.UPNPService;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.apache.commons.jxpath.xml.XMLParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPRootDevice
extends UPNPDevice {
    private static final Log log = LogFactory.getLog((Class)UPNPRootDevice.class);
    private int specVersionMajor;
    private int specVersionMinor;
    private URL URLBase;
    private long validityTime;
    private long creationTime;
    private URL deviceDefLoc;
    private String deviceDefLocData;
    private String vendorFirmware;
    private String discoveryUSN;
    private String discoveryUDN;
    private DocumentContainer UPNPDevice;

    public UPNPRootDevice(URL deviceDefLoc, String maxAge, String vendorFirmware, String discoveryUSN, String discoveryUDN) throws MalformedURLException, IllegalStateException {
        this(deviceDefLoc, maxAge);
        this.vendorFirmware = vendorFirmware;
        this.discoveryUSN = discoveryUSN;
        this.discoveryUDN = discoveryUDN;
    }

    public UPNPRootDevice(URL deviceDefLoc, String maxAge, String vendorFirmware) throws MalformedURLException, IllegalStateException {
        this(deviceDefLoc, maxAge);
        this.vendorFirmware = vendorFirmware;
    }

    public UPNPRootDevice(URL deviceDefLoc, String maxAge) throws MalformedURLException, IllegalStateException {
        this.deviceDefLoc = deviceDefLoc;
        DocumentContainer.registerXMLParser((String)"DOM", (XMLParser)new JXPathParser());
        this.UPNPDevice = new DocumentContainer(deviceDefLoc, "DOM");
        this.validityTime = Integer.parseInt(maxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
        JXPathContext context = JXPathContext.newContext((Object)this);
        Pointer rootPtr = context.getPointer("UPNPDevice/root");
        JXPathContext rootCtx = context.getRelativeContext(rootPtr);
        this.specVersionMajor = Integer.parseInt((String)rootCtx.getValue("specVersion/major"));
        this.specVersionMinor = Integer.parseInt((String)rootCtx.getValue("specVersion/minor"));
        if (this.specVersionMajor != 1 || this.specVersionMinor != 0) {
            throw new IllegalStateException("Unsupported device version (" + this.specVersionMajor + "." + this.specVersionMinor + ")");
        }
        boolean buildURLBase = true;
        String base = null;
        try {
            base = (String)rootCtx.getValue("URLBase");
            if (base != null && base.trim().length() > 0) {
                this.URLBase = new URL(base);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("device URLBase " + this.URLBase));
                }
                buildURLBase = false;
            }
        }
        catch (JXPathException ex) {
        }
        catch (MalformedURLException malformedEx) {
            log.warn((Object)("Error occured during device baseURL " + base + " parsing, building it from device default location"), (Throwable)malformedEx);
        }
        if (buildURLBase) {
            int lastSlash;
            String URL2 = deviceDefLoc.getProtocol() + "://" + deviceDefLoc.getHost() + ":" + deviceDefLoc.getPort();
            String path = deviceDefLoc.getPath();
            if (path != null && (lastSlash = path.lastIndexOf(47)) != -1) {
                URL2 = URL2 + path.substring(0, lastSlash);
            }
            this.URLBase = new URL(URL2);
        }
        Pointer devicePtr = rootCtx.getPointer("device");
        JXPathContext deviceCtx = rootCtx.getRelativeContext(devicePtr);
        this.fillUPNPDevice(this, null, deviceCtx, this.URLBase);
    }

    public long getValidityTime() {
        long elapsed = System.currentTimeMillis() - this.creationTime;
        return this.validityTime - elapsed;
    }

    public void resetValidityTime(String newMaxAge) {
        this.validityTime = Integer.parseInt(newMaxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
    }

    public URL getDeviceDefLoc() {
        return this.deviceDefLoc;
    }

    public int getSpecVersionMajor() {
        return this.specVersionMajor;
    }

    public int getSpecVersionMinor() {
        return this.specVersionMinor;
    }

    public String getVendorFirmware() {
        return this.vendorFirmware;
    }

    public String getDiscoveryUSN() {
        return this.discoveryUSN;
    }

    public String getDiscoveryUDN() {
        return this.discoveryUDN;
    }

    public URL getURLBase() {
        return this.URLBase;
    }

    private void fillUPNPDevice(UPNPDevice device, UPNPDevice parent, JXPathContext deviceCtx, URL baseURL) throws MalformedURLException {
        Pointer deviceListPtr;
        device.deviceType = this.getMandatoryData(deviceCtx, "deviceType");
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsing device " + device.deviceType));
        }
        device.friendlyName = this.getMandatoryData(deviceCtx, "friendlyName");
        device.manufacturer = this.getNonMandatoryData(deviceCtx, "manufacturer");
        String base = this.getNonMandatoryData(deviceCtx, "manufacturerURL");
        try {
            if (base != null) {
                device.manufacturerURL = new URL(base);
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            device.presentationURL = UPNPRootDevice.getURL(this.getNonMandatoryData(deviceCtx, "presentationURL"), this.URLBase);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        device.modelDescription = this.getNonMandatoryData(deviceCtx, "modelDescription");
        device.modelName = this.getMandatoryData(deviceCtx, "modelName");
        device.modelNumber = this.getNonMandatoryData(deviceCtx, "modelNumber");
        device.modelURL = this.getNonMandatoryData(deviceCtx, "modelURL");
        device.serialNumber = this.getNonMandatoryData(deviceCtx, "serialNumber");
        device.UDN = this.getMandatoryData(deviceCtx, "UDN");
        device.USN = this.UDN.concat("::").concat(this.deviceType);
        String tmp = this.getNonMandatoryData(deviceCtx, "UPC");
        if (tmp != null) {
            try {
                device.UPC = Long.parseLong(tmp);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        device.parent = parent;
        this.fillUPNPServicesList(device, deviceCtx);
        this.fillUPNPDeviceIconsList(device, deviceCtx, this.URLBase);
        try {
            deviceListPtr = deviceCtx.getPointer("deviceList");
        }
        catch (JXPathException ex) {
            return;
        }
        JXPathContext deviceListCtx = deviceCtx.getRelativeContext(deviceListPtr);
        Double arraySize = (Double)deviceListCtx.getValue("count( device )");
        device.childDevices = new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("child devices count is " + arraySize));
        }
        for (int i = 1; i <= arraySize.intValue(); ++i) {
            Pointer devicePtr = deviceListCtx.getPointer("device[" + i + "]");
            JXPathContext childDeviceCtx = deviceListCtx.getRelativeContext(devicePtr);
            UPNPDevice childDevice = new UPNPDevice();
            this.fillUPNPDevice(childDevice, device, childDeviceCtx, baseURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding child device " + childDevice.getDeviceType()));
            }
            device.childDevices.add(childDevice);
        }
    }

    private String getMandatoryData(JXPathContext ctx, String ctxFieldName) {
        String value = (String)ctx.getValue(ctxFieldName);
        if (value != null && value.length() == 0) {
            throw new JXPathException("Mandatory field " + ctxFieldName + " not provided, uncompliant UPNP device !!");
        }
        return value;
    }

    private String getNonMandatoryData(JXPathContext ctx, String ctxFieldName) {
        String value = null;
        try {
            value = (String)ctx.getValue(ctxFieldName);
            if (value != null && value.length() == 0) {
                value = null;
            }
        }
        catch (JXPathException ex) {
            value = null;
        }
        return value;
    }

    private void fillUPNPServicesList(UPNPDevice device, JXPathContext deviceCtx) throws MalformedURLException {
        Pointer serviceListPtr = deviceCtx.getPointer("serviceList");
        JXPathContext serviceListCtx = deviceCtx.getRelativeContext(serviceListPtr);
        Double arraySize = (Double)serviceListCtx.getValue("count( service )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("device services count is " + arraySize));
        }
        device.services = new ArrayList();
        for (int i = 1; i <= arraySize.intValue(); ++i) {
            Pointer servicePtr = serviceListCtx.getPointer("service[" + i + "]");
            JXPathContext serviceCtx = serviceListCtx.getRelativeContext(servicePtr);
            URL base = this.URLBase != null ? this.URLBase : this.deviceDefLoc;
            UPNPService service = new UPNPService(serviceCtx, base, this);
            device.services.add(service);
        }
    }

    private void fillUPNPDeviceIconsList(UPNPDevice device, JXPathContext deviceCtx, URL baseURL) throws MalformedURLException {
        Pointer iconListPtr;
        try {
            iconListPtr = deviceCtx.getPointer("iconList");
        }
        catch (JXPathException ex) {
            return;
        }
        JXPathContext iconListCtx = deviceCtx.getRelativeContext(iconListPtr);
        Double arraySize = (Double)iconListCtx.getValue("count( icon )");
        if (log.isDebugEnabled()) {
            log.debug((Object)("device icons count is " + arraySize));
        }
        device.deviceIcons = new ArrayList();
        for (int i = 1; i <= arraySize.intValue(); ++i) {
            DeviceIcon ico = new DeviceIcon();
            ico.mimeType = (String)iconListCtx.getValue("icon[" + i + "]/mimetype");
            ico.width = Integer.parseInt((String)iconListCtx.getValue("icon[" + i + "]/width"));
            ico.height = Integer.parseInt((String)iconListCtx.getValue("icon[" + i + "]/height"));
            ico.depth = Integer.parseInt((String)iconListCtx.getValue("icon[" + i + "]/depth"));
            ico.url = UPNPRootDevice.getURL((String)iconListCtx.getValue("icon[" + i + "]/url"), baseURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("icon URL is " + ico.url));
            }
            device.deviceIcons.add(ico);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final URL getURL(String url, URL baseURL) throws MalformedURLException {
        void var2_2;
        URL rtrVal;
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        try {
            rtrVal = new URL(url);
        }
        catch (MalformedURLException malEx) {
            if (baseURL != null) {
                if ((url = url.replace('\\', '/')).charAt(0) != '/') {
                    String externalForm = baseURL.toExternalForm();
                    if (!externalForm.endsWith("/")) {
                        externalForm = externalForm + "/";
                    }
                    rtrVal = new URL(externalForm + url);
                } else {
                    String URLRoot = baseURL.getProtocol() + "://" + baseURL.getHost() + ":" + baseURL.getPort();
                    rtrVal = new URL(URLRoot + url);
                }
            }
            throw malEx;
        }
        return var2_2;
    }

    public String getDeviceDefLocData() {
        if (this.deviceDefLocData == null) {
            try {
                InputStream in = this.deviceDefLoc.openConnection().getInputStream();
                int readen = 0;
                byte[] buff = new byte[512];
                StringBuffer strBuff = new StringBuffer();
                while ((readen = in.read(buff)) != -1) {
                    strBuff.append(new String(buff, 0, readen));
                }
                in.close();
                this.deviceDefLocData = strBuff.toString();
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return this.deviceDefLocData;
    }

    public Container getUPNPDevice() {
        return this.UPNPDevice;
    }
}

