/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import se.datadosen.jalbum.AlbumManifest;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadWorkers {
    UploadBean uploadBean;
    Worker[] workers;
    AlbumManifest manifest;
    ByteProgressEvent progressEvent;
    List<UploadBean.FileNode> list;
    String remotePath;

    public UploadWorkers(UploadBean uploadBean, ByteProgressEvent progressEvent, AlbumManifest manifest, int maxTransfers) {
        this.uploadBean = uploadBean;
        this.progressEvent = progressEvent;
        this.manifest = manifest;
        this.workers = new Worker[maxTransfers];
        this.workers[0] = new Worker(uploadBean.getRemoteFS());
    }

    void uploadFiles(List<UploadBean.FileNode> list, String remotePath) throws RemoteFSException, IOException, OperationAbortedException, InterruptedException {
        int i;
        this.list = list;
        this.remotePath = remotePath;
        for (i = 1; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i);
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].join();
        }
        Throwable t = null;
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            if (this.workers[i2].throwable == null) {
                return;
            }
            t = this.workers[i2].throwable;
        }
        if (t != null) {
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RemoteFSException) {
                throw (RemoteFSException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            t.printStackTrace(System.err);
        }
    }

    void fireFileProcessingProgress() {
        this.progressEvent.processed = this.uploadBean.processedBytes + this.getBytesInProgress();
        this.uploadBean.fireFileProcessingProgress(this.progressEvent);
    }

    private long getBytesInProgress() {
        long totalBytesInProgress = 0L;
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].isAlive()) continue;
            totalBytesInProgress += this.workers[i].currentFileByteProgress;
        }
        return totalBytesInProgress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    extends Thread
    implements RemoteFSProgressMonitor {
        RemoteFSDelegate channel;
        boolean disconnectOnDone;
        Throwable throwable;
        long currentFileByteProgress;

        public Worker(int i) {
            super("Upload worker " + (i + 1));
            this.disconnectOnDone = true;
            this.setDaemon(true);
        }

        public Worker(RemoteFSDelegate connectedDelegate) {
            super("Main upload worker");
            this.disconnectOnDone = true;
            this.channel = connectedDelegate;
            this.disconnectOnDone = false;
            connectedDelegate.setProgressMonitor(this);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                if (this.channel == null) {
                    this.prepareConnection();
                }
                this.uploadFiles(UploadWorkers.this.list, UploadWorkers.this.remotePath);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            if (this.disconnectOnDone) {
                try {
                    this.channel.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void bytesTransferred(long bytes) {
            this.currentFileByteProgress = bytes;
            UploadWorkers.this.fireFileProcessingProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uploadFiles(List<UploadBean.FileNode> list, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
            if (list.size() > 0) {
                this.channel.setDirectory(remotePath);
            }
            for (UploadBean.FileNode node : list) {
                File f = node.getFile();
                String newPath = IO.combinePaths(remotePath, f.getName());
                List<UploadBean.FileNode> children = node.getChildren();
                if (children != null) {
                    if (!node.isProcessed()) {
                        Worker worker = this;
                        synchronized (worker) {
                            try {
                                this.channel.createDirectory(f.getName());
                            }
                            catch (RemoteFSException ex) {
                                // empty catch block
                            }
                            node.setProcessed(true);
                        }
                    }
                    if (children.size() <= 0) continue;
                    this.uploadFiles(children, newPath);
                    this.channel.toParentDirectory();
                    continue;
                }
                if (!node.doProcess()) continue;
                UploadWorkers.this.progressEvent.update(f.getParentFile().getName(), f.getName(), UploadWorkers.this.uploadBean.processedBytes + UploadWorkers.this.getBytesInProgress());
                UploadWorkers.this.uploadBean.fireFileProcessingStarted(UploadWorkers.this.progressEvent);
                if (UploadWorkers.this.progressEvent.isAborted()) {
                    throw new OperationAbortedException();
                }
                int attempt = 1;
                while (true) {
                    try {
                        Object in;
                        if (attempt > 1) {
                            if (this.channel.isConnected()) {
                                this.channel.disconnect();
                            }
                            this.channel.reconnect();
                        }
                        if (f.getName().equals("album.rss") && UploadWorkers.this.uploadBean.getAccountProperties() != null) {
                            in = UploadWorkers.this.uploadBean.processRSSFile(f);
                            this.channel.put((InputStream)in, f.getName());
                            ((InputStream)in).close();
                            break;
                        }
                        this.channel.putFile(f, f.getName());
                        if (UploadWorkers.this.manifest == null) break;
                        in = UploadWorkers.this;
                        synchronized (in) {
                            UploadWorkers.this.manifest.putFile(new RemoteFileImpl(IO.relativePath(newPath, UploadWorkers.this.uploadBean.remoteAlbumPath), f.length(), f.lastModified()));
                        }
                    }
                    catch (IOException ex) {
                        if (attempt > 6) {
                            throw ex;
                        }
                        System.err.println("Caught " + ex.toString() + " while uploading " + f + ". Attempt " + attempt);
                        try {
                            Thread.sleep(1000 * attempt * attempt);
                        }
                        catch (InterruptedException ex2) {
                            // empty catch block
                        }
                        ++attempt;
                        continue;
                    }
                    break;
                }
                UploadWorkers.this.uploadBean.fireFileProcessingFinished(UploadWorkers.this.progressEvent);
                if (UploadWorkers.this.progressEvent.isAborted()) {
                    throw new OperationAbortedException();
                }
                this.currentFileByteProgress = 0L;
                UploadWorkers.this.uploadBean.processedBytes += f.length();
            }
        }

        private void prepareConnection() throws RemoteFSException, IOException {
            this.channel = RemoteFSBean.createInstance();
            this.channel.setProgressMonitor(this);
            this.connect();
        }

        private void connect() throws RemoteFSException, IOException {
            UploadBean ub = UploadWorkers.this.uploadBean;
            this.channel.setProtocol(ub.getProtocol());
            this.channel.setForceUTF8(ub.isFtpForceUTF8());
            this.channel.setPassiveMode(ub.isPassiveMode());
            this.channel.setPort(ub.getFtpPort());
            this.channel.connect(ub.getFtpServer(), ub.getFtpUser(), ub.getFtpPassword());
        }
    }
}

