/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Widget;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;

public class Notifier {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    JAlbumContext context;
    JAlbumSite site;

    public Notifier(JAlbumContext context) throws ElementException, IOException {
        this.context = context;
        this.site = JAlbumSite.getTrueInstance();
    }

    public boolean allowedToNotify(AccountProfile account) {
        AlbumBean engine = this.context.getEngine();
        return account.isMyjalbum() || SignInManager.getInstance().isSignedIn();
    }

    private static int countImages(AlbumObject folder) {
        int counter = 0;
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded()) continue;
            if (ao.isFolder()) {
                counter += Notifier.countImages(ao);
                continue;
            }
            if (!ao.isDisplayableImage()) continue;
            ++counter;
        }
        return counter;
    }

    public String albumAdded(AccountProfile account, String albumUrl, AlbumObject root) throws IOException {
        String tags;
        AlbumBean engine = this.context.getEngine();
        if (!this.allowedToNotify(account)) {
            return null;
        }
        String thumbnailPath = root.getThumbnailPath();
        String cid = AccountManager.resolveCid(account);
        RobustResty r = new RobustResty();
        Properties data = new Properties();
        data.setProperty("jalbum.version", AlbumBean.getInternalVersion());
        data.setProperty("albumUrl", Notifier.urlEncode(albumUrl));
        if (thumbnailPath != null) {
            String thumbnailUrl = Notifier.urlEncode(IO.combinePaths(albumUrl, thumbnailPath));
            data.setProperty("thumbnailUrl", thumbnailUrl);
        }
        data.setProperty("albumName", this.context.getFrame().getProjectName());
        AlbumObjectProperties props = root.getProperties();
        String albumTitle = (String)props.get("title");
        if (albumTitle != null) {
            data.setProperty("albumTitle", albumTitle);
        }
        if ((tags = (String)props.get("tags")) != null) {
            data.setProperty("tags", tags);
        }
        data.setProperty("albumDescription", root.getComment());
        data.setProperty("skin", engine.getSkin());
        data.setProperty("style", engine.getStyle());
        data.setProperty("imageCount", "" + Notifier.countImages(root));
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        data.setProperty("visibleOnProfilePage", "" + engine.isVisibleOnProfilePage());
        data.setProperty("notifyFollowers", "" + engine.isNotifyFollowers());
        data.setProperty("showInRecentAlbumsList", "" + engine.isShowInRecentAlbumsList());
        if (account.isMyjalbum()) {
            data.setProperty("password", engine.getWebPassword());
        }
        if (props.containsKey("widgets")) {
            List widgets = (List)props.get("widgets");
            for (Widget widget : widgets) {
                if (widget.getActive() == null) continue;
                data.setProperty("widget." + widget.getId(), widget.getActive().toString());
            }
        }
        this.log("albumAdded", data);
        try {
            String albumId = (String)r.xml(this.site.getAddAlbumUrl(), (AbstractContent)RobustResty.form(data)).get("//albumId", String.class);
            if (albumId.length() > 0) {
                props.put("albumId", albumId);
                props.remove("widgetsLocalChange");
            }
            return albumId.length() > 0 ? albumId : null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void albumAddedBg(final AccountProfile account, final String albumUrl, final AlbumObject root) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumAdded(account, albumUrl, root);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    public String albumDeleted(AccountProfile account, String oldUrl) throws IOException {
        if (!this.allowedToNotify(account)) {
            return null;
        }
        RobustResty r = new RobustResty();
        String cid = AccountManager.resolveCid(account);
        Properties p = new Properties();
        p.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        if (cid != null) {
            p.setProperty("cid", cid);
        }
        String res = r.text(this.site.getUpdateAlbumUrl(), (AbstractContent)RobustResty.form(p)).toString();
        return res;
    }

    public void albumDeletedBg(final AccountProfile account, final String oldUrl) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumDeleted(account, oldUrl);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    public String albumMoved(AccountProfile account, String oldUrl, String newUrl) throws IOException {
        AlbumBean engine = this.context.getEngine();
        if (!this.allowedToNotify(account)) {
            return null;
        }
        String cid = AccountManager.resolveCid(account);
        Properties data = new Properties();
        data.setProperty("oldUrl", Notifier.urlEncode(oldUrl));
        data.setProperty("newUrl", Notifier.urlEncode(newUrl));
        if (cid != null) {
            data.setProperty("cid", cid);
        }
        this.log("albumMoved", data);
        RobustResty r = new RobustResty();
        return r.text(this.site.getUpdateAlbumUrl(), (AbstractContent)RobustResty.form(data)).toString();
    }

    public void albumMovedBg(final AccountProfile account, final String oldUrl, final String newUrl) {
        Thread t = new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    Notifier.this.albumMoved(account, oldUrl, newUrl);
                }
                catch (Exception ex) {
                    Notifier.this.log(ex);
                }
            }
        };
        t.start();
    }

    private void log(String text, Properties data) {
        if (Config.getConfig().isDebugMode()) {
            System.out.println(text + ":");
            for (Map.Entry<Object, Object> e : data.entrySet()) {
                System.out.println(e.getKey() + "=" + e.getValue());
            }
        }
    }

    private void log(Throwable t) {
        if (Config.getConfig().isDebugMode()) {
            t.printStackTrace();
        }
    }

    static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || chars[i] == ' ' || chars[i] == '#' || chars[i] == '%' || chars[i] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

