/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Cursor;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import se.datadosen.jalbum.Msg;

public class JHtmlBox
extends JTextPane
implements HyperlinkListener {
    private String text = "";

    public JHtmlBox() {
        this.init();
    }

    public JHtmlBox(String htmlText) {
        this.init();
        this.setHtmlText(htmlText);
    }

    public JHtmlBox(String htmlText, int relFontSize) {
        this.init();
        this.setHtmlText(htmlText, relFontSize);
    }

    public void setHtmlText(String htmlText) {
        this.setHtmlText(htmlText, 0);
    }

    public void setText(String t) {
        super.setText(t);
        this.text = t;
    }

    public void setHtmlText(String htmlText, int relFontSize) {
        String in = "<html><body><font face=\"sansserif\" size=" + (3 + relFontSize) + ">" + htmlText + "</font></body></html>";
        this.setText(in);
    }

    private void init() {
        this.setFocusable(false);
        this.setContentType("text/html");
        this.setOpaque(false);
        this.setEditable(false);
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            this.linkActivated(e);
        } else if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
            this.linkEntered(e);
        } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
            this.linkExited(e);
        }
    }

    protected void linkActivated(HyperlinkEvent e) {
        try {
            BrowserLauncher.openURL(e.getURL().toExternalForm());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), ex.getMessage(), Msg.getString("wiz.openFailed"), 0);
        }
    }

    protected void linkEntered(HyperlinkEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    protected void linkExited(HyperlinkEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JHtmlBox other = (JHtmlBox)obj;
        return this.text.equals(other.text);
    }

    public String toString() {
        return this.text;
    }
}

