/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Flag {
    NoFlag("small.flag.empty", Color.black),
    Select("small.flag.red", new Color(232, 49, 46)),
    Second("small.flag.yellow", new Color(236, 187, 79)),
    Review("small.flag.blue", new Color(72, 171, 233)),
    Approved("small.flag.green", new Color(80, 177, 70));

    private Icon icon;
    private Icon selectedIcon;
    private final Color color;

    private Flag(String iconName, Color color) {
        this.color = color;
    }

    public String toString() {
        return Msg.get("flag." + this.name().toLowerCase());
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.getIcon(16, false);
        }
        return this.icon;
    }

    public Icon getSelectedIcon() {
        if (this.selectedIcon == null) {
            this.selectedIcon = this.getIcon(16, true);
        }
        return this.selectedIcon;
    }

    public Icon getIcon(int size, boolean selected) {
        BufferedImage bi = new BufferedImage(size, size, 6);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (Platform.isMac()) {
            g.translate(-0.5, -0.5);
        }
        g.setColor(this.color);
        int side = (int)((double)size * 0.75);
        int margin = (size - side) / 2;
        int radius = side / 2;
        if (this == NoFlag) {
            g.drawRoundRect(margin, margin, side, side, radius, radius);
        } else {
            g.fillRoundRect(margin, margin, side, side, radius, radius);
        }
        if (selected) {
            if (!Platform.isMac()) {
                g.translate(-0.5, -0.5);
            }
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(2.0f));
            g.drawRoundRect(margin, margin, side, side, radius, radius);
        }
        g.dispose();
        return new ImageIcon(bi);
    }
}

