/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopier {
    private static JAlbumFileFilter jAlbumFilter = new JAlbumFileFilter();
    private JFrame parentWindow;
    private JCopyDialog dialog;
    private boolean aborted;
    private boolean done;
    private boolean allowDuplicates = false;
    private boolean deleteExisting = true;
    private List<File> copiedFiles = new ArrayList<File>();
    private int items;
    private long processedBytes;
    private long totalBytes;
    private Stopwatch timer = new Stopwatch();
    private Recorder recorder;
    private CopyDecision copyDecision;
    private Thread copierThread;

    public FileCopier(JFrame window) {
        this.parentWindow = window;
        this.dialog = new JCopyDialog(window, Msg.get("ui.copy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> copyFiles(final List<File> files, final AlbumObject dest) {
        this.copierThread = new Thread("copier"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block14: {
                    FileCopier.this.recorder = Config.getConfig().isRememberCopiedFiles() ? new RealRecorder() : new DummyRecorder();
                    FileCopier.this.copyDecision = CopyDecision.UNDECIDED;
                    FileCopier.this.doCopyFiles(files, dest);
                    Object var3_1 = null;
                    try {
                        FileCopier.this.recorder.close();
                    }
                    catch (IOException ex2) {
                        System.err.println(ex2);
                    }
                    FileCopier.this.recorder = null;
                    {
                        break block14;
                        catch (OperationAbortedException ex) {
                            Object var3_2 = null;
                            try {
                                FileCopier.this.recorder.close();
                            }
                            catch (IOException ex2) {
                                System.err.println(ex2);
                            }
                            FileCopier.this.recorder = null;
                            break block14;
                        }
                        catch (Exception ex) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    Debug.showFriendlyErrorDialog(FileCopier.this.parentWindow, ex);
                                }
                            });
                            Object var3_3 = null;
                            try {
                                FileCopier.this.recorder.close();
                            }
                            catch (IOException ex2) {
                                System.err.println(ex2);
                            }
                            FileCopier.this.recorder = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        try {
                            FileCopier.this.recorder.close();
                        }
                        catch (IOException ex2) {
                            System.err.println(ex2);
                        }
                        FileCopier.this.recorder = null;
                        throw throwable;
                    }
                }
                FileCopier fileCopier = FileCopier.this;
                synchronized (fileCopier) {
                    FileCopier.this.dialog.setVisible(false);
                    FileCopier.this.done = true;
                    FileCopier.this.notify();
                }
            }
        };
        this.copierThread.setDaemon(true);
        this.copierThread.start();
        FileCopier fileCopier = this;
        synchronized (fileCopier) {
            try {
                this.wait(1500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (!this.done) {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parentWindow);
            this.dialog.setVisible(true);
        }
        return this.copiedFiles;
    }

    private void doCopyFiles(List<File> files, AlbumObject ao) throws IOException, OperationAbortedException {
        this.copiedFiles = new ArrayList<File>();
        this.aborted = false;
        this.items = 0;
        this.processedBytes = 0L;
        this.totalBytes = 0L;
        this.timer.reset();
        File dest = ao.getFile();
        this.dialog.setHeader(Msg.get("ui.calculatingSize") + "...");
        this.totalBytes = this.calculateTotalSize(files);
        this.dialog.setHeader(Msg.get("ui.copyingItems", this.items, dest.getName()));
        this.timer.start();
        for (File f : files) {
            if (this.okToCopy(f)) {
                AlbumObject existingChild = ao.getChild(f.getName());
                if (existingChild != null) {
                    if (!this.allowDuplicates) {
                        throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                    }
                    if (!existingChild.isFolder() && this.deleteExisting) {
                        try {
                            existingChild.delete();
                        }
                        catch (PermissionException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
                if (f.isDirectory()) {
                    if (f.equals(ao.getFile()) || IO.isSubdirectoryOf(ao.getFile(), f)) {
                        throw new IOException(Msg.get("ui.invalidFolderCopyError", f.getName()));
                    }
                    this.copiedFiles.add(new File(dest, f.getName()));
                    this.copyDir(f, dest);
                    continue;
                }
                this.doCopyPlainFile(f, dest);
                this.copiedFiles.add(new File(dest, f.getName()));
                continue;
            }
            this.processedBytes += f.length();
        }
    }

    private void copyDir(File src, File dest) throws IOException {
        File dir = new File(dest, src.getName());
        dir.mkdir();
        File[] files = src.listFiles(jAlbumFilter);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.copyDir(f, dir);
                    continue;
                }
                this.copyPlainFile(f, dir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToCopy(File src) {
        if (this.recorder.isAlreadyCopied(src)) {
            CopyDecision decision = this.copyDecision;
            if (this.copyDecision == CopyDecision.UNDECIDED) {
                FileCopier fileCopier = this;
                synchronized (fileCopier) {
                    this.notify();
                }
                JReCopyConfirmationDialog confirmDialog = new JReCopyConfirmationDialog(this.dialog, Msg.get("ui.copy"), src);
                confirmDialog.setVisible(true);
                if (confirmDialog.buttonPressed == confirmDialog.copyButton) {
                    decision = CopyDecision.COPY;
                } else if (confirmDialog.buttonPressed == confirmDialog.dontCopyButton) {
                    decision = CopyDecision.SKIP;
                } else {
                    throw new OperationAbortedException();
                }
                if (confirmDialog.applyToAll.isSelected()) {
                    this.copyDecision = decision;
                }
            }
            return decision == CopyDecision.COPY;
        }
        return true;
    }

    private boolean copyPlainFile(File src, File dest) throws IOException {
        if (this.okToCopy(src)) {
            this.doCopyPlainFile(src, dest);
            return true;
        }
        this.processedBytes += src.length();
        return false;
    }

    private void doCopyPlainFile(File src, File dest) throws IOException {
        File thumbFile;
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        IO.copyFile(src, dest);
        this.recorder.copiedOk(src);
        this.processedBytes += src.length();
        if (!FileFilters.isFileSupported(src) && (thumbFile = IO.thumbFile(src)).exists()) {
            IO.copyFile(thumbFile, dest);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileCopier.this.updateProgress();
            }
        });
    }

    public void abort() {
        this.aborted = true;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isDeleleteExisting() {
        return this.deleteExisting;
    }

    public void setDeleteExisting(boolean b) {
        this.deleteExisting = b;
    }

    private long calculateTotalSize(List<File> files) {
        long size = 0L;
        for (File f : files) {
            ++this.items;
            size += f.isDirectory() ? this.calculateDirSize(f) : f.length();
        }
        return size;
    }

    private long calculateDirSize(File dir) {
        long size = 0L;
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        File[] files = dir.listFiles(jAlbumFilter);
        if (files != null) {
            for (File f : files) {
                ++this.items;
                if (f.isDirectory()) {
                    size += this.calculateDirSize(f);
                    continue;
                }
                size += f.length();
            }
        }
        return size;
    }

    public void updateProgress() {
        if (this.totalBytes > 0L) {
            this.dialog.setPercentDone((int)(100L * this.processedBytes / this.totalBytes));
        }
        String timeLeftString = "";
        long elapsed = this.timer.getMillis();
        if (elapsed > 3000L) {
            long totalMillis = this.totalBytes * elapsed / this.processedBytes;
            int secsLeft = (int)(totalMillis - elapsed) / 1000;
            if (secsLeft < 1) {
                secsLeft = 1;
            }
            timeLeftString = " - " + FileCopier.formatTimeLeft(secsLeft);
        }
        this.dialog.lowerLabel.setText(Msg.get("progress.processingInfo2", DataSizeFormatter.format(this.processedBytes), DataSizeFormatter.format(this.totalBytes)) + timeLeftString);
    }

    private static String formatTimeLeft(int secsLeft) {
        int value;
        String unit = secsLeft > 3600 ? ((value = secsLeft / 3600) > 1 ? "ui.hours" : "ui.hour") : (secsLeft > 60 ? ((value = secsLeft / 60) > 1 ? "ui.minutes" : "ui.minute") : ((value = secsLeft) > 1 ? "ui.seconds" : "ui.second"));
        return Msg.get("ui.timeEstimate", value, Msg.get(unit));
    }

    public static class JReCopyConfirmationDialog
    extends JDialog
    implements ActionListener {
        JLabel upperLabel = new JLabel();
        JLabel icon = new JLabel(Icons.getIcon("large.documents-warning"));
        WrappableJLabel message;
        JCheckBox applyToAll = new JCheckBox(Msg.get("ui.applyToAll"));
        JButton dontCopyButton = new JButton(Msg.get("ui.dontCopy"));
        JButton stopButton = new JButton(Msg.get("ui.stop"));
        JButton copyButton = new JButton(Msg.get("ui.copy"));
        File file;
        JButton buttonPressed = this.stopButton;

        public JReCopyConfirmationDialog(JDialog owner, String title, File file) {
            super(owner, title, true);
            this.file = file;
            this.init();
        }

        private void init() {
            this.setResizable(false);
            this.message = new WrappableJLabel(Msg.get("ui.fileAlreadyCopiedWarning", this.file.getName()));
            this.message.setPreferredWidth(340);
            if (Platform.isMac()) {
                this.setSmallerFont(this.message);
                this.setSmallerFont(this.applyToAll);
                this.setSmallerFont(this.applyToAll);
                this.setSmallerFont(this.dontCopyButton);
                this.setSmallerFont(this.stopButton);
                this.setSmallerFont(this.copyButton);
            }
            this.dontCopyButton.addActionListener(this);
            this.stopButton.addActionListener(this);
            this.copyButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.dontCopyButton);
            JPanel outer = new JPanel(new BorderLayout(8, 0));
            outer.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 2));
            this.setContentPane(outer);
            outer.add((Component)this.icon, "West");
            JPanel messagePanel = new JPanel(new BorderLayout());
            messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
            messagePanel.add((Component)this.message, "Center");
            outer.add((Component)messagePanel, "Center");
            JPanel buttonBar = new JPanel(new FlowLayout(1, 4, 4));
            outer.add((Component)buttonBar, "South");
            buttonBar.add(this.applyToAll);
            buttonBar.add(Box.createHorizontalGlue());
            buttonBar.add(this.dontCopyButton);
            buttonBar.add(this.stopButton);
            buttonBar.add(this.copyButton);
            this.setMinimumSize(new Dimension(420, 1));
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        private void setSmallerFont(JComponent comp) {
            Font f = comp.getFont();
            comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }

        public void actionPerformed(ActionEvent e) {
            this.buttonPressed = (JButton)e.getSource();
            this.setVisible(false);
        }
    }

    class RealRecorder
    implements Recorder {
        private Set<String> db;
        private File dbFile;
        private static final String DB_FILE_NAME = "jalbum-copied-files.db";

        RealRecorder() {
        }

        public boolean isAlreadyCopied(File f) {
            File dcimFolder = this.getDCIMParent(f);
            if (dcimFolder != null) {
                this.ensureInitiated(dcimFolder);
                return this.db.contains(this.keyOf(f));
            }
            return false;
        }

        public void copiedOk(File f) {
            File dcimFolder = this.getDCIMParent(f);
            if (dcimFolder != null) {
                this.ensureInitiated(dcimFolder);
                this.db.add(this.keyOf(f));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            if (this.db == null || this.dbFile == null) return;
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dbFile)));
                oos.writeObject(this.db);
                Object var3_2 = null;
                if (oos == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (oos == null) throw throwable;
                oos.close();
                throw throwable;
            }
            oos.close();
        }

        private void ensureInitiated(File dcimFolder) {
            try {
                if (this.db == null) {
                    this.dbFile = new File(dcimFolder.getParentFile(), DB_FILE_NAME);
                    if (this.dbFile.exists()) {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.dbFile));
                        this.db = (Set)ois.readObject();
                        ois.close();
                    } else {
                        this.db = new HashSet<String>();
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }

        private String keyOf(File f) {
            return f.getParentFile().getName() + "/" + f.getName();
        }

        private File getDCIMParent(File f) {
            for (f = f.getParentFile(); f != null && !"DCIM".equals(f.getName()); f = f.getParentFile()) {
            }
            return f;
        }
    }

    class DummyRecorder
    implements Recorder {
        DummyRecorder() {
        }

        public boolean isAlreadyCopied(File f) {
            return false;
        }

        public void copiedOk(File f) {
        }

        public void close() throws IOException {
        }
    }

    static interface Recorder {
        public boolean isAlreadyCopied(File var1);

        public void copiedOk(File var1);

        public void close() throws IOException;
    }

    private class JCopyDialog
    extends JDialog {
        JLabel upperLabel;
        JLabel icon;
        JProgressBar progressBar;
        JButton abortButton;
        JLabel lowerLabel;

        public JCopyDialog(JFrame owner, String title) {
            super(owner, title, true);
            this.upperLabel = new JLabel();
            this.icon = new JLabel(Icons.getIcon("large.documents"));
            this.progressBar = new JProgressBar(0, 100);
            this.abortButton = new JPlainButton(Icons.getIcon("small.abort"), (Icon)Icons.getIcon("small.abort1"));
            this.lowerLabel = new JLabel(" ");
            this.init();
        }

        private void init() {
            this.setResizable(false);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    FileCopier.this.abort();
                }
            });
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCopyDialog.this.setVisible(false);
                    FileCopier.this.abort();
                }
            });
            if (Platform.isMac()) {
                this.setSmallerFont(this.upperLabel);
                this.setSmallerFont(this.lowerLabel);
            }
            JPanel outer = new JPanel(new BorderLayout(8, 0));
            outer.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 2));
            this.setContentPane(outer);
            outer.add((Component)this.icon, "West");
            JPanel content = new JPanel(new RiverLayout());
            outer.add((Component)content, "Center");
            content.add("hfill", this.upperLabel);
            content.add("br hfill", this.progressBar);
            content.add("", this.abortButton);
            content.add("br hfill", this.lowerLabel);
            this.setMinimumSize(new Dimension(400, 1));
        }

        public void setHeader(String s) {
            this.upperLabel.setText(s);
        }

        public void setPercentDone(int percent) {
            this.progressBar.setValue(percent);
        }

        private void setSmallerFont(JComponent comp) {
            Font f = comp.getFont();
            comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }
    }

    private static class JAlbumFileFilter
    implements FileFilter {
        private JAlbumFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || FileFilters.isFileSupported(f) || FileFilters.hasIcon(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CopyDecision {
        UNDECIDED,
        COPY,
        SKIP;

    }
}

