/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadWorkers {
    UploadBean uploadBean;
    final Worker[] workers;
    final Queue<RemoteFile> downloadQueue;
    final String remotePath;
    ByteProgressEvent progressEvent;
    File destDir;

    public DownloadWorkers(UploadBean uploadBean, ByteProgressEvent progressEvent, Set<RemoteFile> remoteFiles, String remotePath, int maxTransfers, File destDir) {
        this.uploadBean = uploadBean;
        this.progressEvent = progressEvent;
        this.downloadQueue = new LinkedBlockingQueue<RemoteFile>(remoteFiles);
        this.remotePath = remotePath;
        this.destDir = destDir;
        this.workers = new Worker[maxTransfers];
        this.workers[0] = new Worker(uploadBean.getRemoteFS());
    }

    void downloadFiles() throws RemoteFSException, IOException, OperationAbortedException, InterruptedException {
        int i;
        this.destDir.mkdir();
        for (i = 1; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i);
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        for (i = 0; i < this.workers.length; ++i) {
            this.workers[i].join();
        }
        Throwable t = null;
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            if (this.workers[i2].throwable == null) {
                return;
            }
            t = this.workers[i2].throwable;
        }
        if (t != null) {
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RemoteFSException) {
                throw (RemoteFSException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            t.printStackTrace(System.err);
        }
    }

    void fireFileProcessingProgress() {
        this.progressEvent.processed = this.uploadBean.processedBytes + this.getBytesInProgress();
        this.uploadBean.fireFileProcessingProgress(this.progressEvent);
    }

    private long getBytesInProgress() {
        long totalBytesInProgress = 0L;
        for (int i = 0; i < this.workers.length; ++i) {
            if (!this.workers[i].isAlive()) continue;
            totalBytesInProgress += this.workers[i].currentFileByteProgress;
        }
        return totalBytesInProgress;
    }

    private class Worker
    extends Thread
    implements RemoteFSProgressMonitor {
        RemoteFSDelegate channel;
        boolean disconnectOnDone;
        Throwable throwable;
        long currentFileByteProgress;
        String currentPath;

        public Worker(int i) {
            super("Download worker " + (i + 1));
            this.disconnectOnDone = true;
            this.currentPath = "";
            this.setDaemon(true);
        }

        public Worker(RemoteFSDelegate connectedDelegate) {
            super("Main download worker");
            this.disconnectOnDone = true;
            this.currentPath = "";
            this.channel = connectedDelegate;
            this.disconnectOnDone = false;
            connectedDelegate.setProgressMonitor(this);
            this.setDaemon(true);
        }

        public void run() {
            try {
                if (this.channel == null) {
                    this.prepareConnection();
                }
                this.downloadFiles();
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            if (this.disconnectOnDone) {
                try {
                    this.channel.disconnect();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void bytesTransferred(long bytes) {
            this.currentFileByteProgress = bytes;
            DownloadWorkers.this.fireFileProcessingProgress();
        }

        private String getParentPath(RemoteFile rf) {
            String fullPath = rf.getFullPath();
            int slashIndex = fullPath.lastIndexOf(47);
            return slashIndex != -1 ? fullPath.substring(0, slashIndex + 1) : "";
        }

        private void downloadFiles() throws RemoteFSException, IOException, OperationAbortedException {
            RemoteFile rf;
            File curDir = DownloadWorkers.this.destDir;
            while ((rf = DownloadWorkers.this.downloadQueue.poll()) != null) {
                String path = rf.getFullPath();
                String parentPath = this.getParentPath(rf);
                if (!this.currentPath.equals(parentPath)) {
                    curDir = new File(DownloadWorkers.this.destDir, parentPath);
                    curDir.mkdirs();
                    this.currentPath = parentPath;
                }
                File f = new File(DownloadWorkers.this.destDir, path);
                DownloadWorkers.this.progressEvent.update(f.getParentFile().getName(), f.getName(), DownloadWorkers.this.uploadBean.processedBytes + DownloadWorkers.this.getBytesInProgress());
                DownloadWorkers.this.uploadBean.fireFileProcessingStarted(DownloadWorkers.this.progressEvent);
                if (DownloadWorkers.this.progressEvent.isAborted()) {
                    throw new OperationAbortedException();
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                this.channel.get(IO.combinePaths(DownloadWorkers.this.remotePath, path), os);
                os.close();
                this.currentFileByteProgress = 0L;
                DownloadWorkers.this.uploadBean.processedBytes += rf.size();
                DownloadWorkers.this.uploadBean.fireFileProcessingFinished(DownloadWorkers.this.progressEvent);
                if (!DownloadWorkers.this.progressEvent.isAborted()) continue;
                throw new OperationAbortedException();
            }
        }

        private void prepareConnection() throws RemoteFSException, IOException {
            this.channel = RemoteFSBean.createInstance();
            this.channel.setProgressMonitor(this);
            this.connect();
        }

        private void connect() throws RemoteFSException, IOException {
            UploadBean ub = DownloadWorkers.this.uploadBean;
            this.channel.setProtocol(ub.getProtocol());
            this.channel.setForceUTF8(ub.isFtpForceUTF8());
            this.channel.setPassiveMode(ub.isPassiveMode());
            this.channel.setPort(ub.getFtpPort());
            this.channel.connect(ub.getFtpServer(), ub.getFtpUser(), ub.getFtpPassword());
        }
    }
}

