/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.mac;

import com.jniwrapper.Pointer;
import com.jniwrapper.UInt16;
import com.jniwrapper.macosx.cocoa.AwtMacMessageLoop;
import com.jniwrapper.macosx.cocoa.Id;
import com.jniwrapper.macosx.cocoa.nsarray.NSArray;
import com.jniwrapper.macosx.cocoa.nsautoreleasepool.NSAutoreleasePool;
import com.jniwrapper.macosx.cocoa.nsopenpanel.NSOpenPanel;
import com.jniwrapper.macosx.cocoa.nssavepanel.NSSavePanel;
import com.jniwrapper.macosx.cocoa.nsstring.NSString;
import com.jniwrapper.macosx.cocoa.nsurl.NSURL;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.FileChooser;

public class FileChooserImpl
implements FileChooser {
    private static final int SNOW_LEOPARD_MINOR_OS_VERSION = 6;
    private static final int LEOPARD_MINOR_OS_VERSION = 5;
    private static final int MINOR_OS_VERSION;
    public static final int FILE_SELECTION_MODE_INVALID = -1;
    private int _dialogType = 0;
    private NSSavePanel _dialog;
    private List<File> _files = new ArrayList<File>();
    private List actionListeners = new ArrayList();
    private boolean _allowMultipleSelection = true;
    private int _fileSelectionMode = -1;
    private String _dialogTitle;
    private File _currentDirectory;
    private volatile boolean _isShowing = false;

    public FileChooserImpl() {
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
    }

    public void setCurrentDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            this._currentDirectory = dir;
            if (this._dialog != null) {
                this.setCurrentDirectoryToNSPanel(dir);
            }
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("Directory ").append(dir.getAbsolutePath()).append(" does not exists").toString());
        }
        this.notifyListeners("directoryChanged");
    }

    private void setCurrentDirectoryToNSPanel(File dir) {
        if (dir != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            if (MINOR_OS_VERSION < 6) {
                this.getDialog().setDirectory(dir.getAbsolutePath());
            } else {
                NSURL url = NSURL.NSURL_fileURLWithPath((String)dir.getAbsolutePath());
                this.getDialog().setDirectoryURL(url);
            }
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public File getCurrentDirectory() {
        File result;
        if (this._currentDirectory == null && this._dialog != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            if (MINOR_OS_VERSION < 6) {
                Pointer.Void pointerToDirectoryName = this.getDialog().directory();
                result = this.getFileFromNsString(pointerToDirectoryName);
            } else {
                Pointer.Void pointerToURL = this.getDialog().directoryURL();
                result = this.getFileFromNsUrl(pointerToURL);
            }
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
            this._currentDirectory = result;
        } else {
            result = this._currentDirectory;
        }
        return result;
    }

    private boolean isRequireExplicitCleanup() {
        return !AwtMacMessageLoop.getInstance().isEventDispatchThread();
    }

    private File getFileFromNsString(Pointer.Void pointerToDirectoryName) {
        File result = null;
        NSString directoryNameNsString = new NSString(pointerToDirectoryName);
        String directoryName = directoryNameNsString.cString().getValue();
        if (directoryName.length() != 0) {
            result = new File(directoryName);
        }
        return result;
    }

    private File getFileFromNsUrl(Pointer.Void pointerToURL) {
        String parsedDirectoryPath;
        File result = null;
        NSURL url = new NSURL(pointerToURL);
        Pointer.Void pointerToStringURL = url.absoluteString();
        NSString nsStringURL = new NSString(pointerToStringURL);
        String directoryPath = nsStringURL.cString().getValue();
        try {
            URI uri = new URI(directoryPath);
            parsedDirectoryPath = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new NullPointerException("Cannot retrieve directory information");
        }
        if (parsedDirectoryPath.length() != 0) {
            result = new File(parsedDirectoryPath);
        }
        return result;
    }

    public void setDialogTitle(String dialogTitle) {
        this._dialogTitle = dialogTitle;
        this.notifyListeners("DialogTitleChangedProperty");
    }

    private void setDialogTitleToNSPanel(String dialogTitle) {
        if (dialogTitle != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            this.getDialog().setTitle(dialogTitle);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setDialogType(int dialogType) {
        if (dialogType == 2) {
            dialogType = 0;
        }
        if (dialogType == 0 || dialogType == 1) {
            if (this.getDialogType() != dialogType && !this._isShowing) {
                this.dumpDialog();
                this._dialogType = dialogType;
            }
        } else {
            throw new IllegalArgumentException("This implementation of dialog supports only JFileChooser.OPEN_DIALOG and JFileChooser.SAVE_DIALOG types");
        }
        this.notifyListeners("DialogTypeChangedProperty");
    }

    private void dumpDialog() {
        if (this._dialog != null && this.isRequireExplicitCleanup()) {
            this._dialog.release();
        }
        this._dialog = null;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this._allowMultipleSelection = b;
        if (this._dialog != null) {
            this.setMultipleSelectionEnabledToNSPanel(b);
        }
        this.notifyListeners("MultiSelectionEnabledChangedProperty");
    }

    private void setMultipleSelectionEnabledToNSPanel(boolean allowMultipleSelection) {
        if (this.getDialogType() == 0) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            ((NSOpenPanel)this.getDialog()).setAllowsMultipleSelection(allowMultipleSelection);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setFileSelectionMode(int mode) {
        if (this._fileSelectionMode == mode) {
            return;
        }
        this._fileSelectionMode = mode;
        if (this._dialog != null) {
            this.setFileSelectionModeToNSPanel(mode);
        }
        this.notifyListeners("fileSelectionChanged");
    }

    private void setFileSelectionModeToNSPanel(int fileSelectionMode) {
        if (fileSelectionMode != -1 && this.getDialogType() == 0) {
            NSOpenPanel dialog = (NSOpenPanel)this.getDialog();
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            if (fileSelectionMode == 0) {
                dialog.setCanChooseFiles(true);
                dialog.setCanChooseDirectories(false);
            } else if (fileSelectionMode == 1) {
                dialog.setCanChooseFiles(false);
                dialog.setCanChooseDirectories(true);
            } else if (fileSelectionMode == 2) {
                dialog.setCanChooseFiles(true);
                dialog.setCanChooseDirectories(true);
            }
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        return this.showDialog(approveButtonText);
    }

    private int showDialog(final String approveButtonText) {
        final int[] result = new int[]{-1};
        AwtMacMessageLoop.getInstance().invokeAndWait(new Runnable(){

            public void run() {
                NSAutoreleasePool autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
                FileChooserImpl.this.passDialogParametersToNSPanel(approveButtonText);
                FileChooserImpl.this._isShowing = true;
                long returnValue = FileChooserImpl.this.getDialog().runModal().getValue();
                FileChooserImpl.this._isShowing = false;
                if (returnValue == 1L) {
                    FileChooserImpl.this.refreshFiles();
                    result[0] = 0;
                } else if (returnValue == 0L) {
                    result[0] = 1;
                }
                FileChooserImpl.this.getCurrentDirectory();
                FileChooserImpl.this.dumpDialog();
                autoreleasePool.drain();
            }
        });
        if (result[0] == 0) {
            this.notifyListeners("ApproveSelection");
        } else if (result[0] == 1) {
            this.notifyListeners("CancelSelection");
        }
        return result[0];
    }

    private void setTitleToNSPanel(String approveButtonText) {
        if (approveButtonText != null && approveButtonText.length() != 0) {
            this.getDialog().setPrompt(approveButtonText);
        }
    }

    private void refreshFiles() {
        this._files.clear();
        NSAutoreleasePool autoreleasePool = null;
        if (this.isRequireExplicitCleanup()) {
            autoreleasePool = NSAutoreleasePool.alloc();
            autoreleasePool.init();
        }
        if (this.getDialogType() == 0) {
            if (MINOR_OS_VERSION < 6) {
                NSArray files = new NSArray(((NSOpenPanel)this.getDialog()).filenames());
                long filesCount = files.count().getValue();
                int i = 0;
                while ((long)i < filesCount) {
                    NSString folderName = new NSString((Pointer.Void)files.objectAtIndex(new UInt16(i)));
                    this._files.add(new File(folderName.cString().getValue()));
                    ++i;
                }
            } else {
                Pointer.Void pointerToArrayOfURLs = ((NSOpenPanel)this.getDialog()).URLs();
                NSArray arrayOfURLs = new NSArray(pointerToArrayOfURLs);
                long urlsCount = arrayOfURLs.count().getValue();
                int i = 0;
                while ((long)i < urlsCount) {
                    Id pointerToURL = arrayOfURLs.objectAtIndex(new UInt16(i));
                    File fileFromNsUrl = this.getFileFromNsUrl((Pointer.Void)pointerToURL);
                    if (fileFromNsUrl != null) {
                        this._files.add(fileFromNsUrl);
                    }
                    ++i;
                }
            }
        } else if (MINOR_OS_VERSION < 6) {
            Pointer.Void pointerToFileName = this.getDialog().filename();
            File fileFromNsString = this.getFileFromNsString(pointerToFileName);
            if (fileFromNsString != null) {
                this._files.add(fileFromNsString);
            }
        } else {
            Pointer.Void pointerToFileUrl = this.getDialog().URL();
            File fileFromNsUrl = this.getFileFromNsUrl(pointerToFileUrl);
            if (fileFromNsUrl != null) {
                this._files.add(fileFromNsUrl);
            }
        }
        if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
            autoreleasePool.drain();
        }
    }

    private void passDialogParametersToNSPanel(String approveButtonText) {
        NSSavePanel nsSavePanel = this.getDialog();
        this.setTitleToNSPanel(approveButtonText);
        this.setFileSelectionModeToNSPanel(this._fileSelectionMode);
        if (MINOR_OS_VERSION <= 6) {
            nsSavePanel.setAllowsOtherFileTypes(true);
            nsSavePanel.setExtensionHidden(false);
        }
        this.setDialogTitleToNSPanel(this._dialogTitle);
        this.setMultipleSelectionEnabledToNSPanel(this._allowMultipleSelection);
        if (!this._files.isEmpty()) {
            this.setSelectedFileToNSPanel(this._files.get(0));
        }
        this.setDialogTitleToNSPanel(this._dialogTitle);
    }

    private int getDialogType() {
        return this._dialogType;
    }

    private boolean isAllowMultipleSelection() {
        return this._allowMultipleSelection;
    }

    private int getFileSelectionMode() {
        return this._fileSelectionMode;
    }

    private String getDialogTitle() {
        return this._dialogTitle;
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(null);
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(null);
    }

    public File getSelectedFile() {
        File result = null;
        this.refreshFiles();
        if (this._files.size() > 0) {
            result = this._files.get(0);
        }
        return result;
    }

    public void setSelectedFile(File file) {
        String newFilePath = this.extractDirectoryName(file);
        File currentDirectory = this.getCurrentDirectory();
        String currentFilePath = null;
        if (currentDirectory != null) {
            currentFilePath = currentDirectory.getAbsolutePath();
        }
        if (!newFilePath.equals(currentFilePath)) {
            this.setCurrentDirectory(new File(newFilePath));
        }
        this._files.clear();
        this._files.add(file);
        if (this._dialog != null) {
            this.setSelectedFileToNSPanel(file);
        }
    }

    private void setSelectedFileToNSPanel(File file) {
        NSAutoreleasePool autoreleasePool = null;
        if (this.isRequireExplicitCleanup()) {
            autoreleasePool = NSAutoreleasePool.alloc();
            autoreleasePool.init();
        }
        if (MINOR_OS_VERSION >= 6) {
            NSString fileNameNSString = new NSString(file.getName());
            this.getDialog().setNameFieldStringValue(fileNameNSString);
        }
        if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
            autoreleasePool.drain();
        }
    }

    public File[] getSelectedFiles() {
        File[] result = new File[1];
        File[] resultFiles = this._files.toArray(result);
        if (this._files.size() > 1) {
            result = resultFiles;
        }
        return result;
    }

    private String extractDirectoryName(File file) {
        String directoryName = "/";
        StringBuffer buffer = new StringBuffer(file.getAbsolutePath());
        int directoryNameLength = buffer.lastIndexOf(file.getName()) - 1;
        buffer.delete(directoryNameLength, buffer.length());
        if (directoryNameLength != 0) {
            directoryName = buffer.toString();
        }
        return directoryName;
    }

    private void notifyListeners(String command) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, command);
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void notifyListenersAsynchronously(final String command) {
        AwtMacMessageLoop.getInstance().invokeLater(new Runnable(){

            public void run() {
                FileChooserImpl.this.notifyListeners(command);
            }
        });
    }

    private NSSavePanel getDialog() {
        if (this._dialog == null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            switch (this.getDialogType()) {
                case 0: {
                    this._dialog = new NSOpenPanel();
                    break;
                }
                case 1: {
                    this._dialog = new NSSavePanel();
                }
            }
            this._dialog.retain();
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
        return this._dialog;
    }

    public void setFileView(FileView fileView) {
    }

    public void setFileFilter(FileFilter filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        String osVersion = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(osVersion, ".");
        stringTokenizer.nextToken();
        String minorVersion = stringTokenizer.nextToken();
        MINOR_OS_VERSION = Integer.parseInt(minorVersion);
    }
}

