/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import se.datadosen.jalbum.JAlbumColor;

public class JSiteButton
extends JButton {
    protected boolean showLabel = true;
    protected boolean mouseOver = false;
    protected boolean mousePressed = false;
    private boolean borderPainted = true;
    private int borderRadius = 4;
    private boolean uiSet = false;

    public JSiteButton() {
        this.init();
    }

    public JSiteButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JSiteButton(Action a) {
        super(a);
        this.init();
    }

    public JSiteButton(Action a, boolean showLabel) {
        this.showLabel = showLabel;
        this.setAction(a);
        this.init();
    }

    public JSiteButton(String text) {
        this.init();
        super.setText(text);
    }

    public JSiteButton(Icon icon) {
        super(icon);
        this.init();
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setUI(ButtonUI newUI) {
        if (!this.uiSet) {
            super.setUI(newUI);
            this.uiSet = true;
        }
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean b) {
        this.borderPainted = b;
        this.repaint();
    }

    private void init() {
        super.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        this.setContentAreaFilled(false);
        super.setBorderPainted(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                JSiteButton.this.mouseOver = false;
                JSiteButton.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                JSiteButton.this.mousePressed = true;
            }

            public void mouseReleased(MouseEvent e) {
                JSiteButton.this.mousePressed = false;
                JSiteButton.this.repaint();
            }

            public void mouseEntered(MouseEvent e) {
                JSiteButton.this.mouseOver = true;
                JSiteButton.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                JSiteButton.this.mouseOver = false;
                JSiteButton.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g2d) {
        Graphics2D g = (Graphics2D)g2d;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (this.isEnabled()) {
            g.setColor(this.mousePressed ? JAlbumColor.darken(this.getBackground(), 10) : this.getBackground());
        } else {
            g.setColor(SystemColor.textInactiveText);
        }
        if (this.mouseOver && this.isEnabled()) {
            g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
        } else if (this.borderPainted) {
            g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.borderRadius * 2, this.borderRadius * 2);
        }
        super.paintComponent(g);
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }
}

