/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import se.datadosen.component.MapClip;
import se.datadosen.jalbum.Msg;

public class JMapTable
extends JTable
implements ClipboardOwner {
    static ImageIcon cutIcon = new ImageIcon(JMapTable.class.getResource("images/cut.png"));
    static ImageIcon copyIcon = new ImageIcon(JMapTable.class.getResource("images/copy.png"));
    static ImageIcon pasteIcon = new ImageIcon(JMapTable.class.getResource("images/paste.png"));
    static ImageIcon removeSelectionIcon = new ImageIcon(JMapTable.class.getResource("images/selection_delete.png"));
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private boolean editable = true;
    private Vector<Map.Entry> items = new Vector();
    private MapModel theModel = new MapModel();
    private Color oddColor;
    private Action pasteAction;

    public JMapTable() {
        SystemColor c = SystemColor.textHighlight;
        this.oddColor = new Color(0, 0, 64, 8);
        super.setModel(new DefaultTableModel());
        super.setRowSelectionAllowed(false);
        this.setSelectionMode(1);
        this.setRowSelectionAllowed(true);
        this.setGridColor(Color.lightGray);
        JPopupMenu popup = new JPopupMenu();
        AbstractAction cutAction = new AbstractAction(Msg.get("edit.cut"), cutIcon){

            public void actionPerformed(ActionEvent e) {
                int[] rows = JMapTable.this.getSelectedRows();
                if (rows.length > 0) {
                    Vector<Map.Entry> clip = JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                    JMapTable.this.clipboard.setContents(new MapClip(clip), JMapTable.this);
                    JMapTable.this.handlePasteEnabling();
                }
            }
        };
        AbstractAction copyAction = new AbstractAction(Msg.get("edit.copy"), copyIcon){

            public void actionPerformed(ActionEvent e) {
                int[] rows = JMapTable.this.getSelectedRows();
                if (rows.length > 0) {
                    Vector<Map.Entry> clip = JMapTable.this.theModel.getRows(rows[0], rows[rows.length - 1]);
                    JMapTable.this.clipboard.setContents(new MapClip(clip), JMapTable.this);
                    JMapTable.this.handlePasteEnabling();
                }
            }
        };
        this.pasteAction = new AbstractAction(Msg.get("edit.paste"), pasteIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                Transferable t = JMapTable.this.clipboard.getContents(JMapTable.this);
                try {
                    int lastRow;
                    Vector content = t.isDataFlavorSupported(MapClip.mapFlavor) ? (Vector)t.getTransferData(MapClip.mapFlavor) : this.parseStringFromClipboard(t);
                    int[] rows = JMapTable.this.getSelectedRows();
                    int firstRow = rows.length > 0 ? rows[0] : 0;
                    int n = lastRow = rows.length > 0 ? rows[rows.length - 1] : 0;
                    if (lastRow > firstRow) {
                        JMapTable.this.theModel.deleteRows(firstRow, lastRow);
                    }
                    JMapTable.this.theModel.insertRows(firstRow, content);
                }
                catch (IOException ex) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }

            private Vector<Map.Entry> parseStringFromClipboard(Transferable t) throws UnsupportedFlavorException, IOException {
                String line;
                Vector<Map.Entry> rows = new Vector<Map.Entry>();
                String content = (String)t.getTransferData(DataFlavor.stringFlavor);
                BufferedReader reader = new BufferedReader(new StringReader(content));
                char[] delims = new char[]{'=', '\t', ',', ';', ':'};
                while ((line = reader.readLine()) != null) {
                    String key = line;
                    String value = "";
                    int indexOfEquals = JMapTable.this.indexOf(line, delims);
                    if (indexOfEquals >= 0) {
                        key = line.substring(0, indexOfEquals);
                        value = line.substring(indexOfEquals + 1);
                    }
                    key = key.trim();
                    value = value.trim();
                    rows.add(new Entry(key, value));
                }
                return rows;
            }
        };
        AbstractAction deleteAction = new AbstractAction(Msg.get("edit.delete"), removeSelectionIcon){

            public void actionPerformed(ActionEvent e) {
                int[] rows = JMapTable.this.getSelectedRows();
                if (rows.length > 0) {
                    JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                }
            }
        };
        this.handlePasteEnabling();
        popup.add(cutAction);
        popup.add(copyAction);
        popup.add(this.pasteAction);
        popup.add(deleteAction);
        this.setComponentPopupMenu(popup);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int[] rows;
                if (e.getKeyCode() == 127 && (rows = JMapTable.this.getSelectedRows()).length > 0) {
                    JMapTable.this.theModel.deleteRows(rows[0], rows[rows.length - 1]);
                    e.consume();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private int indexOf(String s, char[] delims) {
        int i = -1;
        for (char delim : delims) {
            i = s.indexOf(delim);
            if (i < 0) continue;
            return i;
        }
        return i;
    }

    private void handlePasteEnabling() {
        DataFlavor[] flavors;
        boolean supported = false;
        for (DataFlavor flavor : flavors = this.clipboard.getAvailableDataFlavors()) {
            if (!flavor.equals(MapClip.mapFlavor) && !flavor.equals(DataFlavor.stringFlavor)) continue;
            supported = true;
        }
        this.pasteAction.setEnabled(supported);
    }

    public JMapTable(String nameLabel, String valueLabel) {
        this();
        this.setHeaderNames(nameLabel, valueLabel);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
        if (this.isCellSelected(rowIndex, colIndex)) {
            c.setBackground(SystemColor.textHighlight);
        } else if (rowIndex % 2 == 1) {
            c.setBackground(this.oddColor);
        } else {
            c.setBackground(this.getBackground());
        }
        c.setForeground(SystemColor.textText);
        return c;
    }

    public void setCellEditable(boolean editable) {
        this.editable = editable;
    }

    public void setHeaderNames(String nameLabel, String valueLabel) {
        this.theModel = new MapModel();
        this.theModel.colNames[0] = nameLabel;
        this.theModel.colNames[1] = valueLabel;
        super.setModel(this.theModel);
    }

    public void clear() {
        this.items.clear();
        this.theModel.fireTableDataChanged();
    }

    public Map getMap() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        HashMap theMap = new HashMap();
        for (Map.Entry item : this.items) {
            if (item.getKey().toString().equals("")) continue;
            theMap.put(item.getKey(), item.getValue());
        }
        return theMap;
    }

    public void putAll(Map theMap) {
        Iterator it = theMap.entrySet().iterator();
        while (it.hasNext()) {
            this.items.add(it.next());
        }
        Map.Entry[] entries = this.items.toArray(new Map.Entry[this.items.size()]);
        Arrays.sort(entries, new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry o1, Map.Entry o2) {
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        });
        this.items.clear();
        for (Map.Entry entry : entries) {
            this.items.add(entry);
        }
        this.theModel.fireTableDataChanged();
    }

    public void put(Object key, Object value) {
        this.items.add(new Entry(key, value));
        this.theModel.fireTableDataChanged();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.handlePasteEnabling();
    }

    class Entry
    implements Map.Entry {
        Object key;
        Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object other) {
            return this.key.equals(((Entry)other).key);
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object parm1) {
            this.value = parm1;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapModel
    extends AbstractTableModel {
        public String[] colNames = new String[]{"Name", "Value"};

        MapModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JMapTable.this.editable;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames[col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return JMapTable.this.items.size() + 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                return "";
            }
            Map.Entry item = (Map.Entry)JMapTable.this.items.get(row);
            return col == 0 ? item.getKey() : item.getValue();
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                Entry item = col == 0 ? new Entry(aValue, "") : new Entry("", aValue);
                JMapTable.this.items.add(item);
            } else {
                Map.Entry oldItem = (Map.Entry)JMapTable.this.items.get(row);
                Entry item = col == 0 ? new Entry(aValue, oldItem.getValue()) : new Entry(oldItem.getKey(), aValue);
                JMapTable.this.items.set(row, item);
            }
        }

        public void insertRows(int index, Collection<Map.Entry> rows) {
            JMapTable.this.items.addAll(index, rows);
            this.fireTableRowsInserted(index, index + rows.size());
        }

        public Vector<Map.Entry> deleteRows(int firstRow, int lastRow) {
            Vector<Map.Entry> rows = new Vector<Map.Entry>();
            if (lastRow >= JMapTable.this.items.size()) {
                lastRow = JMapTable.this.items.size() - 1;
            }
            for (int i = lastRow; i >= firstRow; --i) {
                rows.add((Map.Entry)JMapTable.this.items.remove(i));
            }
            this.fireTableRowsDeleted(firstRow, lastRow);
            return rows;
        }

        public Vector<Map.Entry> getRows(int firstRow, int lastRow) {
            Vector<Map.Entry> rows = new Vector<Map.Entry>();
            if (lastRow >= JMapTable.this.items.size()) {
                lastRow = JMapTable.this.items.size() - 1;
            }
            for (int i = lastRow; i >= firstRow; --i) {
                rows.add((Map.Entry)JMapTable.this.items.get(i));
            }
            return rows;
        }
    }
}

