/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import se.datadosen.util.Platform;

public class CurvedLineBorder
implements Border {
    private int roundness;
    private Color lineColor;

    public CurvedLineBorder() {
        if (Platform.isMac()) {
            this.roundness = 11;
            this.lineColor = "Dark".equals(UIManager.getLookAndFeel().getName()) ? new Color(200, 200, 200) : new Color(0, 0, 0, 25);
        } else {
            this.roundness = 8;
            this.lineColor = new Color(0, 0, 0, 60);
        }
    }

    public CurvedLineBorder(Color lineColor) {
        this();
        this.lineColor = lineColor;
    }

    public void paintBorder(Component c, Graphics gg, int x, int y, int w, int h) {
        Graphics2D g = (Graphics2D)gg;
        if ("Dark".equals(UIManager.getLookAndFeel().getName())) {
            g.setColor(UIManager.getColor("panelColor"));
            g.fillRoundRect(x, y, w - 1, h - 1, this.roundness, this.roundness);
        } else {
            if (Platform.isMac()) {
                g.setColor(new Color(0, 0, 0, 7));
                g.fillRoundRect(x, y, w - 1, h - 1, this.roundness, this.roundness);
                g.setColor(new Color(0, 0, 0, 9));
                g.drawRoundRect(x, y + 1, w - 1, h - 2, this.roundness - 1, this.roundness - 1);
                g.drawRoundRect(x, y + 1, w - 1, h - 2, this.roundness - 1, this.roundness - 1);
                g.drawRoundRect(x, y + 2, w - 1, h - 3, this.roundness - 1, this.roundness - 1);
                g.drawRoundRect(x + 1, y + 1, w - 3, h - 3, this.roundness - 1, this.roundness - 1);
                g.setColor(new Color(0, 0, 0, 25));
                g.drawLine(x + 6, y, w - 8, y);
                g.drawLine(x + 4, y, w - 4, y);
            }
            g.setColor(this.lineColor);
            g.drawRoundRect(x, y, w - 1, h - 1, this.roundness, this.roundness);
        }
    }

    public Insets getBorderInsets(Component c) {
        return Platform.isMac() ? new Insets(1, 1, 1, 1) : new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

