/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JFileChooser;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JDirectoryChooser;
import se.datadosen.component.JSwingFileChooser;
import se.datadosen.component.JXFileChooser;
import se.datadosen.component.MacAWTDirectoryChooser;
import se.datadosen.component.MacAWTFileChooser;
import se.datadosen.component.mac.FileChooserImpl;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.util.Platform;
import se.datadosen.util.VersionNumber;

public class ChooserFactory {
    public static DirectoryChooser createDirectoryChooser(Frame parent) {
        if (Platform.isMac()) {
            return new MacAWTDirectoryChooser(parent);
        }
        return new DeferredChooser(JDirectoryChooser.class);
    }

    public static DirectoryChooser createDirectoryChooser(Dialog parent) {
        if (Platform.isMac()) {
            return new MacAWTDirectoryChooser(parent);
        }
        return new DeferredChooser(JDirectoryChooser.class);
    }

    public static FileChooser createFileChooser(Frame parent) {
        if (Platform.isMac()) {
            return new MacAWTFileChooser(parent);
        }
        return new DeferredChooser(JFileChooser.class);
    }

    public static FileChooser createFileChooser(Dialog parent) {
        if (Platform.isMac()) {
            return new MacAWTFileChooser(parent);
        }
        return new DeferredChooser(JFileChooser.class);
    }

    public static FileChooser createFilesChooser(Frame parent) {
        if (Platform.isMac() && Config.getConfig().isUseNativeFileDialogs()) {
            try {
                if (new VersionNumber(System.getProperty("java.specification.version")).compareTo(new VersionNumber("1.7")) >= 0) {
                    MacAWTFileChooser chooser = new MacAWTFileChooser(parent);
                    chooser.setMultiSelectionEnabled(true);
                    return chooser;
                }
                return new FileChooserImpl();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        return Platform.isWindows() ? new JXFileChooser() : new JSwingFileChooser();
    }
}

