/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util.httpClient;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import se.datadosen.util.IO;
import se.datadosen.util.httpClient.Part;

public class FilePart
extends Part {
    private String fileName;
    private File file;
    private byte[] content;

    public FilePart(String name, File file) throws IOException {
        super(name);
        this.file = file;
        this.fileName = file.getName();
        this.content = IO.readBytes(file);
    }

    public FilePart(String name, String fileName, byte[] content) {
        super(name);
        if (content == null) {
            throw new NullPointerException("Null file content for " + fileName);
        }
        this.fileName = fileName;
        this.content = content;
    }

    public long getContentLength() {
        if (this.file != null) {
            return this.file.length();
        }
        return super.getContentLength();
    }

    protected byte[] doGetContent() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            out.write("Content-Disposition: form-data; name=\"" + this.name + "\"");
            out.write("; filename=\"" + this.fileName + "\"\r\n");
            out.write("Content-Type: " + this.getMimeType(this.fileName) + "\r\n");
            out.write("Content-Transfer-Encoding: binary\r\n");
            out.write("\r\n");
            out.flush();
            bos.write(this.content);
            return bos.toByteArray();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getMimeType(String fileName) {
        String ext = IO.extensionOf(fileName).toLowerCase();
        if ("jpeg".equals(ext) || "jpg".equals(ext)) {
            return "image/jpeg";
        }
        if ("gif".equals(ext)) {
            return "image/gif";
        }
        if ("png".equals(ext)) {
            return "image/png";
        }
        return "application/octet-stream";
    }
}

