/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinProperties {
    public static final String TITLE = "title";
    public static final String AUTHOR = "author";
    public static final String USERNAME = "username";
    public static final String COMPANY = "company";
    public static final String VERSION = "version";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String DESCRIPTION = "description";
    public static final String HOME_PAGE = "homePage";
    public static final String SUPPORT_FORUM = "supportForum";
    public static final String REQUIRED_JALBUM_VERSION = "requiredJalbumVersion";
    public static final String REQUIRED_JAVA_VERSION = "requiredJavaVersion";
    public static final String AUTO_WIDGET_INJECTION = "autoWidgetInjection";
    public static final String TRUE_ORIGINAL_PATH = "trueOriginalPath";
    private Map<String, String> theMap = new HashMap<String, String>();
    private File file;

    public SkinProperties(File skinDir) {
        this.file = new File(skinDir, "skin.properties");
        if (this.file.exists()) {
            try {
                this.theMap = IO.readMapFile(this.file);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void save() throws IOException {
        IO.writeMapFile(this.theMap, this.file);
    }

    public String getProperty(String key) {
        return this.theMap.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.theMap.get(key);
        return value != null ? value : def;
    }

    public Map<String, String> getProperties() {
        return this.theMap;
    }

    public void setProperty(String key, String value) {
        this.theMap.put(key, value);
    }

    public boolean isAutoWidgetInjection() {
        String s = this.theMap.get(AUTO_WIDGET_INJECTION);
        return !"false".equals(s);
    }

    public boolean isTrueOriginalPath() {
        String s = this.theMap.get(TRUE_ORIGINAL_PATH);
        return "true".equals(s);
    }
}

