/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import com.adobe.xmp.XMPException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.Autocompleter;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.JPlainButton;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFilter;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.Multilingual;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFilterBar
extends JPanel
implements AlbumObjectFilter,
ActionListener {
    private JAlbumExplorer context;
    @ToolTipText(value="close")
    private JButton closeButton = new JPlainButton(Icons.getIcon("small.abort"), (Icon)Icons.getIcon("small.abort1"));
    @Text(value="ui.filters", postfix=": ")
    private JLabel filterLabel = new JLabel();
    private JToggleButton[] starButtons = new JToggleButton[6];
    private final Flag[] flags = Flag.values();
    private JToggleButton[] flagButtons = new JToggleButton[Flag.values().length];
    @ToolTipText(value="ui.keywordFilterToolTip")
    JKeywordsField keywordsField = new JKeywordsField(12);
    private Node keywordExpression;
    private ScheduledExecutorService refilterExecutor = Executors.newSingleThreadScheduledExecutor();
    private Future refilterFuture;
    private Runnable refilterRunnable = new Runnable(){
        private Runnable forAWTThread = new Runnable(){

            public void run() {
                JFilterBar.this.actionPerformed(null);
            }
        };

        public void run() {
            JFilterBar.this.keywordExpression = JFilterBar.this.parseKeywordExpression(JFilterBar.this.keywordsField.getText().toLowerCase());
            SwingUtilities.invokeLater(this.forAWTThread);
        }
    };
    @ToolTipText(value="ui.resetFilters")
    Action resetFilterAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("small.filter.off"));
        }

        public void actionPerformed(ActionEvent e) {
            for (JToggleButton tb : JFilterBar.this.starButtons) {
                tb.setSelected(false);
            }
            for (JToggleButton tb : JFilterBar.this.flagButtons) {
                tb.setSelected(false);
            }
            if (JFilterBar.this.keywordsField.getText().length() > 0) {
                JFilterBar.this.keywordsField.setText("");
            } else {
                JFilterBar.this.actionPerformed(e);
            }
        }
    };
    private JButton resetFilterButton = new JPlainButton(this.resetFilterAction);

    public JFilterBar(JAlbumExplorer context) {
        super(new BorderLayout());
        this.context = context;
        this.init();
    }

    private boolean acceptRating(AlbumObject ao) {
        int rating = ao.getRating();
        if (this.starButtons[rating].isSelected()) {
            return true;
        }
        for (JToggleButton tb : this.starButtons) {
            if (!tb.isSelected()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptFlag(AlbumObject ao) {
        Flag flag = ao.getFlag();
        if (this.flagButtons[flag.ordinal()].isSelected()) {
            return true;
        }
        for (JToggleButton tb : this.flagButtons) {
            if (!tb.isSelected()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptKeywords(AlbumObject ao) {
        if (this.keywordExpression != null) {
            XmpManager mgr = ao.getXmpManager();
            if (mgr != null) {
                try {
                    return this.keywordExpression.eval(this.toLowerCase(mgr.getKeywordSet()));
                }
                catch (XMPException xMPException) {
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private Set<String> toLowerCase(Set<String> set) {
        TreeSet<String> newSet = new TreeSet<String>();
        for (String s : set) {
            newSet.add(s.toLowerCase());
        }
        return newSet;
    }

    @Override
    public boolean accept(AlbumObject ao) {
        return this.acceptRating(ao) && this.acceptFlag(ao) && this.acceptKeywords(ao);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.context.applyFilters();
        this.context.updateStatusBar();
    }

    private void init() {
        JPlainToggleButton tb;
        int i;
        Msg.maintainTranslated(this);
        new Autocompleter(this.keywordsField, this.context.knownKeywords);
        this.keywordsField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.expressionUpdated();
            }

            public void removeUpdate(DocumentEvent e) {
                this.expressionUpdated();
            }

            public void changedUpdate(DocumentEvent e) {
                this.expressionUpdated();
            }

            private void expressionUpdated() {
                if (JFilterBar.this.refilterFuture != null) {
                    JFilterBar.this.refilterFuture.cancel(false);
                }
                JFilterBar.this.refilterFuture = JFilterBar.this.refilterExecutor.schedule(JFilterBar.this.refilterRunnable, 200L, TimeUnit.MILLISECONDS);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((JFilterBar)JFilterBar.this).context.filterBarAction.putValue("SwingSelectedKey", false);
                ((JFilterBar)JFilterBar.this).context.filterBarAction.actionPerformed(e);
            }
        });
        JPanel content = new JPanel();
        content.add(this.filterLabel);
        for (i = 0; i <= 5; ++i) {
            tb = new JPlainToggleButton(Icons.getIcon("small.star" + i));
            tb.setSelectedIcon(Icons.getIcon("small.star.selected" + i));
            tb.setToolTipText(Msg.get("ui.ratingToolTip", i));
            tb.addActionListener(this);
            this.starButtons[i] = tb;
            content.add(tb);
        }
        content.add(new JLabel("+"));
        this.starButtons[0].setToolTipText(Msg.get("edit.unrated"));
        for (i = 0; i < this.flagButtons.length; ++i) {
            tb = new JPlainToggleButton(this.flags[i].getIcon());
            tb.setSelectedIcon(this.flags[i].getSelectedIcon());
            tb.setToolTipText(this.flags[i].toString());
            tb.addActionListener(this);
            this.flagButtons[i] = tb;
            content.add(tb);
        }
        content.add(new JLabel("+ "));
        content.add(this.keywordsField);
        content.add(this.resetFilterButton);
        this.add((Component)content, "Before");
        JPanel controlPanel = new JPanel(new FlowLayout(0, 0, 3));
        controlPanel.add(this.closeButton);
        controlPanel.add(Box.createHorizontalStrut(4));
        this.add((Component)controlPanel, "After");
        this.validate();
    }

    private Node parseKeywordExpression(String expr) {
        if (expr.indexOf(44) != -1) {
            OrNode orNode = new OrNode();
            StringTokenizer tokens = new StringTokenizer(expr, ",;");
            while (tokens.hasMoreTokens()) {
                orNode.addChild(this.parseKeywordExpression(tokens.nextToken()));
            }
            return orNode;
        }
        if (expr.indexOf(43) != -1) {
            AndNode andNode = new AndNode();
            StringTokenizer tokens = new StringTokenizer(expr, "+");
            while (tokens.hasMoreTokens()) {
                andNode.addChild(new Leaf(tokens.nextToken()));
            }
            return andNode;
        }
        if (expr.trim().length() > 0) {
            return new Leaf(expr);
        }
        return null;
    }

    static class JPlainToggleButton
    extends JToggleButton {
        public JPlainToggleButton(Icon icon) {
            super(icon);
            this.init();
        }

        public void setBorder(Border border) {
        }

        public void setRealBorder(Border border) {
            super.setBorder(border);
        }

        private void init() {
            super.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
        }
    }

    static class JKeywordsField
    extends JBackgroundTextField
    implements Multilingual {
        public JKeywordsField(int chars) {
            super(chars);
        }

        public void languageUpdated() {
            this.setBackgroundText(Msg.get("edit.keywords"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrNode
    extends LogicNode {
        private OrNode() {
        }

        @Override
        boolean eval(Set<String> keywords) {
            for (Node node : this.children) {
                if (node == null || !node.eval(keywords)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndNode
    extends LogicNode {
        private AndNode() {
        }

        @Override
        boolean eval(Set<String> keywords) {
            for (Node node : this.children) {
                if (node == null || node.eval(keywords)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class LogicNode
    extends Node {
        protected List<Node> children = new ArrayList<Node>();

        private LogicNode() {
        }

        public void addChild(Node child) {
            this.children.add(child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Leaf
    extends Node {
        private String keyword;

        public Leaf(String keyword) {
            this.keyword = keyword.trim();
        }

        @Override
        boolean eval(Set<String> keywords) {
            return keywords.contains(this.keyword);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Node {
        private Node() {
        }

        abstract boolean eval(Set<String> var1);
    }
}

