/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JCopyWarningDialog;
import se.datadosen.explorer.SmartFlowLayout;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileAddBehaviorInfo;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JNewProjectDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JExplorerPanel
extends JPanel
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    public static final String NAME = "explorerPanel";
    static final int SMALL_OBJECT_SIZE = 96;
    static final int LARGE_OBJECT_SIZE = 160;
    static final int LABEL_HEIGHT = 20;
    SmartFlowLayout explorerThumbsLayout = new SmartFlowLayout();
    Rectangle rubberband;
    private Point caretLocation;
    ExplorerSelectionModel selectionModel = new ExplorerSelectionModel(this);
    final JAlbumExplorer context;
    JAlbumObject closestComp;
    JAlbumObject dropFolder;
    boolean insertBefore;
    private LinkedList<JAlbumObject> draggedObjects;
    private transient Vector structureListeners;
    Dimension iconBounds;
    Dimension objectSize;
    private String backgroundText;
    private int sourceActions;

    public JExplorerPanel(JAlbumExplorer context) {
        this.context = context;
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JExplorerPanel.this.requestFocusInWindow();
            }
        });
        this.setBackground(SystemColor.text);
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
        if (context.parent.preferencesWindow.largeThumbnails.isSelected()) {
            this.setIconBounds(new Dimension(160, 160));
        } else {
            this.setIconBounds(new Dimension(96, 96));
        }
        this.explorerThumbsLayout.setAlignment(0);
        this.explorerThumbsLayout.setHgap(32);
        this.explorerThumbsLayout.setVgap(26);
        this.setLayout(this.explorerThumbsLayout);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void setIconBounds(Dimension bounds) {
        this.iconBounds = bounds;
        this.objectSize = new Dimension(this.iconBounds.width, this.iconBounds.height + 20);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension p = super.getPreferredSize();
        int preferredWidth = this.getParent().getWidth();
        return new Dimension(preferredWidth, p.height);
    }

    private boolean isProjectLoaded() {
        return this.context.rootFolder != null && this.context.rootFolder.getName().length() > 0;
    }

    public String getBackgroundText() {
        return this.backgroundText;
    }

    public void setBackgroundText(String backgroundText) {
        this.backgroundText = backgroundText;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.rubberband != null) {
            this.paintRubberband(g);
        }
        if (this.caretLocation != null) {
            this.paintCaret(g);
        }
        if (this.dropFolder != null) {
            this.paintDropTargetFolder(g);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.backgroundText != null) {
            g.setColor(Color.darkGray);
            Font originalFont = g.getFont();
            g.setFont(originalFont.deriveFont(20.0f));
            FontMetrics fm = g.getFontMetrics();
            String s = this.backgroundText;
            Rectangle2D rect = fm.getStringBounds(s, g);
            LineMetrics lm = fm.getLineMetrics(s, g);
            g.drawString(s, (int)((double)this.getWidth() - rect.getWidth()) / 2, (int)((double)lm.getAscent() + ((double)this.getHeight() - rect.getHeight()) / 2.0));
            g.setFont(originalFont);
        }
    }

    private void paintRubberband(Graphics g) {
        g.setColor(JAlbumColor.rubberBand);
        g.fillRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        g.setColor(SystemColor.textHighlight);
        g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
    }

    private void paintCaret(Graphics g) {
        g.setColor(Color.black);
        Point cl = this.caretLocation;
        int h = this.objectSize.height + 4;
        g.fillRect(cl.x, cl.y, 2, h);
        g.drawLine(cl.x - 2, cl.y, cl.x + 3, cl.y);
        g.drawLine(cl.x - 1, cl.y + 1, cl.x + 2, cl.y + 1);
        g.drawLine(cl.x - 2, cl.y + h, cl.x + 3, cl.y + h);
        g.drawLine(cl.x - 1, cl.y + h - 1, cl.x + 2, cl.y + h - 1);
    }

    private void paintDropTargetFolder(Graphics g) {
        Rectangle r = this.dropFolder.getBounds();
        g.setColor(JAlbumColor.rubberBand);
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    JAlbumObject getPreviousComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (comps[i] != rel) continue;
            while (i >= 1) {
                if (!comps[--i].isVisible()) continue;
                return (JAlbumObject)comps[i];
            }
        }
        return null;
    }

    JAlbumObject getNextComponent(JAlbumObject rel) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length - 1; ++i) {
            if (comps[i] != rel) continue;
            while (i < comps.length - 1) {
                if (!comps[++i].isVisible()) continue;
                return (JAlbumObject)comps[i];
            }
        }
        return null;
    }

    Component getNearestComponent(Point p) {
        Component nearestComp = null;
        Rectangle smallest = null;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Rectangle bounds = comps[i].getBounds();
            if (bounds.contains(p)) {
                return comps[i];
            }
            bounds.add(p);
            if (smallest != null && bounds.width * bounds.height >= smallest.width * smallest.height) continue;
            smallest = bounds;
            nearestComp = comps[i];
        }
        return nearestComp;
    }

    private static String dndActionsToString(int sa) {
        return ((sa & 1) != 0 ? "ACTION_COPY " : "") + ((sa & 2) != 0 ? "ACTION_MOVE " : "") + ((sa & 0x40000000) != 0 ? "ACTION_LINK " : "");
    }

    private static int getSourceActions(DropTargetEvent dtde) {
        if (dtde instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dtde).getSourceActions();
        }
        return ((DropTargetDropEvent)dtde).getSourceActions();
    }

    private static int getDropAction(DropTargetEvent dtde) {
        if (dtde instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dtde).getDropAction();
        }
        return ((DropTargetDropEvent)dtde).getDropAction();
    }

    private boolean isDefaultAction(DropTargetEvent dtde) {
        int dropAction = dtde instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dtde).getDropAction() : ((DropTargetDropEvent)dtde).getDropAction();
        if (Platform.isLinux()) {
            return (this.sourceActions & 1 & dropAction) > 0;
        }
        return (this.sourceActions & 2 & dropAction) > 0 || (this.sourceActions & 2) == 0 && (this.sourceActions & 1 & dropAction) > 0;
    }

    private int decideDropAction(DropTargetEvent dtde) {
        return this.decideDropAction(dtde, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decideDropAction(DropTargetEvent dtde, boolean overrideSourceActions) {
        int sa;
        int dropAction;
        block19: {
            Config.FileAddBehavior defaultBehavior;
            block17: {
                block18: {
                    block16: {
                        boolean isJAlbumObject;
                        if (dtde instanceof DropTargetDragEvent) {
                            isJAlbumObject = ((DropTargetDragEvent)dtde).isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor);
                            dropAction = ((DropTargetDragEvent)dtde).getDropAction();
                            sa = ((DropTargetDragEvent)dtde).getSourceActions();
                        } else {
                            isJAlbumObject = ((DropTargetDropEvent)dtde).isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor);
                            dropAction = ((DropTargetDropEvent)dtde).getDropAction();
                            sa = ((DropTargetDropEvent)dtde).getSourceActions();
                        }
                        if (Config.getConfig().isDebugMode()) {
                            System.out.println("action " + JExplorerPanel.dndActionsToString(dropAction));
                            System.out.println("SourceActions " + JExplorerPanel.dndActionsToString(sa));
                        }
                        if (isJAlbumObject) {
                            return 2;
                        }
                        try {
                            defaultBehavior = Config.getConfig().getFileAddBehavior();
                            if (!this.isDefaultAction(dtde)) break block16;
                            int n = defaultBehavior.getAction();
                            Object var9_12 = null;
                            if (!overrideSourceActions && dropAction == sa) {
                                return dropAction;
                            }
                            return n;
                        }
                        catch (Throwable throwable) {
                            Object var9_17 = null;
                            if (!overrideSourceActions && dropAction == sa) {
                                return dropAction;
                            }
                            throw throwable;
                        }
                    }
                    if (defaultBehavior != Config.FileAddBehavior.COPY) break block17;
                    if (dropAction != 1) break block18;
                    int n = this.isProjectLoaded() ? defaultBehavior.getAltAction() : 2;
                    Object var9_13 = null;
                    if (!overrideSourceActions && dropAction == sa) {
                        return dropAction;
                    }
                    return n;
                }
                int n = dropAction;
                Object var9_14 = null;
                if (!overrideSourceActions && dropAction == sa) {
                    return dropAction;
                }
                return n;
            }
            if (dropAction != 0x40000000) break block19;
            int n = this.isProjectLoaded() ? defaultBehavior.getAltAction() : 2;
            Object var9_15 = null;
            if (!overrideSourceActions && dropAction == sa) {
                return dropAction;
            }
            return n;
        }
        int n = dropAction;
        Object var9_16 = null;
        if (!overrideSourceActions && dropAction == sa) {
            return dropAction;
        }
        return n;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
            dtde.acceptDrag(this.decideDropAction(dtde));
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.sourceActions = JExplorerPanel.getSourceActions(dtde);
        dtde.acceptDrag(this.decideDropAction(dtde));
        Rectangle r = new Rectangle(dtde.getLocation(), new Dimension(60, 60));
        r.translate(-30, -30);
        this.scrollRectToVisible(r);
        Point dragLocation = dtde.getLocation();
        int xpos = this.getInsets().left;
        int ypos = this.getInsets().top;
        JAlbumObject jao = this.closestComp = (JAlbumObject)this.getNearestComponent(dragLocation);
        if (jao != null) {
            ypos = jao.getY() - 2;
            int center = jao.getX() + jao.getWidth() / 2;
            this.insertBefore = dragLocation.x < center;
            xpos = this.insertBefore ? jao.getX() - this.explorerThumbsLayout.hgap / 2 : jao.getX() + jao.getWidth() + this.explorerThumbsLayout.hgap / 2;
        }
        this.caretLocation = new Point(xpos, ypos);
        this.dropFolder = null;
        if (jao != null && jao.ao.isFolder() && jao.getBounds().contains(dragLocation)) {
            this.dropFolder = jao;
            this.caretLocation = null;
        }
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        dtde.acceptDrag(this.decideDropAction(dtde));
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.caretLocation = null;
        this.dropFolder = null;
        this.repaint();
    }

    private void stripSkippedFiles(List<File> files, AlbumObject target) throws OperationAbortedException {
        CopyDecision copyDecision = CopyDecision.UNDECIDED;
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            File f = it.next();
            if (!target.containsName(f.getName())) continue;
            CopyDecision decision = copyDecision;
            if (copyDecision == CopyDecision.UNDECIDED) {
                JCopyWarningDialog confirmDialog = new JCopyWarningDialog(this.context.parent, Msg.get("ui.addPhotos"), f);
                confirmDialog.setVisible(true);
                if (confirmDialog.buttonPressed == confirmDialog.replaceButton) {
                    decision = CopyDecision.COPY;
                } else if (confirmDialog.buttonPressed == confirmDialog.dontReplaceButton) {
                    decision = CopyDecision.SKIP;
                } else {
                    throw new OperationAbortedException();
                }
                if (confirmDialog.applyToAll.isSelected()) {
                    copyDecision = decision;
                }
            }
            if (decision != CopyDecision.SKIP) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void drop(final DropTargetDropEvent dtde) {
        block13: {
            if (this.isValidDragDrop(dtde.getDropAction(), dtde.getCurrentDataFlavors())) {
                if (this.getComponentCount() > 0 && this.caretLocation == null && this.dropFolder == null) {
                    dtde.rejectDrop();
                    return;
                }
                this.caretLocation = null;
                try {
                    try {
                        dtde.acceptDrop(this.decideDropAction(dtde));
                        if (dtde.isDataFlavorSupported(JAlbumObject.jAlbumObjectFlavor)) {
                            this.handleJAlbumObjectDrop(dtde);
                            this.dropFolder = null;
                        } else {
                            final List<File> files = JExplorerPanel.getFilesFromTransferable(dtde.getTransferable());
                            if (files != null && files.size() > 0) {
                                dtde.dropComplete(true);
                                if (files.size() == 1) {
                                    Tracer.getInstance().trace(files.get(0).isDirectory() ? "folder dropped" : "file dropped");
                                } else {
                                    Tracer.getInstance().trace("files dropped", "fileCount:" + files.size());
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JExplorerPanel.this.handleFileAdd(files, JExplorerPanel.this.decideDropAction(dtde, true));
                                        JExplorerPanel.this.dropFolder = null;
                                    }
                                });
                                Object var4_4 = null;
                                this.draggedObjects = null;
                                return;
                            }
                        }
                        dtde.dropComplete(true);
                        this.context.currentFolder.setOrdering("custom");
                        this.context.customOrderingAction.setSelected(true);
                        this.context.handleDisablingOfOrderingMenus();
                        this.fireStructureChanged(new StructureEvent(this));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        dtde.dropComplete(false);
                        Object var4_6 = null;
                        this.draggedObjects = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.draggedObjects = null;
                    throw throwable;
                }
                Object var4_5 = null;
                this.draggedObjects = null;
            } else {
                dtde.rejectDrop();
            }
        }
        this.validate();
        this.repaint();
    }

    private void handleJAlbumObjectDrop(DropTargetDropEvent dtde) {
        Tracer.getInstance().trace("albumobjects move");
        List<JAlbumObject> objectsToMove = this.getDraggedObjects();
        if (this.dropFolder != null) {
            try {
                for (JAlbumObject jao : objectsToMove) {
                    jao.ao.moveTo(this.dropFolder.ao);
                    this.remove(jao);
                }
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        } else if (this.context.currentFolder.equals(objectsToMove.get((int)0).ao.getParent())) {
            for (JAlbumObject jao : objectsToMove) {
                if (jao.isFocusOwner()) {
                    jao.transferFocusBackward();
                }
                this.remove(jao);
            }
            int insertIndex = this.findInsertIndex();
            for (JAlbumObject jao : objectsToMove) {
                this.add((Component)jao, insertIndex++);
                objectsToMove.get(0).requestFocusInWindow();
            }
        } else {
            try {
                int insertIndex = this.findInsertIndex();
                for (JAlbumObject jao : objectsToMove) {
                    jao.ao.moveTo(this.context.currentFolder);
                    this.add((Component)jao, insertIndex++);
                }
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(this, ex);
            }
        }
    }

    public AlbumObject[] getSelectedAlbumObjects() {
        ArrayList<AlbumObject> selected = new ArrayList<AlbumObject>();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JAlbumObject jao = (JAlbumObject)comps[i];
            if (!jao.isSelected()) continue;
            selected.add(jao.ao);
        }
        return selected.toArray(new AlbumObject[selected.size()]);
    }

    private static List<File> getFilesFromTransferable(Transferable t) {
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String urls = (String)t.getTransferData(DataFlavor.stringFlavor);
                urls = urls.replace(" ", "%20");
                LinkedList<File> files = new LinkedList<File>();
                StringTokenizer tokens = new StringTokenizer(urls);
                while (tokens.hasMoreTokens()) {
                    String urlString = tokens.nextToken();
                    URL url = new URL(urlString);
                    files.add(new File(URLDecoder.decode(url.getFile(), "UTF-8")));
                }
                return files;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<File> filterSupportedFiles(List<File> files) {
        LinkedList<File> filtered = new LinkedList<File>();
        for (File f : files) {
            if (!FileFilters.isFileSupported(f) && !FileFilters.hasIcon(f)) continue;
            filtered.add(f);
        }
        return filtered;
    }

    public boolean handleFileAdd(List<File> files) {
        return this.handleFileAdd(files, Config.getConfig().getFileAddBehavior().getAction());
    }

    public boolean handleFileAdd(List<File> files, int dropAction) {
        block18: {
            try {
                if (files.size() > 0 && "C:\\".equals(files.get(0).getAbsolutePath())) {
                    JOptionPane.showMessageDialog(this.context.parent, "You can't currently copy files from this device to jAlbum.\nPlease copy them to a local hard disk first", Msg.get("ui.copy"), 0);
                    return false;
                }
                if (!(files.size() == 1 && files.get(0).isDirectory() || dropAction != 2)) {
                    dropAction = Config.getConfig().getFileAddBehavior().getAction();
                }
                if (this.handleSpecialFileTypes(files, dropAction)) {
                    return true;
                }
                if (this.needsDelayedProcessing(files, dropAction)) {
                    return true;
                }
                this.context.setExplorerView();
                AlbumObject target = this.dropFolder != null ? this.dropFolder.ao : this.context.currentFolder;
                files = this.filterSupportedFiles(files);
                this.stripSkippedFiles(files, target);
                if (this.context.currentFolder == null) {
                    this.context.currentFolder = this.context.rootFolder;
                }
                if (dropAction == 1) {
                    FileCopier fc = new FileCopier(this.context.parent);
                    fc.setAllowDuplicates(true);
                    files = fc.copyFiles(files, target);
                }
                AlbumObjectFactory factory = JAlbumContext.getInstance().getAlbumObjectfactory();
                LinkedHashSet<AlbumObject> toAdd = new LinkedHashSet<AlbumObject>();
                for (File f : files) {
                    AlbumObject ao;
                    if (dropAction == 0x40000000) {
                        LinkFile link = new LinkFile(this.context.currentFolder.getFile(), f.getName(), f);
                        ao = factory.createInstance(link, this.context.currentFolder);
                    } else {
                        ao = factory.createInstance(f, this.context.currentFolder);
                    }
                    toAdd.add(ao);
                }
                if (this.dropFolder != null) {
                    try {
                        this.dropFolder.ao.add(this.dropFolder.ao.getChildren().size(), toAdd);
                    }
                    catch (IOException ex) {
                        Debug.showFriendlyErrorDialog(this.context, ex);
                    }
                    break block18;
                }
                int insertIndex = this.findInsertIndex();
                try {
                    target.add(insertIndex, toAdd);
                }
                catch (IOException ex) {
                    Debug.showFriendlyErrorDialog(this.context, ex);
                }
                this.context.viewFolder(target);
                this.context.refreshCurrentNode();
                if (this.context.parent.actions.makeAction.isEnabled()) {
                    TipOfTheDay.showInBackground(Msg.get("tip.makeAlbum", Msg.get("ui.makeAlbum")));
                }
            }
            catch (OperationAbortedException operationAbortedException) {
                // empty catch block
            }
        }
        if (FileAddBehaviorInfo.shouldShow()) {
            FileAddBehaviorInfo.showDialog(this.context.parent);
        }
        return false;
    }

    private AlbumObject buildVirtualTree(AlbumObject parent, File target) throws IOException {
        File dir = new File(parent.getFile(), target.getName());
        dir.mkdir();
        AlbumObjectFactory factory = JAlbumContext.getInstance().getAlbumObjectfactory();
        AlbumObject ao = factory.createInstance(dir, parent);
        LinkedList<AlbumObject> children = new LinkedList<AlbumObject>();
        for (File f : target.listFiles(parent.getFactory().getFilter())) {
            if (!FileFilters.isFileSupported(f) && !FileFilters.hasIcon(f)) continue;
            if (f.isDirectory()) {
                children.add(this.buildVirtualTree(ao, f));
                continue;
            }
            LinkFile link = new LinkFile(ao.getFile(), f.getName(), f);
            AlbumObject child = factory.createInstance(link, ao);
            children.add(child);
        }
        ao.setChildren(children);
        return ao;
    }

    private boolean handleSpecialFileTypes(List<File> files, int dropAction) {
        if (files.size() > 0) {
            File file = files.get(0);
            String fileName = file.getName();
            if (fileName.endsWith(".jap")) {
                this.createOrLoadProject(files, dropAction);
                return true;
            }
            if (fileName.endsWith(".jaskin")) {
                new SkinManager().installSkin(file);
                return true;
            }
            if (fileName.endsWith(".jaext")) {
                PluginManager.installPlugin(file);
                return true;
            }
        }
        return false;
    }

    private int findInsertIndex() {
        int insertIndex = -1;
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != this.closestComp) continue;
            insertIndex = i;
            if (this.insertBefore) break;
            ++insertIndex;
            break;
        }
        if (insertIndex < 0) {
            insertIndex = comps.length;
        }
        return insertIndex;
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor dropFlavor = flavors[i];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor) && !dropFlavor.equals(JAlbumObject.jAlbumObjectFlavor) && !dropFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    public List<JAlbumObject> getDraggedObjects() {
        return this.draggedObjects;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        event.startDrag(null, (JAlbumObject)event.getComponent(), this);
        this.draggedObjects = this.selectionModel.getSelectedObjects();
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.draggedObjects = null;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        JAlbumObject jao = (JAlbumObject)comp;
        if (jao.isSelected()) {
            this.selectionModel.objectSelected(jao, false);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.selectionModel.deselectAll();
    }

    public synchronized void removeStructureListener(StructureListener l) {
        if (this.structureListeners != null && this.structureListeners.contains(l)) {
            Vector v = (Vector)this.structureListeners.clone();
            v.removeElement(l);
            this.structureListeners = v;
        }
    }

    public synchronized void addStructureListener(StructureListener l) {
        Vector v;
        Vector vector = v = this.structureListeners == null ? new Vector(2) : (Vector)this.structureListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.structureListeners = v;
        }
    }

    protected void fireStructureChanged(StructureEvent e) {
        if (this.structureListeners != null) {
            Vector listeners = this.structureListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((StructureListener)listeners.elementAt(i)).structureChanged(e);
            }
        }
    }

    private boolean needsDelayedProcessing(final List files, final int dropAction) {
        if (this.isProjectLoaded()) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JExplorerPanel.this.createOrLoadProject(files, dropAction);
            }
        });
        return true;
    }

    private void createOrLoadProject(List<File> files, int dropAction) {
        if (files.size() == 1) {
            File file = files.get(0);
            if (file.isDirectory()) {
                File projectFile = new File(file, "jalbum-settings.jap");
                if (projectFile.exists()) {
                    this.context.parent.loadProject(projectFile);
                } else if (dropAction == 2) {
                    this.context.parent.initProject(file);
                } else {
                    this.showNewProjectDialog(this.filterSupportedFiles(Arrays.asList(file.listFiles())), dropAction);
                }
            } else if (file.getName().endsWith(".jap")) {
                this.context.parent.loadProject(file);
            } else {
                this.showNewProjectDialog(this.filterSupportedFiles(files), dropAction);
            }
        } else {
            this.showNewProjectDialog(this.filterSupportedFiles(files), dropAction);
        }
    }

    private void showNewProjectDialog(List files, int dropAction) {
        JNewProjectDialog newProjectDialog = new JNewProjectDialog(this.context.parent);
        String albumNameSuggestion = this.findAlbumNameSuggestion(files);
        newProjectDialog.setAlbumName(albumNameSuggestion);
        newProjectDialog.setFiles(files, dropAction);
        this.context.parent.show(newProjectDialog);
    }

    private String findAlbumNameSuggestion(List files) {
        String parentNameForAllFiles = null;
        for (File file : files) {
            String parentNameOfCurrentFile = file.getParentFile().getName();
            if (parentNameForAllFiles == null) {
                parentNameForAllFiles = parentNameOfCurrentFile;
                continue;
            }
            if (parentNameForAllFiles.equals(parentNameOfCurrentFile)) continue;
            return Msg.get("newproject.defaultName");
        }
        return parentNameForAllFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CopyDecision {
        UNDECIDED,
        COPY,
        SKIP;

    }
}

