/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;

public class JSkinLikesPanel
extends JPanel {
    private String skinName;
    private WrappableJLabel label = new WrappableJLabel();
    private boolean likes;
    private Integer likesCount;
    private Action likeAction = new AbstractAction(Msg.get("ui.like")){
        {
            this.putValue("SmallIcon", Icons.getIcon("tiny.like"));
        }

        public void actionPerformed(ActionEvent e) {
            JSkinLikesPanel.this.likeButton.setText(JSkinLikesPanel.this.likeButton.isSelected() ? Msg.get("ui.liking") : Msg.get("ui.like"));
            JSkinLikesPanel.this.callLikesAPIBg(JSkinLikesPanel.this.likeButton.isSelected());
        }
    };
    private JToggleButton likeButton = new JToggleButton(this.likeAction);
    private Thread updater;

    public JSkinLikesPanel(String skinName) {
        this.skinName = skinName;
        this.init();
    }

    public boolean isLikes() {
        return this.likes;
    }

    public Integer getLikesCount() {
        return this.likesCount;
    }

    public JToggleButton getLikeButton() {
        return this.likeButton;
    }

    private void updateVisuals() {
        this.label.setText(Msg.get("ui.skinLikes", this.skinName, this.likesCount != null ? this.likesCount : "--"));
        boolean signedIn = SignInManager.getInstance().isSignedIn();
        this.likeButton.setEnabled(signedIn);
        this.likeButton.setToolTipText(signedIn ? null : Msg.get("ui.notSignedIn"));
        this.likeButton.setText(this.likeButton.isSelected() ? Msg.get("ui.liking") : Msg.get("ui.like"));
        this.validate();
    }

    private void init() {
        SignInManager.getInstance().addPropertyChangeListener("signIn", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JSkinLikesPanel.this.updateVisuals();
            }
        });
        this.setLayout(new RiverLayout());
        this.setOpaque(false);
        this.updateVisuals();
        this.add("hfill", this.label);
        this.add("br center", this.likeButton);
        this.validate();
        this.callLikesAPIBg(null);
    }

    public void waitForUpdate() {
        if (this.updater != null && this.updater.isAlive()) {
            try {
                this.updater.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean foundLikes() {
        this.waitForUpdate();
        return this.likesCount != null;
    }

    public void callLikesAPIBg(final Boolean like) {
        this.waitForUpdate();
        this.updater = new Thread("Skin likes updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        JSkinLikesPanel.this.likeAction.setEnabled(false);
                        JSkinLikesPanel.this.callLikesAPI(like);
                        JSkinLikesPanel.this.updateVisuals();
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        JSkinLikesPanel.this.updateVisuals();
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    JSkinLikesPanel.this.updateVisuals();
                    throw throwable;
                }
                JSkinLikesPanel.this.updateVisuals();
            }
        };
        this.updater.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void callLikesAPI(Boolean like) throws IOException, IllegalStateException {
        HttpResponse resp;
        SignInManager mgr;
        HttpConnection conn = new HttpConnection(JAlbumSite.getInstance().getSkinLikesUrl());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("skin", this.skinName);
        if (like != null) {
            data.put("like", like.toString());
        }
        if ((mgr = SignInManager.getInstance()).isSignedIn()) {
            String cid = AccountManager.getCid(mgr.getUserName(), mgr.getPassword());
            data.put("cid", cid);
        }
        if ((resp = conn.Post(data)).getStatusCode() != 200) throw new IOException("Error posting skin like: " + resp.getStatusCode());
        try {
            boolean oldLikes = this.likes;
            InputSource input = new InputSource(resp.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node result = (Node)xpath.evaluate("/reply/result", input, XPathConstants.NODE);
            if ("ok".equals(result.getTextContent())) {
                this.likes = "true".equals(xpath.evaluate("@likes", result, XPathConstants.STRING));
                Double lc = (Double)xpath.evaluate("@likesCount", result, XPathConstants.NUMBER);
                if (lc != null) {
                    if (this.likesCount == null || lc.intValue() != this.likesCount.intValue()) {
                        this.firePropertyChange("likesCount", this.likesCount, lc);
                    }
                    this.likesCount = lc.intValue();
                }
            }
            this.likeButton.setSelected(this.likes);
            this.updateVisuals();
            if (this.likes == oldLikes) return;
            this.firePropertyChange("likes", oldLikes, this.likes);
            return;
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

