/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class JGradientButton
extends JButton {
    private Color topColor;
    private Color bottomColor;
    private Color borderColor;

    public JGradientButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public JGradientButton(Action a) {
        super(a);
        this.init();
    }

    public JGradientButton(String text) {
        super(text);
        this.init();
    }

    public JGradientButton(Icon icon) {
        super(icon);
        this.init();
    }

    public JGradientButton() {
        this.init();
    }

    public JGradientButton(Color c1, Color c2) {
        this.init(c1, c2);
    }

    public JGradientButton(String text, Color c1, Color c2) {
        super(text);
        this.init(c1, c2);
    }

    public JGradientButton(String text, Icon icon, Color c1, Color c2) {
        super(text, icon);
        this.init(c1, c2);
    }

    private void init() {
        this.init(new Color(255, 255, 255), new Color(234, 235, 237));
    }

    private void init(Color c1, Color c2) {
        this.topColor = c1;
        this.bottomColor = c2;
        this.borderColor = new Color(167, 166, 170);
        this.setBorder(null);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setOpaque(false);
    }

    public void setTopColor(Color c1) {
        this.topColor = c1;
        this.repaint();
    }

    public void setBottomColor(Color c2) {
        this.bottomColor = c2;
        this.repaint();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Insets in = this.getInsets();
        int w = this.getWidth() - in.left - in.right;
        int h = this.getHeight() - in.top - in.bottom;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(in.left, in.top, this.topColor, w, 0.0f, this.bottomColor, false);
        g2.setPaint(gradient);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fillRoundRect(in.left + 1, in.top + 1, w - 2, h - 2, 10, 10);
        super.paintComponent(g);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.add(new JGradientButton("We are testing", new Color(255, 255, 255), new Color(150, 150, 150)));
        f.pack();
        f.setVisible(true);
    }
}

