// Non linear Shift based interpolated LMs

class shiftone: public mdiadaptlm{
protected:
  int prunethresh;
  double beta;   
public:
  shiftone(char* ngtfile,int depth=0,int prunefreq=0,TABLETYPE tt=SHIFTBETA_B);
  int train();
  int discount(ngram ng,int size,double& fstar,double& lambda,int cv=0);  
  ~shiftone(){};
};


class shiftbeta: public mdiadaptlm{
 protected:
  int prunethresh;
  double* beta;

 public:
  shiftbeta(char* ngtfile,int depth=0,int prunefreq=0,double beta=-1,TABLETYPE tt=SHIFTBETA_B);
  int train();
  int discount(ngram ng,int size,double& fstar,double& lambda,int cv=0);  
  ~shiftbeta(){delete [] beta;};

};


class symshiftbeta: public shiftbeta{
 public:
  symshiftbeta(char* ngtfile,int depth=0,int prunefreq=0,double beta=-1):
    shiftbeta(ngtfile,depth,prunefreq,beta){};
  int discount(ngram ng,int size,double& fstar,double& lambda,int cv=0);  
};


class mshiftbeta: public mdiadaptlm{
 protected:
  int prunethresh;
  double beta[3][MAX_NGRAM];
  ngramtable* tb[MAX_NGRAM];

  double oovsum;

 public:
  mshiftbeta(char* ngtfile,int depth=0,int prunefreq=0,TABLETYPE tt=MSHIFTBETA_B);
  int train();
  int discount(ngram ng,int size,double& fstar,double& lambda,int cv=0);  

  ~mshiftbeta(){};

  int mfreq(ngram& ng,int l){return (l<lmsize()?getfreq(ng.link,ng.pinfo,1):ng.freq);}

};

