/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.repositorioXML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioObjetoNegocioIf;
import serpro.ppgd.repositorio.repositorioXML.AdaptadorXMLAtributo;
import serpro.ppgd.repositorio.repositorioXML.AdaptadorXMLObjeto;
import serpro.ppgd.repositorio.repositorioXML.HashtableIdDeclaracao;
import serpro.ppgd.repositorio.repositorioXML.MapeamentoObjetoNegocioXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioObjetoNegocioXMLOld
implements RepositorioObjetoNegocioIf {
    private static final String NOME_RAIZ = "Mapeamento";
    private MapeamentoObjetoNegocioXML mapeamento;
    private Map<IdDeclaracao, ObjetoNegocio> objetosIRPFAbertos;
    private String diretorioDados;

    public RepositorioObjetoNegocioXMLOld(String arquivoMapeamento, String diretorioDados) {
        Document mapeamentoDom = this.carregarDOM(arquivoMapeamento);
        if (mapeamentoDom == null) {
            LogPPGD.erro((String)"Mapeamento inv\u00e1lido");
        }
        this.mapeamento = MapeamentoObjetoNegocioXML.getMapeamento(mapeamentoDom);
        this.diretorioDados = diretorioDados;
    }

    @Override
    public void descarregar(IdDeclaracao id) throws RepositorioException {
        if (this.getObjetosIRPFAbertos().containsKey(id)) {
            this.getObjetosIRPFAbertos().remove(id);
        }
    }

    @Override
    public ObjetoNegocio criar(IdDeclaracao id) throws RepositorioException {
        ObjetoNegocio resultado = null;
        if (id == null) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioXML: argumento \u00e9 nulo.");
        }
        if (this.getObjetosIRPFAbertos().containsKey(id)) {
            throw new IllegalArgumentException("RepositorioObjetoNegocioXML: ObjetoNegocio solicitado j\u00e1 existe.");
        }
        try {
            Class<?> classeSolicitada = this.mapeamento.getAdaptadorXMLObjeto(NOME_RAIZ).getClasseJava();
            resultado = this.instanciaObjetoNegocio(classeSolicitada, id);
            this.getObjetosIRPFAbertos().put(id, resultado);
            return resultado;
        }
        catch (ClassNotFoundException e) {
            LogPPGD.erro((String)"RepositorioObjetoNegocioXML: classe a ser criada n\u00e3o existe.");
            throw new RepositorioXMLException(e);
        }
    }

    @Override
    public ObjetoNegocio recuperar(IdDeclaracao id) throws RepositorioException {
        if (this.getObjetosIRPFAbertos().containsKey(id)) {
            return this.getObjetosIRPFAbertos().get(id);
        }
        Document arquivoDados = this.leArquivo(id.getPathArquivo(this.diretorioDados));
        if (arquivoDados == null) {
            throw new RepositorioException("Arquivo de dados n\u00e3o encontrado.");
        }
        try {
            ObjetoNegocio resultado = this.instanciaObjetoNegocio(this.mapeamento.getAdaptadorXMLObjeto(NOME_RAIZ).getClasseJava(), id);
            if (arquivoDados == null) {
                return resultado;
            }
            this.caminhaArvoreDOM(arquivoDados.getDocumentElement(), resultado);
            this.getObjetosIRPFAbertos().put(id, resultado);
            return resultado;
        }
        catch (ClassNotFoundException e) {
            LogPPGD.erro((String)"classe n\u00e3o encontrada.");
            throw new RepositorioException(e);
        }
    }

    @Override
    public void salvar(IdDeclaracao id) throws RepositorioException {
        if (this.getObjetosIRPFAbertos().containsKey(id)) {
            ObjetoNegocio objetoIRPF = this.getObjetosIRPFAbertos().get(id);
            try {
                Document cacheDados = this.obterDOM(objetoIRPF);
                File arquivoXML = new File(id.getPathArquivo(this.diretorioDados));
                FileOutputStream os = new FileOutputStream(arquivoXML);
                StreamResult result = new StreamResult(os);
                DOMSource source = new DOMSource(cacheDados);
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, result);
                os.close();
            }
            catch (TransformerConfigurationException tce) {
                LogPPGD.erro((String)"Erro de configura\u00e7\u00e3o da f\u00e1brica de transforma\u00e7\u00e3o DOM");
                throw new RepositorioXMLException(tce);
            }
            catch (TransformerException te) {
                LogPPGD.erro((String)"Erro de transforma\u00e7\u00e3o DOM-XML");
                throw new RepositorioXMLException(te);
            }
            catch (IOException ioe) {
                LogPPGD.erro((String)"Erro de IO");
                throw new RepositorioXMLException(ioe);
            }
        } else {
            throw new IllegalArgumentException("N\u00e3o h\u00e1 ObjetoNegocio correspondente a esse IdDeclaracao: " + id.getNiContribuinte());
        }
    }

    @Override
    public void deletar(IdDeclaracao id) throws RepositorioException {
        String arq = id.getPathArquivo(this.diretorioDados);
        String path = UtilitariosArquivo.extraiPath((String)arq);
        File f = new File(arq);
        f.delete();
        f = new File(path);
        f.delete();
        if (this.getObjetosIRPFAbertos().containsKey(id)) {
            this.getObjetosIRPFAbertos().remove(id);
        }
    }

    private Document carregarDOM(String arquivoMapeamento) {
        Document mapeamentoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            mapeamentoDOM = builder.parse(UtilitariosArquivo.getResource((String)arquivoMapeamento, this.getClass()));
        }
        catch (SAXParseException e) {
            LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        return mapeamentoDOM;
    }

    private ObjetoNegocio instanciaObjetoNegocio(Class<?> classeAInstanciar, IdDeclaracao id) throws RepositorioXMLException {
        ObjetoNegocio resultado = null;
        Object[] argumentosReais = new Object[]{id};
        try {
            Class[] argumentosFormais = new Class[]{Class.forName(IdDeclaracao.class.getName())};
            if (!Class.forName(ObjetoNegocio.class.getName()).isAssignableFrom(classeAInstanciar)) {
                throw new RepositorioXMLException("Mapeamento incorreto: classe n\u00e3o \u00e9 ObjetoNegocio");
            }
            Constructor<?> construtor = classeAInstanciar.getConstructor(argumentosFormais);
            resultado = (ObjetoNegocio)construtor.newInstance(argumentosReais);
            return resultado;
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
        catch (Exception e) {
            LogPPGD.erro((String)"Mapeamento incorreto: classe n\u00e3o possui construtor (IdDeclaracao)");
            throw new RepositorioXMLException(e);
        }
    }

    private ObjetoNegocio determinaConteiner(ObjetoNegocio objetoRaiz, String nomeXMLConteiner) throws RepositorioXMLException {
        if (nomeXMLConteiner.length() == 0) {
            return objetoRaiz;
        }
        AdaptadorXMLObjeto adaptadorDoConteiner = this.mapeamento.getAdaptadorXMLObjeto(nomeXMLConteiner);
        ObjetoNegocio conteiner = this.determinaConteiner(objetoRaiz, adaptadorDoConteiner.getConteiner());
        String nomeMetodoAcesso = adaptadorDoConteiner.getMetodoAcesso();
        if (nomeMetodoAcesso.equals("this")) {
            return conteiner;
        }
        try {
            Method metodoAcesso = conteiner.getClass().getMethod(nomeMetodoAcesso, new Class[0]);
            return (ObjetoNegocio)metodoAcesso.invoke((Object)conteiner, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LogPPGD.erro((String)"Mapeamento incorreto");
            throw new RepositorioXMLException(e);
        }
        catch (IllegalAccessException e) {
            LogPPGD.erro((String)("Acesso ilegal " + e.getStackTrace()));
            throw new RepositorioXMLException(e);
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private ObjetoNegocio determinaObjeto(ObjetoNegocio conteiner, AdaptadorXMLObjeto adaptador) throws RepositorioXMLException {
        ObjetoNegocio objetoIRPF = null;
        try {
            if (conteiner instanceof Colecao) {
                Colecao conteinerIRPF = (Colecao)conteiner;
                objetoIRPF = this.instanciaObjetoNegocio(adaptador.getClasseJava(), conteinerIRPF.getIdDeclaracao());
                ((Colecao)conteiner).recuperarLista().add(objetoIRPF);
                return objetoIRPF;
            }
            Class<?> classeConteiner = conteiner.getClass();
            String nomeMetodoAcesso = adaptador.getMetodoAcesso();
            if (nomeMetodoAcesso.equals("this")) {
                return conteiner;
            }
            Method metodoAcesso = classeConteiner.getMethod(nomeMetodoAcesso, new Class[0]);
            return (ObjetoNegocio)metodoAcesso.invoke((Object)conteiner, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LogPPGD.erro((String)"Acesso ilegal");
            throw new RepositorioXMLException(e);
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado pela instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
        catch (ClassNotFoundException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada em instacia\u00e7\u00e3o de objeto: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
        catch (SecurityException e) {
            LogPPGD.erro((String)("Security manager n\u00e3o permitiu acesso a instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
        catch (NoSuchMethodException e) {
            LogPPGD.erro((String)("M\u00e9todo n\u00e3o existe: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private void populaObjetoIRPF(ObjetoNegocio objetoIRPF, Element nodeXML) throws RepositorioXMLException {
        AdaptadorXMLObjeto adaptador = this.mapeamento.getAdaptadorXMLObjeto(this.determinaNomeCompleto(nodeXML));
        if (adaptador == null || !adaptador.isMarshalling()) {
            return;
        }
        Iterator<AdaptadorXMLAtributo> iteratorAtributos = null;
        if (adaptador.getAtributos() != null) {
            iteratorAtributos = adaptador.getAtributos().iterator();
        } else {
            return;
        }
        while (iteratorAtributos.hasNext()) {
            AdaptadorXMLAtributo adaptadorAtributo = iteratorAtributos.next();
            if (!adaptadorAtributo.isMarshalling()) continue;
            try {
                Method metodoAcesso = objetoIRPF.getClass().getMethod(adaptadorAtributo.getMetodoAcesso(), new Class[0]);
                Informacao atributo = (Informacao)metodoAcesso.invoke((Object)objetoIRPF, new Object[0]);
                String dado = nodeXML.getAttribute(adaptadorAtributo.getElementoXML());
                if (dado != null && dado.length() > 0) {
                    atributo.setConteudo(dado);
                    continue;
                }
                LogPPGD.debug((String)("Atributo " + adaptador.getElementoXML() + "." + adaptadorAtributo.getElementoXML() + " vazio ou inexistente."));
            }
            catch (NoSuchMethodException e) {
                LogPPGD.erro((String)"Mapeamento incorreto: m\u00e9todo inexistente");
                throw new RepositorioXMLException(e);
            }
            catch (IllegalAccessException e) {
                LogPPGD.erro((String)"Acesso ilegal");
                throw new RepositorioXMLException(e);
            }
            catch (InvocationTargetException e) {
                LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getMessage()));
                throw new RepositorioXMLException(e);
            }
        }
    }

    private String determinaNomeCompleto(Node node) {
        if (node.getParentNode() != node.getOwnerDocument().getDocumentElement()) {
            return this.determinaNomeCompleto(node.getParentNode()) + "." + node.getNodeName();
        }
        return node.getNodeName();
    }

    private void transformaNodoXML2ObjetoIRPF(ObjetoNegocio objetoRaiz, Element nodeXML) throws RepositorioXMLException {
        String nomeCompletoNodo = this.determinaNomeCompleto(nodeXML);
        LogPPGD.debug((String)("Processamento do n\u00f3: " + nomeCompletoNodo));
        AdaptadorXMLObjeto adaptador = this.mapeamento.getAdaptadorXMLObjeto(nomeCompletoNodo);
        if (adaptador == null || !adaptador.isMarshalling()) {
            return;
        }
        LogPPGD.debug((String)("Encontrado adaptador (c/ marshalling) de : " + nomeCompletoNodo + " cujo conteiner \u00e9: " + adaptador.getConteiner()));
        ObjetoNegocio conteiner = this.determinaConteiner(objetoRaiz, adaptador.getConteiner());
        ObjetoNegocio objetoIRPF = this.determinaObjeto(conteiner, adaptador);
        this.populaObjetoIRPF(objetoIRPF, nodeXML);
    }

    private void caminhaArvoreDOM(Element dados, ObjetoNegocio objetoRaiz) throws RepositorioXMLException {
        if (dados.hasChildNodes()) {
            NodeList filhos = dados.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                if (filhos.item(i).getNodeType() != 1) continue;
                Element nodeFilho = (Element)filhos.item(i);
                this.transformaNodoXML2ObjetoIRPF(objetoRaiz, nodeFilho);
                this.caminhaArvoreDOM(nodeFilho, objetoRaiz);
            }
        }
    }

    private Document leArquivo(String pathArquivoDados) {
        Document declaracaoDOM = null;
        if (pathArquivoDados == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.parse(pathArquivoDados);
        }
        catch (SAXParseException e) {
            LogPPGD.erro((String)("Erro de parsing de " + e.getSystemId() + ". linha " + e.getLineNumber() + ": " + e.getMessage()));
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            LogPPGD.erro((String)("Erro de parsing: " + x.getMessage()));
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de I/O: " + e.getMessage()));
        }
        return declaracaoDOM;
    }

    private Element getElement(Element ancestral, String nome) {
        Element resultado;
        NodeList lista = ancestral.getElementsByTagName(nome);
        if (lista != null && lista.getLength() > 0) {
            int i = 0;
            while (i < lista.getLength()) {
                if ((resultado = (Element)lista.item(i++)).getParentNode() != ancestral) continue;
                return resultado;
            }
        }
        resultado = ancestral.getOwnerDocument().createElement(nome);
        ancestral.appendChild(resultado);
        return resultado;
    }

    private Element getParent(Element raiz, String chaveMapeamento) {
        StringTokenizer tokenizador = new StringTokenizer(chaveMapeamento, ".");
        int qtdTokens = tokenizador.countTokens();
        Element resultado = raiz;
        if (qtdTokens <= 1) {
            resultado = raiz;
        } else {
            for (int i = 1; i <= qtdTokens - 1; ++i) {
                String nomeElementoXML = tokenizador.nextToken();
                resultado = this.getElement(resultado, nomeElementoXML);
            }
        }
        return resultado;
    }

    private void populaNodeXML(ObjetoNegocio fonte, Element parent, AdaptadorXMLObjeto adaptador) throws RepositorioXMLException {
        List<AdaptadorXMLAtributo> atributos = adaptador.getAtributos();
        if (atributos == null) {
            return;
        }
        try {
            Element node = this.getElement(parent, adaptador.getElementoXML());
            if (!adaptador.isUnmarshalling()) {
                return;
            }
            for (int i = 0; i < atributos.size(); ++i) {
                Method metodoAcesso;
                Informacao atributo;
                String dado;
                AdaptadorXMLAtributo adaptadorAtributo = atributos.get(i);
                if (!adaptadorAtributo.isUnmarshalling() || (dado = (atributo = (Informacao)(metodoAcesso = fonte.getClass().getMethod(adaptadorAtributo.getMetodoAcesso(), new Class[0])).invoke((Object)fonte, new Object[0])).getConteudoFormatado()) == null) continue;
                node.setAttribute(adaptadorAtributo.getElementoXML(), dado);
            }
        }
        catch (NoSuchMethodException e) {
            LogPPGD.erro((String)"Mapeamento incorreto: m\u00e9todo inexistente");
            throw new RepositorioXMLException(e);
        }
        catch (IllegalAccessException e) {
            LogPPGD.erro((String)"class loader: Acesso ilegal ");
            throw new RepositorioXMLException(e);
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private void populaNodesXMLColecao(Colecao colecao, Element parent, AdaptadorXMLObjeto adaptadorDeItem) throws RepositorioXMLException {
        List<AdaptadorXMLAtributo> atributos = adaptadorDeItem.getAtributos();
        if (atributos == null) {
            return;
        }
        try {
            List itens = colecao.recuperarLista();
            for (int i = 0; i < itens.size(); ++i) {
                ObjetoNegocio item = (ObjetoNegocio)itens.get(i);
                Element node = parent.getOwnerDocument().createElement(adaptadorDeItem.getElementoXML());
                parent.appendChild(node);
                if (!adaptadorDeItem.isUnmarshalling()) {
                    return;
                }
                for (int j = 0; j < atributos.size(); ++j) {
                    Method metodoAcesso;
                    Informacao atributo;
                    String dado;
                    AdaptadorXMLAtributo adaptadorAtributo = atributos.get(j);
                    if (!adaptadorAtributo.isUnmarshalling() || (dado = (atributo = (Informacao)(metodoAcesso = item.getClass().getMethod(adaptadorAtributo.getMetodoAcesso(), new Class[0])).invoke((Object)item, new Object[0])).getConteudoFormatado()) == null || dado.length() <= 0) continue;
                    node.setAttribute(adaptadorAtributo.getElementoXML(), dado);
                }
            }
        }
        catch (NoSuchMethodException e) {
            LogPPGD.erro((String)"Mapeamento incorreto: m\u00e9todo inexistente");
            throw new RepositorioXMLException(e);
        }
        catch (IllegalAccessException e) {
            LogPPGD.erro((String)"class loader: Acesso ilegal");
            throw new RepositorioXMLException(e);
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)("Exce\u00e7\u00e3o levantada por m\u00e9todo invocado  pela instrospec\u00e7\u00e3o: " + e.getStackTrace()));
            throw new RepositorioXMLException(e);
        }
    }

    private void transformaObjetoIRPF2NodeXML(Element raiz, ObjetoNegocio fonte, String chaveMapeamento) throws RepositorioXMLException {
        AdaptadorXMLObjeto adaptador = this.mapeamento.getAdaptadorXMLObjeto(chaveMapeamento);
        String nomeRaiz = this.mapeamento.getAdaptadorXMLObjeto(NOME_RAIZ).getElementoXML();
        if (adaptador.getElementoXML().equals(nomeRaiz)) {
            return;
        }
        Element nodeParente = this.getParent(raiz, chaveMapeamento);
        if (adaptador == null) {
            return;
        }
        ObjetoNegocio conteiner = this.determinaConteiner(fonte, adaptador.getConteiner());
        ObjetoNegocio objeto = null;
        if (conteiner instanceof Colecao) {
            this.populaNodesXMLColecao((Colecao)conteiner, nodeParente, adaptador);
        } else {
            objeto = this.determinaObjeto(conteiner, adaptador);
            this.populaNodeXML(objeto, nodeParente, adaptador);
        }
    }

    private Document obterDOM(ObjetoNegocio objetoIRPF) throws RepositorioXMLException {
        Document declaracaoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.newDocument();
            String nomeRaiz = this.mapeamento.getAdaptadorXMLObjeto(NOME_RAIZ).getElementoXML();
            Element root = declaracaoDOM.createElement(nomeRaiz);
            declaracaoDOM.appendChild(root);
            root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            Iterator<String> iteratorAdaptadores = this.mapeamento.iteratorAdaptadoresXMLObjeto();
            while (iteratorAdaptadores.hasNext()) {
                String chaveMapeamento = iteratorAdaptadores.next();
                this.transformaObjetoIRPF2NodeXML(root, objetoIRPF, chaveMapeamento);
            }
            declaracaoDOM.normalize();
            return declaracaoDOM;
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    public Map<IdDeclaracao, ObjetoNegocio> getObjetosIRPFAbertos() {
        if (this.objetosIRPFAbertos == null) {
            this.objetosIRPFAbertos = new HashtableIdDeclaracao<IdDeclaracao, ObjetoNegocio>();
        }
        return this.objetosIRPFAbertos;
    }
}

