/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.IdUsuario;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioIdDeclaracaoIf;
import serpro.ppgd.repositorio.embeddedDB.ObjetoPersistente;
import serpro.ppgd.repositorio.embeddedDB.RepositorioIdDeclaracaoDAO;

public class RepositorioIdDeclaracaoDB
implements RepositorioIdDeclaracaoIf {
    private RepositorioIdDeclaracaoDAO repositorioIdDeclaracaoDAO = null;
    private List<ObjetoPersistente> listObjetosPersistentes;
    private List<IdDeclaracao> listIdDeclaracoes;

    private RepositorioIdDeclaracaoDB() {
    }

    public RepositorioIdDeclaracaoDB(String pNomeCompletoClasseDoIdDec) {
        this.repositorioIdDeclaracaoDAO = new RepositorioIdDeclaracaoDAO(pNomeCompletoClasseDoIdDec);
    }

    @Override
    public List<IdDeclaracao> recuperarIdDeclaracoes(List<IdUsuario> listIds) {
        try {
            if (this.listObjetosPersistentes == null) {
                this.listObjetosPersistentes = new ArrayList<ObjetoPersistente>();
                this.listIdDeclaracoes = new ArrayList<IdDeclaracao>();
                for (IdDeclaracao idDecAtual : this.repositorioIdDeclaracaoDAO.recuperarIdDeclaracoes(listIds)) {
                    this.listIdDeclaracoes.add(idDecAtual);
                    this.listObjetosPersistentes.add(new ObjetoPersistente(idDecAtual, true));
                }
            }
            return this.listIdDeclaracoes;
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean existeIdDeclaracao(IdDeclaracao idDeclaracao) {
        for (int i = 0; i < this.listObjetosPersistentes.size(); ++i) {
            ObjetoPersistente objPersistenteAtual = this.listObjetosPersistentes.get(i);
            if (!((IdDeclaracao)objPersistenteAtual.instancia).equals((Object)idDeclaracao)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdDeclaracao retornaIdDeclaracaoPersistido(IdDeclaracao idDeclaracao) {
        for (int i = 0; i < this.listObjetosPersistentes.size(); ++i) {
            ObjetoPersistente objPersistenteAtual = this.listObjetosPersistentes.get(i);
            if (!((IdDeclaracao)objPersistenteAtual.instancia).equals((Object)idDeclaracao)) continue;
            return (IdDeclaracao)objPersistenteAtual.instancia;
        }
        return null;
    }

    @Override
    public IdDeclaracao criarIdDeclaracao(IdUsuario id) {
        IdDeclaracao idDeclaracao = this.criarIdDeclaracaoNaoPersistido(id);
        this.listIdDeclaracoes.add(idDeclaracao);
        this.listObjetosPersistentes.add(new ObjetoPersistente(idDeclaracao, false));
        return idDeclaracao;
    }

    @Override
    public IdDeclaracao criarIdDeclaracao(IdDeclaracao idDeclaracao) {
        this.listIdDeclaracoes.add(idDeclaracao);
        this.listObjetosPersistentes.add(new ObjetoPersistente(idDeclaracao, false));
        return idDeclaracao;
    }

    @Override
    public IdDeclaracao criarIdDeclaracaoNaoPersistido(IdUsuario id) {
        IdDeclaracao idDeclaracao = this.repositorioIdDeclaracaoDAO.criaInstanciaIdDeclaracaoConcreto(id);
        idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        idDeclaracao.getTipo().setConteudo("DECLARA\u00c7\u00c3O DE AJUSTE ANUAL");
        return idDeclaracao;
    }

    @Override
    public void removerIdDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioException {
        for (int i = 0; i < this.listObjetosPersistentes.size(); ++i) {
            ObjetoPersistente objPersAtual = this.listObjetosPersistentes.get(i);
            IdDeclaracao idDecl = (IdDeclaracao)objPersAtual.instancia;
            if (!idDeclaracao.equals((Object)idDecl)) continue;
            this.repositorioIdDeclaracaoDAO.deletar(idDecl);
            this.listObjetosPersistentes.remove(i);
            this.listIdDeclaracoes.remove(i);
            return;
        }
        throw new RepositorioException("IdDeclara\u00e7\u00e3o n\u00e3o localizado");
    }

    @Override
    public void salvar(IdDeclaracao idDeclaracao) throws RepositorioException {
        for (int i = 0; i < this.listObjetosPersistentes.size(); ++i) {
            ObjetoPersistente objPersAtual = this.listObjetosPersistentes.get(i);
            IdDeclaracao idDecl = (IdDeclaracao)objPersAtual.instancia;
            if (!idDeclaracao.equals((Object)idDecl)) continue;
            if (objPersAtual.persistido) {
                this.repositorioIdDeclaracaoDAO.alterar(idDecl);
            } else {
                this.repositorioIdDeclaracaoDAO.inserir(idDecl);
                objPersAtual.persistido = true;
            }
            return;
        }
        throw new RepositorioException("IdDeclara\u00e7\u00e3o n\u00e3o localizado");
    }
}

