/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.infraestrutura.util.NavegadorColecaoEvent;
import serpro.ppgd.infraestrutura.util.NavegadorColecaoIf;
import serpro.ppgd.infraestrutura.util.NavegadorColecaoListener;
import serpro.ppgd.infraestrutura.util.NavegadorRemocaoEvent;
import serpro.ppgd.infraestrutura.util.NavegadorRemocaoListener;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoComChave;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class JNavegadorColecao
extends JEditCampo
implements NavegadorColecaoIf {
    private JButton btnPrimeiro;
    private JButton btnUltimo;
    private JButton btnAnterior;
    private JButton btnProximo;
    private JButton btnRemover;
    private JButton btnAdicionar;
    protected Icon iconePrimeiro = null;
    protected Icon iconeProximo = null;
    protected Icon iconeAnterior = null;
    protected Icon iconeRemover = null;
    protected Icon iconeAdicionar = null;
    protected Icon iconeUltimo = null;
    public static final int MODO_COMPLETO = 0;
    public static final int MODO_SOMENTE_NAVEGACAO = 1;
    private int modoNavegador = 0;
    private JToolBar toolbar;
    private Colecao colecao;
    private int indexAtual = -1;
    private EventListenerList listeners = new EventListenerList();
    private EventListenerList remocaoListeners = new EventListenerList();
    private Observador observadorColecao;
    private Action actionPrimeiro;
    private Action actionUltimo;
    private Action actionAnterior;
    private Action actionProximo;
    private Action actionRemover;
    private Action actionAdicionar;

    public JNavegadorColecao() {
        this.setFocusable(false);
        this.observadorColecao = new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (JNavegadorColecao.this.getColecao().recuperarLista().size() == 0) {
                    NavegadorColecaoEvent evt = new NavegadorColecaoEvent((Object)this);
                    evt.setObjetoNegocio(null);
                    JNavegadorColecao.this.exibe(-1);
                }
            }
        };
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.btnPrimeiro == null) {
            this.btnPrimeiro = new JButton();
            this.btnAnterior = new JButton();
            this.btnProximo = new JButton();
            this.btnUltimo = new JButton();
            this.btnRemover = new JButton();
            this.btnAdicionar = new JButton();
            this.actionPrimeiro = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.primeiro();
                    }
                }
            };
            this.btnPrimeiro.setAction(this.actionPrimeiro);
            this.actionUltimo = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.ultimo();
                    }
                }
            };
            this.btnUltimo.setAction(this.actionUltimo);
            this.actionAnterior = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.anterior();
                    }
                }
            };
            this.btnAnterior.setAction(this.actionAnterior);
            this.actionProximo = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.proximo();
                    }
                }
            };
            this.btnProximo.setAction(this.actionProximo);
            this.actionRemover = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.remove();
                    }
                }
            };
            this.btnRemover.setAction(this.actionRemover);
            this.actionAdicionar = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (JNavegadorColecao.this.getColecao() != null) {
                        JNavegadorColecao.this.adiciona();
                    }
                }
            };
            this.btnAdicionar.setAction(this.actionAdicionar);
        }
        this.btnPrimeiro.setIcon(this.getIconePrimeiro());
        this.btnAnterior.setIcon(this.getIconeAnterior());
        this.btnProximo.setIcon(this.getIconeProximo());
        this.btnUltimo.setIcon(this.getIconeUltimo());
        this.btnRemover.setIcon(this.getIconeRemover());
        this.btnAdicionar.setIcon(this.getIconeAdicionar());
        this.btnPrimeiro.setToolTipText("Primeiro item");
        this.btnAnterior.setToolTipText("Item anterior");
        this.btnProximo.setToolTipText("Pr\u00f3ximo item");
        this.btnUltimo.setToolTipText("\u00daltimo item");
        this.btnRemover.setToolTipText("Excluir item");
        this.btnAdicionar.setToolTipText("Novo item");
        this.toolbar = new JToolBar();
        if (this.getModoNavegador() == 0) {
            this.toolbar.add(this.btnPrimeiro);
            this.toolbar.add(this.btnAnterior);
            this.toolbar.add(this.btnProximo);
            this.toolbar.add(this.btnUltimo);
            this.toolbar.add(this.btnAdicionar);
            this.toolbar.add(this.btnRemover);
        } else if (this.getModoNavegador() == 1) {
            this.toolbar.add(this.btnPrimeiro);
            this.toolbar.add(this.btnAnterior);
            this.toolbar.add(this.btnProximo);
            this.toolbar.add(this.btnUltimo);
        }
        this.add((Component)this.getComponenteEditor(), "Center");
        this.setPreferredSize(this.getMinimumSize());
        this.validate();
        this.repaint();
    }

    protected void informacaoModificada() {
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
    }

    public JComponent getComponenteEditor() {
        return this.toolbar;
    }

    public JComponent getComponenteFoco() {
        return this.toolbar;
    }

    protected void associaInformacao(String aInfo) {
        try {
            PPGDFacade facade;
            String classeFacade = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> classe = Class.forName(classeFacade);
            Method methGetInstancia = classe.getMethod("getInstancia", new Class[0]);
            Object objInfo = facade = (PPGDFacade)methGetInstancia.invoke(null, new Object[0]);
            StringTokenizer tokens = new StringTokenizer(aInfo, ".");
            while (tokens.hasMoreTokens()) {
                Class<?> clazz = objInfo.getClass();
                String nomeMetodo = tokens.nextToken();
                Method mtd = clazz.getMethod("get" + (nomeMetodo = String.valueOf(nomeMetodo.substring(0, 1).toUpperCase()) + nomeMetodo.substring(1, nomeMetodo.length())), new Class[0]);
                objInfo = mtd.invoke(objInfo, new Object[0]);
                if (objInfo == null) break;
            }
            if (objInfo != null && objInfo instanceof Colecao) {
                this.setColecao((Colecao)objInfo);
            } else {
                LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel encontrar '" + aInfo + "'. Este atributo existe mesmo?"));
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel encontrar '" + aInfo + "'. Este atributo existe mesmo?"));
            e.printStackTrace();
        }
    }

    public void setColecao(Colecao objInfo) {
        this.colecao = objInfo;
        this.colecao.addObservador(this.observadorColecao);
        this.primeiro();
    }

    public void adiciona() {
        this.indexAtual = this.colecao.novoObjeto();
        this.exibe(this.indexAtual);
    }

    public void remove() {
        if (this.indexAtual > -1) {
            NavegadorRemocaoEvent evt = new NavegadorRemocaoEvent((Object)this);
            evt.setObjetoNegocio((ObjetoNegocio)this.colecao.recuperarLista().get(this.indexAtual));
            if (this.fireConfirmaExclusao(evt)) {
                ObjetoNegocio obj = (ObjetoNegocio)this.colecao.recuperarLista().remove(this.indexAtual);
                this.fireObjetoExcluido(evt);
                obj.clear();
                --this.indexAtual;
            }
        }
        if (this.indexAtual == -1 && this.colecao.recuperarLista().size() > 0) {
            this.indexAtual = 0;
        }
        this.exibe(this.indexAtual);
    }

    public void proximo() {
        if (this.indexAtual + 1 < this.getColecao().recuperarLista().size()) {
            ++this.indexAtual;
        }
        this.exibe(this.indexAtual);
    }

    public void anterior() {
        if (this.indexAtual > 0) {
            --this.indexAtual;
        }
        this.exibe(this.indexAtual);
    }

    public void primeiro() {
        this.indexAtual = 0;
        this.exibe(this.indexAtual);
    }

    public void ultimo() {
        this.indexAtual = this.getColecao().recuperarLista().size() - 1;
        this.exibe(this.indexAtual);
    }

    public void exibe(int indice) {
        this.actionPrimeiro.setEnabled(true);
        this.actionAnterior.setEnabled(true);
        this.actionProximo.setEnabled(true);
        this.actionUltimo.setEnabled(true);
        this.actionRemover.setEnabled(true);
        int tamColecao = this.getColecao().recuperarLista().size();
        if (indice >= tamColecao) {
            this.exibe(indice - 1);
        } else {
            if (tamColecao > 0 && indice < tamColecao && indice >= 0) {
                this.indexAtual = indice;
            }
            ObjetoNegocio itemAtual = this.getItem();
            if (tamColecao == 0 || tamColecao == 1) {
                this.actionPrimeiro.setEnabled(false);
                this.actionAnterior.setEnabled(false);
                this.actionProximo.setEnabled(false);
                this.actionUltimo.setEnabled(false);
                this.actionRemover.setEnabled(tamColecao == 1);
            } else if (this.indexAtual == 0) {
                this.actionPrimeiro.setEnabled(false);
                this.actionAnterior.setEnabled(false);
                this.actionProximo.setEnabled(true);
                this.actionUltimo.setEnabled(true);
            } else if (this.indexAtual == tamColecao - 1) {
                this.actionPrimeiro.setEnabled(true);
                this.actionAnterior.setEnabled(true);
                this.actionProximo.setEnabled(false);
                this.actionUltimo.setEnabled(false);
            } else {
                this.actionPrimeiro.setEnabled(true);
                this.actionAnterior.setEnabled(true);
                this.actionProximo.setEnabled(true);
                this.actionUltimo.setEnabled(true);
            }
            NavegadorColecaoEvent evt = new NavegadorColecaoEvent((Object)this);
            evt.setObjetoNegocio(itemAtual);
            if (tamColecao == 0) {
                this.fireExibeColecaoVazia(evt);
            } else {
                this.fireExibeOutro(evt);
            }
        }
    }

    private void fireExibeOutro(NavegadorColecaoEvent evt) {
        NavegadorColecaoListener[] navListeners = (NavegadorColecaoListener[])this.listeners.getListeners(NavegadorColecaoListener.class);
        int i = 0;
        while (i < navListeners.length) {
            navListeners[i].exibeOutro(evt);
            ++i;
        }
    }

    private void fireExibeColecaoVazia(NavegadorColecaoEvent evt) {
        NavegadorColecaoListener[] navListeners = (NavegadorColecaoListener[])this.listeners.getListeners(NavegadorColecaoListener.class);
        int i = 0;
        while (i < navListeners.length) {
            navListeners[i].exibeColecaoVazia(evt);
            ++i;
        }
    }

    private boolean fireConfirmaExclusao(NavegadorRemocaoEvent evt) {
        NavegadorRemocaoListener[] navListeners = (NavegadorRemocaoListener[])this.remocaoListeners.getListeners(NavegadorRemocaoListener.class);
        int i = 0;
        while (i < navListeners.length) {
            if (!navListeners[i].confirmaExclusao(evt)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void fireObjetoExcluido(NavegadorRemocaoEvent evt) {
        NavegadorRemocaoListener[] navListeners = (NavegadorRemocaoListener[])this.remocaoListeners.getListeners(NavegadorRemocaoListener.class);
        int i = 0;
        while (i < navListeners.length) {
            navListeners[i].objetoExcluido(evt);
            ++i;
        }
    }

    public int getIndiceAtual() {
        return this.indexAtual;
    }

    public ObjetoNegocio getItem() {
        if (this.getColecao() != null && this.indexAtual > -1 && this.indexAtual < this.getColecao().recuperarLista().size()) {
            return (ObjetoNegocio)this.getColecao().recuperarLista().get(this.indexAtual);
        }
        return null;
    }

    public Colecao getColecao() {
        return this.colecao;
    }

    public void addNavegadorColecaoListener(NavegadorColecaoListener listener) {
        this.listeners.add(NavegadorColecaoListener.class, listener);
    }

    public void removeNavegadorColecaoListener(NavegadorColecaoListener listener) {
        this.listeners.remove(NavegadorColecaoListener.class, listener);
    }

    public void addNavegadorRemocaoListener(NavegadorRemocaoListener listener) {
        this.remocaoListeners.add(NavegadorRemocaoListener.class, listener);
    }

    public void removeNavegadorRemocaoListener(NavegadorRemocaoListener listener) {
        this.remocaoListeners.remove(NavegadorRemocaoListener.class, listener);
    }

    public void setEstiloFonte(int estilo) {
    }

    public void setIncrementoTamanhoFonte(int incremento) {
    }

    public int getIncrementoTamanhoFonte() {
        return 0;
    }

    public Icon getIconePrimeiro() {
        if (this.iconePrimeiro == null) {
            this.iconePrimeiro = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-primeiro.png"));
        }
        return this.iconePrimeiro;
    }

    public void setIconePrimeiro(Icon icon) {
        this.iconePrimeiro = icon;
        this.btnPrimeiro.setIcon(this.getIconePrimeiro());
    }

    public Icon getIconeAnterior() {
        if (this.iconeAnterior == null) {
            this.iconeAnterior = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-anterior.png"));
        }
        return this.iconeAnterior;
    }

    public void setIconeAnterior(Icon icon) {
        this.iconeAnterior = icon;
        this.btnAnterior.setIcon(this.getIconeAnterior());
    }

    public Icon getIconeProximo() {
        if (this.iconeProximo == null) {
            this.iconeProximo = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-proximo.png"));
        }
        return this.iconeProximo;
    }

    public void setIconeProximo(Icon icon) {
        this.iconeProximo = icon;
        this.btnProximo.setIcon(this.getIconeProximo());
    }

    public Icon getIconeUltimo() {
        if (this.iconeUltimo == null) {
            this.iconeUltimo = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-ultimo.png"));
        }
        return this.iconeUltimo;
    }

    public void setIconeUltimo(Icon icon) {
        this.iconeUltimo = icon;
        this.btnUltimo.setIcon(this.getIconeUltimo());
    }

    public Icon getIconeAdicionar() {
        if (this.iconeAdicionar == null) {
            this.iconeAdicionar = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-adiciona.png"));
        }
        return this.iconeAdicionar;
    }

    public void setIconeAdicionar(Icon icon) {
        this.iconeAdicionar = icon;
        this.btnAdicionar.setIcon(this.getIconeAdicionar());
    }

    public Icon getIconeRemover() {
        if (this.iconeRemover == null) {
            this.iconeRemover = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/nav-remove.png"));
        }
        return this.iconeRemover;
    }

    public void setIconeRemover(Icon icon) {
        this.iconeRemover = icon;
        this.btnRemover.setIcon(this.getIconeRemover());
    }

    public void ordenaColecao() {
        Collections.sort(this.colecao.recuperarLista(), Collections.reverseOrder());
    }

    public int localizaPorChave(String chave) {
        Iterator it = this.colecao.recuperarLista().iterator();
        int count = -1;
        boolean achou = false;
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ObjetoComChave)) continue;
            ObjetoComChave objComChave = (ObjetoComChave)obj;
            ++count;
            if (!objComChave.getChave().equals(chave)) continue;
            achou = true;
            break;
        }
        if (achou && count > -1) {
            this.exibe(count);
            return count;
        }
        return -1;
    }

    public static void main(String[] args) {
        new JNavegadorColecao();
    }

    public void setModoNavegador(int modoNavegador) {
        this.modoNavegador = modoNavegador;
        this.buildComponente();
    }

    public int getModoNavegador() {
        return this.modoNavegador;
    }

    public void bindKeys(JComponent c) {
        InputMap inputMap = c.getInputMap(1);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 8), "anterior");
        actionMap.put("anterior", this.actionAnterior);
        inputMap.put(KeyStroke.getKeyStroke(39, 8), "proximo");
        actionMap.put("proximo", this.actionProximo);
        inputMap.put(KeyStroke.getKeyStroke(36, 8), "primeiro");
        actionMap.put("primeiro", this.actionPrimeiro);
        inputMap.put(KeyStroke.getKeyStroke(35, 8), "ultimo");
        actionMap.put("ultimo", this.actionUltimo);
        inputMap.put(KeyStroke.getKeyStroke(73, 8), "adicionar");
        actionMap.put("adicionar", this.actionAdicionar);
        inputMap.put(KeyStroke.getKeyStroke(69, 8), "remover");
        actionMap.put("remover", this.actionRemover);
    }
}

