/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.FiltroTeclado;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.ListPopupModel;
import serpro.ppgd.gui.xbeans.ListPopupRenderer;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.table.JTableEx;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class JEditPopupCombo
extends JEditCampo
implements ActionListener,
KeyListener {
    private JButton popupButton;
    private JLabel lblDescricao;
    private JDialog popup;
    private JTable tabelaPopup;
    private JScrollPane scrollPopup;
    protected int colunaExibidaLabel;
    protected int colunaExibidaCodigo;
    private boolean quebraAutomaticaTexto = false;

    public JEditPopupCombo() {
        super((Informacao)new Codigo("JEditPopupCombo"));
    }

    private void initButton() {
        ImageIcon icon = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/down_narrow.png"));
        this.popupButton = new JButton(icon);
        this.popupButton.setFocusable(true);
        this.popupButton.setPreferredSize(new Dimension(26, this.popupButton.getPreferredSize().height + 3));
        this.popupButton.addActionListener(this);
        this.popupButton.getAccessibleContext().setAccessibleName("Procura c\u00f3digo");
    }

    private void initLabelDescricao() {
        this.lblDescricao = new JLabel(" ");
        this.lblDescricao.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lblDescricao.setVerticalTextPosition(1);
        this.lblDescricao.setHorizontalTextPosition(2);
    }

    private void initPopup() {
        this.popup = new JDialog((Frame)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), false);
        this.popup.setDefaultCloseOperation(2);
        this.tabelaPopup = this.getTabelaPopup();
        this.tabelaPopup.setModel(new ListPopupModel(this.getInformacao()));
        this.tabelaPopup.setTableHeader(null);
        this.tabelaPopup.setSelectionMode(0);
        this.tabelaPopup.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                JEditPopupCombo.this.popup.setVisible(false);
                int indiceSelecionado = JEditPopupCombo.this.tabelaPopup.getSelectedRow();
                if (indiceSelecionado != -1) {
                    String cod = (String)JEditPopupCombo.this.tabelaPopup.getModel().getValueAt(indiceSelecionado, 0);
                    ((Codigo)JEditPopupCombo.this.getInformacao()).setConteudo(cod);
                }
            }
        });
        this.tabelaPopup.addKeyListener(this);
        this.tabelaPopup.setDefaultRenderer(Object.class, new ListPopupRenderer(this.tabelaPopup));
        this.scrollPopup = new JScrollPane(this.tabelaPopup);
        this.scrollPopup.setAutoscrolls(true);
        this.scrollPopup.setHorizontalScrollBarPolicy(32);
        this.scrollPopup.setVerticalScrollBarPolicy(20);
        int colFiltro = ((Codigo)this.getInformacao()).getColunaFiltro();
        this.tabelaPopup.addKeyListener(new FiltroTeclado(colFiltro, this.getInformacao(), this.popup, this.tabelaPopup, this.scrollPopup));
        this.tabelaPopup.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    JEditPopupCombo.this.popup.setVisible(false);
                }
            }
        });
        this.popup.getContentPane().add(this.scrollPopup);
        this.popup.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
            }

            public void windowLostFocus(WindowEvent e) {
                if (e.getOppositeWindow() != null && !e.getOppositeWindow().equals(JEditPopupCombo.this.popup)) {
                    JEditPopupCombo.this.popup.dispose();
                }
            }
        });
        this.popup.setUndecorated(true);
        ((JPanel)this.popup.getContentPane()).setBorder(BorderFactory.createRaisedBevelBorder());
        this.getTabelaPopup().setAutoResizeMode(0);
        this.ajustaLarguraColunas();
    }

    private void ajustaLarguraColunas() {
        List elementosTabela = ((Codigo)this.getInformacao()).getColecaoElementoTabela();
        int i = elementosTabela.size() - 1;
        while (i >= 0) {
            this.calculaLarguraColuna((ElementoTabela)elementosTabela.get(i));
            --i;
        }
    }

    private void calculaLarguraColuna(ElementoTabela elem) {
        JLabel lbl = new JLabel();
        int i = 0;
        while (i < elem.size()) {
            lbl.setText(elem.getConteudo(i));
            int larguraCol = this.getTabelaPopup().getColumnModel().getColumn(i).getWidth();
            if (lbl.getPreferredSize().width > larguraCol) {
                this.getTabelaPopup().getColumnModel().getColumn(i).setWidth(lbl.getPreferredSize().width);
                this.getTabelaPopup().getColumnModel().getColumn(i).setPreferredWidth(lbl.getPreferredSize().width);
            }
            ++i;
        }
    }

    public JTable getTabelaPopup() {
        if (this.tabelaPopup == null) {
            this.tabelaPopup = new JTableEx(){};
        }
        return this.tabelaPopup;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.popupButton == null) {
            this.initButton();
            this.initLabelDescricao();
            this.add((Component)this.popupButton, "West");
            this.add((Component)this.lblDescricao, "Center");
            JButtonMensagem btnMsg = this.getButtonMensagem();
            if (btnMsg != null) {
                this.add((Component)new PainelBotao(btnMsg), "East");
            }
            this.colunaExibidaLabel = 1;
            this.colunaExibidaCodigo = 0;
        }
    }

    protected void informacaoModificada() {
        this.initPopup();
        this.implementacaoPropertyChange(null);
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        this.popupButton.setEnabled(!readOnly);
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.popupButton.setEnabled(habilitado);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        ElementoTabela elem;
        if (evt != null && evt.getPropertyName() != null && evt.getPropertyName().equals("ComboReiniciado")) {
            this.setInformacao(this.getInformacao());
        }
        String codigo = " ";
        String texto = " ";
        if (!this.getInformacao().isVazio() && (elem = ((Codigo)this.getInformacao()).getElementoTabela()) != null) {
            codigo = elem.getConteudo(this.colunaExibidaCodigo);
            texto = this.quebraAutomaticaTexto ? "<HTML>" + elem.getConteudo(this.colunaExibidaLabel) + "</HTML>" : elem.getConteudo(this.colunaExibidaLabel);
        }
        this.lblDescricao.setText(texto);
        this.getAccessibleContext().setAccessibleName(String.valueOf(codigo) + " " + texto);
    }

    private void botaoAcionado() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JEditPopupCombo.this.popup == null) {
                    JEditPopupCombo.this.initPopup();
                }
                JEditPopupCombo.this.exibePopUp();
            }
        });
    }

    private void exibePopUp() {
        int linhaPreSelecionada = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        if (!this.getInformacao().isVazio()) {
            this.tabelaPopup.getSelectionModel().setSelectionInterval(linhaPreSelecionada, linhaPreSelecionada);
        } else {
            this.tabelaPopup.getSelectionModel().clearSelection();
            this.tabelaPopup.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.tabelaPopup.getPreferredSize().height < 160) {
            this.popup.setSize(new Dimension(350, this.tabelaPopup.getPreferredSize().height + 5));
        } else {
            this.popup.setSize(new Dimension(350, 160));
        }
        this.popup.setTitle("");
        this.popup.setLocationRelativeTo(null);
        Point ponto = this.popupButton.getLocationOnScreen();
        int larguraTela = Toolkit.getDefaultToolkit().getScreenSize().width;
        int larguraPopup = this.popup.getSize().width;
        if (ponto.x + larguraPopup > larguraTela) {
            int excesso = ponto.x + larguraPopup - larguraTela;
            ponto.x -= excesso;
        }
        ponto.y += this.popupButton.getSize().height;
        this.popup.setLocation(ponto);
        this.popup.setVisible(true);
        try {
            this.ajustaScroll();
        }
        catch (Exception excp) {
            excp.printStackTrace();
        }
        this.scrollPopup.getViewport().setViewPosition(new Point(0, 0));
    }

    private void ajustaScroll() {
        int totalLinhas = ((Codigo)this.getInformacao()).getColecaoElementoTabela().size();
        int indiceSelecionado = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        if (indiceSelecionado == -1) {
            this.scrollPopup.getVerticalScrollBar().setValue(this.scrollPopup.getVerticalScrollBar().getMinimum());
        }
        int valor = 0;
        int maximoScroll = this.scrollPopup.getVerticalScrollBar().getMaximum();
        this.scrollPopup.getVerticalScrollBar().setBlockIncrement(40);
        this.scrollPopup.getVerticalScrollBar().setUnitIncrement(20);
        valor = maximoScroll / totalLinhas * indiceSelecionado;
        this.scrollPopup.getVerticalScrollBar().setValue(valor);
    }

    public JComponent getComponenteEditor() {
        return this.popupButton;
    }

    public JComponent getComponenteFoco() {
        return this.popupButton;
    }

    public int getColunaExibidaLabel() {
        return this.colunaExibidaLabel;
    }

    public void setColunaExibidaLabel(int pColunaExibidaLabel) {
        this.colunaExibidaLabel = pColunaExibidaLabel;
    }

    public int getColunaExibidaCodigo() {
        return this.colunaExibidaCodigo;
    }

    public void setColunaExibidaCodigo(int colunaExibidaCodigo) {
        this.colunaExibidaCodigo = colunaExibidaCodigo;
    }

    public boolean isQuebraAutomaticaTexto() {
        return this.quebraAutomaticaTexto;
    }

    public void setQuebraAutomaticaTexto(boolean quebraAutomaticaTexto) {
        this.quebraAutomaticaTexto = quebraAutomaticaTexto;
    }

    public void setEstiloFonte(int estilo) {
    }

    public void setIncrementoTamanhoFonte(int incremento) {
    }

    public int getIncrementoTamanhoFonte() {
        return 0;
    }

    public void actionPerformed(ActionEvent e) {
        this.botaoAcionado();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

