/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JEditNI
extends JEditMascara
implements FocusListener {
    private static String maskara14 = "**************";
    private static String maskara11 = "***********";
    private static String maskaraCPF = "***.***.***-**";
    private static String maskaraCNPJ = "**.***.***/****-**";
    private static String caracteresValidos = "0123456789 ";
    private byte tiposAceitos = 0;

    public JEditNI() {
        this((Informacao)new NI(null, "NI"));
    }

    public JEditNI(Informacao campo) {
        this.setInformacao(campo);
        this.setCaracteresValidos(caracteresValidos);
        this.getComponenteEditor().addFocusListener(this);
    }

    public void setarMascaraCPF() {
        this.getInformacao().setConteudo(this.getInformacao().asString().trim());
        this.setMascara(maskaraCPF);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void setarMascaraCNPJ() {
        this.setMascara(maskaraCNPJ);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void focusLost(FocusEvent e) {
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    public void focusGained(FocusEvent e) {
        String txt = UtilitariosString.retiraMascara((String)this.componente.getText());
        if (this.tiposAceitos == 0 || this.tiposAceitos == 2) {
            this.setMascara(maskara14);
        } else {
            this.setMascara(maskara11);
        }
        this.setCaracteresValidos(caracteresValidos);
        this.componente.setText(txt);
    }

    private void aplicaMascaraCorrespondente(Informacao campo) {
        if (campo.asString().length() == 11 && (this.tiposAceitos == 0 || this.tiposAceitos == 1)) {
            this.setarMascaraCPF();
        } else if (campo.asString().length() == 14) {
            this.setarMascaraCNPJ();
        } else {
            this.setMascara(maskara14);
        }
    }

    protected void informacaoModificada() {
        super.informacaoModificada();
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    public void setTiposAceitos(byte tiposAceitos) {
        this.tiposAceitos = tiposAceitos;
    }
}

