/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampoTextoAbstract;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDTextArea;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class JEditMemo
extends JEditCampoTextoAbstract {
    private JTextArea componente;
    private JScrollPane scrollPane;
    private int nrMaxCaracteres = 3000;

    public JEditMemo() {
        this((Informacao)new Alfa("Memo"));
    }

    public JEditMemo(Informacao campo) {
        super(campo);
    }

    public JEditMemo(Informacao campo, int nrMaxCaracteres) {
        super(campo);
        this.setMaxChars(nrMaxCaracteres);
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setMaxChars(int nrMaxCaracteres) {
        this.nrMaxCaracteres = nrMaxCaracteres;
    }

    public int getMaxChars() {
        return this.nrMaxCaracteres;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.componente = new PPGDTextArea();
            this.scrollPane = new JScrollPane(this.componente);
            this.componente.setLineWrap(true);
            this.componente.setWrapStyleWord(true);
            this.componente.setTabSize(1);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    JEditMemo.this.setIdentificacaoFoco(false);
                    if (!JEditMemo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditMemo.this.verificaValidacoesImpeditivas(JEditMemo.this.componente.getText())) {
                        return;
                    }
                    JEditMemo.this.setObservadorAtivo(false);
                    String s = JEditMemo.this.componente.getText();
                    if (s.length() > JEditMemo.this.nrMaxCaracteres) {
                        s = s.substring(0, JEditMemo.this.nrMaxCaracteres);
                    }
                    JEditMemo.this.getInformacao().setConteudo(s);
                    JEditMemo.this.chamaValidacao();
                    JEditMemo.this.setObservadorAtivo(true);
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    char ch = e.getKeyChar();
                    boolean eventosEhInclusao = ch != '\uffff' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
                    int tamanhoTextoAtual = JEditMemo.this.componente.getText().length();
                    if (tamanhoTextoAtual >= JEditMemo.this.nrMaxCaracteres && eventosEhInclusao && JEditMemo.this.componente.getSelectedText() == null) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(JEditMemo.this.componente);
                    }
                }

                public void keyTyped(KeyEvent e) {
                    char ch = e.getKeyChar();
                    boolean eventosEhInclusao = ch != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
                    int tamanhoTextoAtual = JEditMemo.this.componente.getText().length();
                    if (tamanhoTextoAtual >= JEditMemo.this.nrMaxCaracteres && eventosEhInclusao && JEditMemo.this.componente.getSelectedText() == null) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(JEditMemo.this.componente);
                    }
                }
            });
        }
        this.add((Component)this.scrollPane, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    protected void informacaoModificada() {
        ((PPGDTextArea)this.componente).setInformacao(this.getInformacao());
        this.implementacaoPropertyChange(null);
    }
}

