/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampoTextoAbstract;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JEditMascara
extends JEditCampoTextoAbstract {
    protected JFormattedTextField componente;
    private MaskFormatter formatador;
    private String mascara;
    private boolean selecionaTextoOnFocusGained = true;
    private boolean sobrescreve = false;

    public JEditMascara() {
        super((Informacao)new Alfa("EditMascara"));
    }

    public JEditMascara(Informacao aInfo) {
        super(aInfo);
    }

    public JEditMascara(String aMascara) {
        this.setMascara(aMascara);
    }

    public JEditMascara(Informacao aInfo, String aMascara) {
        super(aInfo);
        this.setMascara(aMascara);
    }

    public void setMascara(String aMascara) {
        this.mascara = aMascara;
        this.aplicaMascara();
    }

    public String getMascara() {
        return this.mascara;
    }

    private void aplicaMascara() {
        try {
            if (this.formatador == null) {
                this.formatador = new MaskFormatter(this.mascara);
                this.componente.setFormatterFactory(new DefaultFormatterFactory(this.formatador));
            } else {
                this.formatador.setMask(this.mascara);
            }
            this.componente.setValue(null);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.implementacaoPropertyChange(null);
    }

    public void setCaracteresValidos(String caracteresValidos) {
        this.formatador.setValidCharacters(caracteresValidos);
    }

    public void setCaracteresInvalidos(String charsInvalidos) {
        this.formatador.setInvalidCharacters(charsInvalidos);
    }

    protected void informacaoModificada() {
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.implementacaoPropertyChange(null);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (this.campo == null) {
            return;
        }
        String valorSemMascara = this.campo.asString();
        String valorComMascara = UtilitariosString.retornaComMascara((String)valorSemMascara, (String)this.getFormatador().getMask());
        if (valorSemMascara.trim().equals("")) {
            ((PPGDFormattedTextField)this.componente).setText("");
            ((PPGDFormattedTextField)this.componente).setValue(null);
        } else {
            ((PPGDFormattedTextField)this.componente).setText(valorComMascara);
        }
        this.componente.setCaretPosition(0);
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void setarCampo() {
        String s = this.componente.getText();
        String valorSemMascara = UtilitariosString.retiraMascara((String)s);
        int tamMask = this.getMascara().length();
        if (s.length() > tamMask) {
            s = s.substring(0, tamMask);
        }
        this.getInformacao().setConteudo(valorSemMascara);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public boolean isSelecionaTextoOnFocusGained() {
        return this.selecionaTextoOnFocusGained;
    }

    public void setSelecionaTextoOnFocusGained(boolean selecionaTextoOnFocusGained) {
        this.selecionaTextoOnFocusGained = selecionaTextoOnFocusGained;
    }

    public boolean isSobrescreve() {
        return this.sobrescreve;
    }

    public void setSobrescreve(boolean sobrescreve) {
        this.sobrescreve = sobrescreve;
    }

    public MaskFormatter getFormatador() {
        return this.formatador;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            if (this.getMascara() == null) {
                this.setMascara("********");
                this.aplicaMascara();
            }
            int tamMask = this.getMascara().length();
            this.componente.setHorizontalAlignment(0);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (JEditMascara.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                (this).JEditMascara.this.componente.selectAll();
                            }
                        });
                    }
                }

                public void focusLost(FocusEvent e) {
                    JEditMascara.this.setIdentificacaoFoco(false);
                    if (JEditMascara.this.getInformacao() != null) {
                        if (!JEditMascara.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditMascara.this.verificaValidacoesImpeditivas(JEditMascara.this.componente.getText())) {
                            return;
                        }
                        JEditMascara.this.setarCampo();
                        JEditMascara.this.chamaValidacao();
                    }
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    JEditMascara.this.trataEventoKeyTyped(e);
                }
            });
        }
        this.add((Component)this.componente, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    public String getConteudoComMascara() {
        String valorSemMascara = UtilitariosString.retiraMascara((String)this.getInformacao().getConteudoFormatado());
        return UtilitariosString.retornaComMascara((String)valorSemMascara, (String)this.formatador.getMask());
    }

    protected void trataEventoKeyTyped(KeyEvent e) {
        boolean manipulacaoCursor;
        boolean bl = manipulacaoCursor = e.getKeyChar() == '\t' || e.getKeyChar() == '\n' || e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f' || e.getKeyChar() == '%' || e.getKeyChar() == '\'';
        if (this.getFormatador() != null && this.getFormatador().getValidCharacters() != null && this.getFormatador().getValidCharacters().indexOf(" ") == -1 && e.getKeyChar() == ' ') {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
            return;
        }
        if (manipulacaoCursor) {
            return;
        }
        char ch = e.getKeyChar();
        boolean eventosEhInclusao = ch != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
        int tamanhoTextoAtual = this.componente.getText().trim().length();
        if (this.sobrescreve && this.getMascara() != null && this.componente.getCaret().getDot() <= this.getMascara().length() && eventosEhInclusao && tamanhoTextoAtual >= this.getMascara().length() && this.componente.getSelectedText() == null) {
            this.componente.select(this.componente.getCaret().getDot(), this.componente.getCaret().getDot() + 1);
        }
        if (this.getMascara() != null && tamanhoTextoAtual >= this.getMascara().length() && eventosEhInclusao && this.componente.getSelectedText() == null) {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
        }
    }
}

