/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.rendpj.PainelRendPJTitular;
import serpro.ppgd.irpf.p;
import serpro.ppgd.irpf.rendpj.a;
import serpro.ppgd.irpf.rendpj.b;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class RendPJTitular
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_NI_FONTE_PAGADORA = "CPF/CNPJ da Fonte Pagadora";
    public static final String NOME_REND_RECEB_PJ = "Rend. Recebid";
    public static final String NOME_CONTRIB_PREV = "Contr. Prev. Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "IR Retido na Fonte";
    public static final String NOME_DECIMO_TERCEIRO = "13\u00ba Sal\u00e1rio";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
    protected p rendRecebidoPJ = new p(this, "Rend. Recebid");
    protected p contribuicaoPrevOficial = new p(this, "Contr. Prev. Oficial");
    protected p impostoRetidoFonte = new p(this, "IR Retido na Fonte");
    protected p decimoTerceiro = new p(this, "13\u00ba Sal\u00e1rio");

    public RendPJTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.addValidadores();
    }

    public void addValidadores() {
        ValidadorNaoNulo validadorNaoNulo = new a(this, 3);
        this.getNomeFontePagadora().addValidador((ValidadorIf)validadorNaoNulo);
        validadorNaoNulo = new b(this, 3);
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3));
        this.getNIFontePagadora().addValidador((ValidadorIf)validadorNaoNulo);
    }

    public void addObservador(Observador observador) {
        this.rendRecebidoPJ.addObservador(observador);
        this.contribuicaoPrevOficial.addObservador(observador);
        this.impostoRetidoFonte.addObservador(observador);
        this.decimoTerceiro.addObservador(observador);
        this.NIFontePagadora.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.rendRecebidoPJ.removeObservador(observador);
        this.contribuicaoPrevOficial.removeObservador(observador);
        this.impostoRetidoFonte.removeObservador(observador);
        this.decimoTerceiro.removeObservador(observador);
        this.NIFontePagadora.removeObservador(observador);
    }

    public Valor getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendRecebidoPJ() {
        return this.rendRecebidoPJ;
    }

    public Pendencia verificaValores(int n2) {
        Pendencia pendencia = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getDecimoTerceiro().isVazio() && this.getRendRecebidoPJ().isVazio()) {
            pendencia = new Pendencia(3, (Informacao)this.getRendRecebidoPJ(), "Valores RendPJ", this.tab.msg("rendpj_faltam_valores"), n2);
        }
        return pendencia;
    }

    public List verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        Pendencia pendencia = this.verificaValores(n2);
        if (pendencia != null) {
            pendencia.setClassePainel(this.getClasseFicha());
            list.add(pendencia);
        }
        return list;
    }

    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelRendPJTitular.class.getName();
    }
}

