/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpf;

import classes.H;
import classes.R;
import classes.aB;
import classes.aI;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpf.CPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPFDependente
extends Colecao {
    private WeakReference refDeclaracao;
    private Valor totalPensao = new Valor();
    private Valor totalExterior = new Valor();
    private Valor totalPrevidencia = new Valor();
    private Valor totalLivroCaixa = new Valor();
    private Valor totalDarfPago = new Valor();
    private Valor totalDependentes = new Valor();
    private Valor totalPessoaFisica = new Valor();
    private aB totalizador;

    public ColecaoRendPFDependente(DeclaracaoIRPF declaracaoIRPF) {
        super(ItemRendPFDependente.class.getName());
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PF e do Exterior - Dependentes");
        this.totalizador = new aB(this);
        this.addObservador(this.totalizador);
    }

    public void objetoInserido(Object object) {
        super.objetoInserido(object);
        object = (ItemRendPFDependente)((Object)object);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().addObservador(new aI(((ItemRendPFDependente)((Object)object)).getRendimentos()));
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalPensao().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalExterior().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalPrevidencia().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalLivroCaixa().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalDarfPago().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalDependentes().addObservador((Observador)this.totalizador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalPessoaFisica().addObservador((Observador)this.totalizador);
        Observador observador = new R((DeclaracaoIRPF)((Object)this.refDeclaracao.get()));
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalPessoaFisica().addObservador(observador);
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalExterior().addObservador(observador);
        observador = new H((DeclaracaoIRPF)((Object)this.refDeclaracao.get()));
        ((ItemRendPFDependente)((Object)object)).getRendimentos().getTotalLivroCaixa().addObservador(observador);
        ((ItemRendPFDependente)((Object)object)).aplicaNomeFicha();
        ((ItemRendPFDependente)((Object)object)).addValidador((DeclaracaoIRPF)((Object)this.refDeclaracao.get()));
    }

    public Valor getTotalDarfPago() {
        return this.totalDarfPago;
    }

    public Valor getTotalDependentes() {
        return this.totalDependentes;
    }

    public Valor getTotalExterior() {
        return this.totalExterior;
    }

    public Valor getTotalLivroCaixa() {
        return this.totalLivroCaixa;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPrevidencia() {
        return this.totalPrevidencia;
    }

    public Valor getTotalPessoaFisica() {
        return this.totalPessoaFisica;
    }

    public boolean todosCpfsPreenchidos() {
        boolean bl2 = true;
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext() && bl2) {
            ItemRendPFDependente itemRendPFDependente = (ItemRendPFDependente)((Object)iterator.next());
            boolean bl3 = bl2 = bl2 && !itemRendPFDependente.getCpf().isVazio();
        }
        return bl2;
    }

    public Collection getCpfDependentes() {
        ArrayList<CPFDependente> arrayList = new ArrayList<CPFDependente>();
        for (ItemRendPFDependente itemRendPFDependente : this.recuperarLista()) {
            CPFDependente cPFDependente = new CPFDependente();
            cPFDependente.getCpf().setConteudo(itemRendPFDependente.getCpf().asString());
            arrayList.add(cPFDependente);
        }
        return arrayList;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemRendPFDependente itemRendPFDependente : this.recuperarLista()) {
            if (!string.equals(itemRendPFDependente.getCpf().asString())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            ItemRendPFDependente itemRendPFDependente = (ItemRendPFDependente)((Object)iterator.next());
            if (!string.equals(itemRendPFDependente.getCpf().asString())) continue;
            iterator.remove();
        }
    }
}

