/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendavariavel;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendavariavel.ItemImpostoPagar;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemImpostoPagar
extends Colecao {
    private Valor total = new Valor((ObjetoNegocio)this, "Total");
    private String mes;
    private WeakReference declaracaoRef = null;

    public ColecaoItemImpostoPagar(DeclaracaoIRPF declaracaoIRPF, String string) {
        super(ItemImpostoPagar.class.getName());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.mes = string;
        this.total.setReadOnly(true);
    }

    public void objetoInserido(Object object) {
        ((ItemImpostoPagar)((Object)object)).getValor().addObservador((Observador)this);
        ((ItemImpostoPagar)((Object)object)).addValidador((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        ((ItemImpostoPagar)((Object)object)).setFicha("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade - " + this.mes);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemImpostoPagar)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String string) {
        for (ItemImpostoPagar itemImpostoPagar : this.recuperarLista()) {
            if (!string.equals(itemImpostoPagar.getCpf().asString())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            ItemImpostoPagar itemImpostoPagar = (ItemImpostoPagar)((Object)iterator.next());
            if (!string.equals(itemImpostoPagar.getCpf().asString())) continue;
            iterator.remove();
        }
    }

    public Valor calculaTotal() {
        this.total.clear();
        for (ItemImpostoPagar itemImpostoPagar : this.recuperarLista()) {
            this.total.append('+', (Valor)itemImpostoPagar.getValor());
        }
        return this.total;
    }

    public Valor getTotal() {
        return this.total;
    }

    private String getMes(int n2) {
        switch (n2) {
            case 0: {
                return "Janeiro";
            }
            case 1: {
                return "Fevereiro";
            }
            case 2: {
                return "Mar\u00e7o";
            }
            case 3: {
                return "Abril";
            }
            case 4: {
                return "Maio";
            }
            case 5: {
                return "Junho";
            }
            case 6: {
                return "Julho";
            }
            case 7: {
                return "Agosto";
            }
            case 8: {
                return "Setembro";
            }
            case 9: {
                return "Outubro";
            }
            case 10: {
                return "Novembro";
            }
            case 11: {
                return "Dezembro";
            }
        }
        return "";
    }
}

