/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.b;
import serpro.ppgd.irpf.pagamentos.u;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao {
    private static final String VALOR_PAGO_ALTO = "50.000,00";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Valor totalDeducoesInstrucao = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribuicaoFAPI = new Valor((ObjetoNegocio)this, "");
    private Valor totalDespesasMedicas = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensaoCartoral = new Valor((ObjetoNegocio)this, "");
    private Valor totalDeducaoIncentivo = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;
    private WeakReference declaracaoRef = null;

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        super(Pagamento.class.getName());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.setFicha("Pagamentos e Doa\u00e7\u00f5es Efetuados");
        this.inicializaGeradorIndices();
    }

    public void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.asString().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.asString());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.asString();
    }

    public void objetoInserido(Object object) {
        ((ObjetoNegocio)object).setFicha(this.getFicha());
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Pagamento pagamento = new Pagamento((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        pagamento.getIndice().setConteudo(this.proximoIndice());
        return pagamento;
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public boolean existeValorPagoAlto() {
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.getValorPago().comparacao(">", VALOR_PAGO_ALTO)) continue;
            return true;
        }
        return false;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("30") && !pagamento.getCodigo().asString().equals("31") && !pagamento.getCodigo().asString().equals("33") && !pagamento.getCodigo().asString().equals("34") || pagamento.getNiBeneficiario().asString().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("50") || pagamento.getNiBeneficiario().asString().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public NI recuperarNIMaiorDespMedicas() {
        b b2;
        b b3;
        Hashtable<String, b> hashtable = new Hashtable<String, b>();
        List list = this.recuperarLista();
        int n2 = 0;
        while (n2 < this.recuperarLista().size()) {
            Pagamento pagamento = (Pagamento)list.get(n2);
            if (pagamento.getCodigo().toString().equals("10") || pagamento.getCodigo().toString().equals("20") || pagamento.getCodigo().toString().equals("26")) {
                b3 = new Valor();
                if (pagamento.getValorPago().comparacao(">=", pagamento.getParcelaNaoDedutivel())) {
                    b3.append('+', pagamento.getValorPago());
                    b3.append('-', pagamento.getParcelaNaoDedutivel());
                }
                if ((b2 = (b)hashtable.get(pagamento.getNiBeneficiario())) == null) {
                    b2 = new b(this);
                    new b(this).a = b3;
                    b2.b = pagamento.getNiBeneficiario();
                    hashtable.put(b2.b.asString(), b2);
                } else {
                    b2.a.append('+', (Valor)b3);
                }
            }
            ++n2;
        }
        Iterator iterator = hashtable.values().iterator();
        b3 = null;
        if (iterator.hasNext()) {
            b3 = (b)iterator.next();
            while (iterator.hasNext()) {
                b2 = (b)iterator.next();
                if (!b2.a.comparacao(">", b3.a)) continue;
                b3 = b2;
            }
        }
        if (b3 == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return b3.b;
    }

    public NI recuperarNISegundoMaiorDespMedicas() {
        Object object;
        Object object2;
        Object object3 = new Hashtable();
        List list = this.recuperarLista();
        int n2 = 0;
        while (n2 < this.recuperarLista().size()) {
            Pagamento pagamento = (Pagamento)list.get(n2);
            if (pagamento.getCodigo().toString().equals("10") || pagamento.getCodigo().toString().equals("20") || pagamento.getCodigo().toString().equals("26")) {
                object2 = new Valor();
                if (pagamento.getValorPago().comparacao(">=", pagamento.getParcelaNaoDedutivel())) {
                    object2.append('+', pagamento.getValorPago());
                    object2.append('-', pagamento.getParcelaNaoDedutivel());
                }
                if ((object = (u)((Hashtable)object3).get(pagamento.getNiBeneficiario())) == null) {
                    object = new u(this);
                    new u(this).a = object2;
                    ((u)object).b = pagamento.getNiBeneficiario();
                    ((Hashtable)object3).put(((u)object).b.asString(), object);
                } else {
                    ((u)object).a.append('+', (Valor)object2);
                }
            }
            ++n2;
        }
        Iterator iterator = ((Hashtable)object3).values().iterator();
        object = null;
        if (iterator.hasNext()) {
            object2 = (u)iterator.next();
            while (iterator.hasNext()) {
                object3 = (u)iterator.next();
                if (((u)object3).a.comparacao(">", ((u)object2).a)) {
                    object = object2;
                    object2 = object3;
                    continue;
                }
                if (object != null && !((u)object3).a.comparacao(">", ((u)object).a)) continue;
                object = object3;
            }
        }
        if (object == null) {
            return new NI((ObjetoNegocio)this, "");
        }
        return ((u)object).b;
    }

    public boolean possuiDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        if (string != null && !string.isEmpty()) {
            while (iterator.hasNext()) {
                Pagamento pagamento = (Pagamento)iterator.next();
                if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) continue;
                return true;
            }
        }
        return false;
    }

    public void excluirPagamentosComDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_DEPENDENTE)) continue;
            iterator.remove();
        }
    }

    public void excluirPagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) continue;
            iterator.remove();
        }
    }

    public boolean existePagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (pagamento.getDependenteOuAlimentando().asString().isEmpty() || !pagamento.getDependenteOuAlimentando().asString().equals(string) || !pagamento.getTipo().asString().equals(Pagamento.TIPO_ALIMENTANDO)) continue;
            return true;
        }
        return false;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public void setTotalContribEmpregadoDomestico(Valor valor) {
        this.totalContribEmpregadoDomestico = valor;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }
}

