/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import classes.e;
import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.pagamentos.PainelPagamentos;
import serpro.ppgd.irpf.pagamentos.c;
import serpro.ppgd.irpf.pagamentos.h;
import serpro.ppgd.irpf.pagamentos.i;
import serpro.ppgd.irpf.pagamentos.j;
import serpro.ppgd.irpf.pagamentos.k;
import serpro.ppgd.irpf.pagamentos.l;
import serpro.ppgd.irpf.pagamentos.m;
import serpro.ppgd.irpf.pagamentos.n;
import serpro.ppgd.irpf.pagamentos.o;
import serpro.ppgd.irpf.pagamentos.p;
import serpro.ppgd.irpf.pagamentos.q;
import serpro.ppgd.irpf.pagamentos.r;
import serpro.ppgd.irpf.pagamentos.s;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.TabelaMensagens;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Pagamento
extends ObjetoNegocio
implements e,
ObjetoFicha {
    public static final String PAGAMENTO_INSTRUCAO_BR = "01";
    public static final String PAGAMENTO_INSTRUCAO_EX = "02";
    public static final String PAGAMENTO_MEDICO_BR = "10";
    public static final String PAGAMENTO_MEDICO_EX = "11";
    public static final String PAGAMENTO_HOSPITAL_BR = "20";
    public static final String PAGAMENTO_HOSPITAL_EX = "21";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_BR = "30";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_EX = "31";
    public static final String PAGAMENTO_PENSAODIVORCIO_BR = "33";
    public static final String PAGAMENTO_PENSAODIVORCIO_EX = "34";
    public static final String PAGAMENTO_PREVIPRIVADA = "36";
    public static final String PAGAMENTO_FAPI = "38";
    public static final String PAGAMENTO_ESTATCRIANCA = "40";
    public static final String PAGAMENTO_CULTURA = "41";
    public static final String PAGAMENTO_AUDIOVISUAIS = "42";
    public static final String PAGAMENTO_DESPORTO = "43";
    public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "50";
    public static final String PAGAMENTO_ADVOGADOS = "60";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
    public static final String PAGAMENTO_PROFLIBERAL = "66";
    public static final String PAGAMENTO_ALUGUEIS = "70";
    public static final String PAGAMENTO_ARRENDRURAL = "76";
    public static final String PAGAMENTO_DOACOES_ESPECIE_BR = "80";
    public static final String PAGAMENTO_DOACOES_BENS_BR = "81";
    public static final String PAGAMENTO_OUTROS = "99";
    public static final String PERC_LIMITE_DEDUCAO_CONTRIBUICAO_PREV_PRIV_FAPI = "0,12";
    public static final String PERC_LIMITE_DEDUCAO_INCENTIVO = "0,06";
    public static final String LIMITE_DESPESAS_INSTRUCAO = "2.708,94";
    public static final String NOME_CODIGO = "C\u00f3digo";
    public static final String NOME_TIPO = "Tipo";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", classes.h.f());
    private Alfa dependenteOuAlimentando = new Alfa((ObjetoNegocio)this, "Dependente/Alimentando", 60);
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI((ObjetoNegocio)this, "Erro!");
    private serpro.ppgd.irpf.p valorPago = new serpro.ppgd.irpf.p(this, "Valor Pago");
    private serpro.ppgd.irpf.p parcelaNaoDedutivel = new serpro.ppgd.irpf.p(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private Alfa nitEmpregadoDomestico = new Alfa((ObjetoNegocio)this, "NIT do empregado dom\u00e9stico");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "\u00cdndice");
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo");
    public static String TIPO_TITULAR = "T";
    public static String TIPO_DEPENDENTE = "D";
    public static String TIPO_ALIMENTANDO = "A";
    public static String TIPO_PADRAO = "V";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private WeakReference declaracaoRef = null;

    public Pagamento(DeclaracaoIRPF declaracaoIRPF) {
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.tipo.addObservador((Observador)new c(this));
        this.getCodigo().setColunaFiltro(1);
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new j(this, 3));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new l(this, 3, this.tab.msg("pagamento_NIT_branco")));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new k(this, 3, this.tab.msg("pagamento_NIT")));
        this.getCodigo().addValidador((ValidadorIf)new n(this, 3, this.tab.msg("pagamento_codigo")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, this.tab.msg("pagamento_codigo")));
        this.getNomeBeneficiario().addValidador((ValidadorIf)new m(this, 3));
        this.getNiBeneficiario().addValidador((ValidadorIf)new p(this, 3));
        this.getParcelaNaoDedutivel().addValidador((ValidadorIf)new o(this, 3));
        this.getValorPago().addValidador((ValidadorIf)new i(this, 3));
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new h(this, 3));
        this.getNiBeneficiario().addValidador((ValidadorIf)new s(this, 3));
        this.getTipo().addValidador((ValidadorIf)new r(this, 3, this.tab.msg("tipo_pagamento_vazio")));
        this.getTipo().addObservador((Observador)new q(this));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.dependenteOuAlimentando);
        list.add(this.nomeBeneficiario);
        list.add(this.niBeneficiario);
        list.add(this.nitEmpregadoDomestico);
        list.add(this.valorPago);
        list.add(this.parcelaNaoDedutivel);
        list.add(this.tipo);
        return list;
    }

    public void setNitEmpregadoDomestico(Alfa alfa) {
        this.nitEmpregadoDomestico = alfa;
    }

    public Alfa getNitEmpregadoDomestico() {
        return this.nitEmpregadoDomestico;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("\u00cdndice") || informacao.getNomeCampo().equals(NOME_TIPO) || informacao.getNomeCampo().equals(NOME_CODIGO)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        object = (Pagamento)object;
        int n2 = ((Pagamento)object).getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public String getChave() {
        return this.getCodigo().asString();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public boolean ehTitularBrasil() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehTitularExterior() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehDependenteBrasil() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehDependenteExterior() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehAlimentandoBrasil() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehAlimentandoExterior() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && this.getCodigo().asString().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public String getClasseFicha() {
        return PainelPagamentos.class.getName();
    }

    static /* synthetic */ WeakReference a(Pagamento pagamento) {
        return pagamento.declaracaoRef;
    }

    static /* synthetic */ Alfa b(Pagamento pagamento) {
        return pagamento.tipo;
    }

    static /* synthetic */ Codigo c(Pagamento pagamento) {
        return pagamento.codigo;
    }

    static /* synthetic */ Alfa d(Pagamento pagamento) {
        return pagamento.nomeBeneficiario;
    }

    static /* synthetic */ NI e(Pagamento pagamento) {
        return pagamento.niBeneficiario;
    }

    static /* synthetic */ TabelaMensagens f(Pagamento pagamento) {
        return pagamento.tab;
    }
}

