/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.table;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import serpro.ppgd.gui.table.TableUIEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTableEx
extends JTable {
    protected Map<Integer, Integer> rowHeights = new HashMap<Integer, Integer>();

    public JTableEx() {
        this(null, null, null);
    }

    public JTableEx(TableModel dm) {
        this(dm, null, null);
    }

    public JTableEx(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public JTableEx(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.setUI(new TableUIEx());
    }

    public JTableEx(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public JTableEx(Vector<Object> rowData, Vector<Object> columnNames) {
        super(rowData, columnNames);
        this.setUI(new TableUIEx());
    }

    public JTableEx(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setUI(new TableUIEx());
    }

    @Override
    public int rowAtPoint(Point point) {
        int y = point.y;
        if (y < 0) {
            return -1;
        }
        int rowSpacing = this.getIntercellSpacing().height;
        int rowCount = this.getRowCount();
        int rowHeight = 0;
        int i = 0;
        while (i < rowCount) {
            if (y < (rowHeight += this.getRowHeight(i) + rowSpacing)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        int index = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        Rectangle cellFrame = new Rectangle();
        cellFrame.height = this.getRowHeight(row) + this.rowMargin;
        int rowSpacing = this.getIntercellSpacing().height;
        int y = 0;
        int i = 0;
        while (i < row) {
            y += this.getRowHeight(i) + rowSpacing;
            ++i;
        }
        cellFrame.y = y;
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + columnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Rectangle dirtyRegion;
        if (e == null || e.getFirstRow() == -1) {
            this.clearSelection();
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            return;
        }
        if (e.getType() == 1) {
            this.tableRowsInserted(e);
            return;
        }
        if (e.getType() == -1) {
            this.tableRowsDeleted(e);
            return;
        }
        int modelColumn = e.getColumn();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start == -1) {
            start = 0;
            end = Integer.MAX_VALUE;
        }
        if (modelColumn == -1) {
            dirtyRegion = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int column = this.convertColumnIndexToView(modelColumn);
            dirtyRegion = this.getCellRect(start, column, false);
        }
        if (end != Integer.MAX_VALUE) {
            dirtyRegion.height = this.getCellRect((int)(end + 1), (int)0, (boolean)false).y - dirtyRegion.y;
            this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
        } else {
            this.resizeAndRepaint();
        }
    }

    private void tableRowsInserted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int rowCount = this.getRowCount();
        int rowsInserted = end - start + 1;
        int r = start;
        while (r < rowCount) {
            Integer height = this.rowHeights.get(r);
            if (height != null) {
                this.rowHeights.put(r + rowsInserted, height);
            }
            ++r;
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)rowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            int length = end - start + 1;
            this.selectionModel.insertIndexInterval(start, length, true);
        }
        this.revalidate();
    }

    private void tableRowsDeleted(TableModelEvent e) {
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int deletedCount = end - start + 1;
        int previousRowCount = this.getRowCount() + deletedCount;
        int i = start;
        while (i <= end) {
            this.resetRowHeight(i);
            ++i;
        }
        int r = end + 1;
        while (r < previousRowCount) {
            Integer height = this.rowHeights.get(r);
            if (height != null) {
                this.rowHeights.put(r - deletedCount, height);
            }
            ++r;
        }
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = this.getCellRect((int)previousRowCount, (int)0, (boolean)false).y - drawRect.y;
        if (this.selectionModel != null) {
            if (end < 0) {
                end = this.getRowCount() - 1;
            }
            this.selectionModel.removeIndexInterval(start, end);
        }
        this.revalidate();
    }

    @Override
    public int getRowHeight(int row) {
        Integer o = this.rowHeights.get(row);
        if (o == null) {
            return this.getRowHeight();
        }
        return o;
    }

    @Override
    public void setRowHeight(int row, int height) {
        this.rowHeights.put(row, height);
        this.revalidate();
    }

    void resetRowHeight(int row) {
        this.rowHeights.remove(row);
        this.revalidate();
    }

    void resetRowHeight() {
        this.rowHeights.clear();
        this.revalidate();
    }
}

