/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import serpro.ppgd.gui.ConstantesGlobaisGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector<Object> v;
    protected String text;
    protected int margin = 0;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        this.renderer = renderer == null ? new MyTableCellRenderer() : renderer;
        this.text = text;
        this.v = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.v.add(obj);
    }

    public Vector<Object> getColumnGroups(TableColumn c, Vector<Object> g) {
        g.add(this);
        if (this.v.contains(c)) {
            return g;
        }
        Enumeration<Object> en = this.v.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            Vector<Object> aux = new Vector<Object>();
            Collections.copy(aux, g);
            Vector<Object> groups = ((ColumnGroup)obj).getColumnGroups(c, aux);
            if (groups == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration<Object> en = this.v.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                width += this.margin;
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public void setColumnMargin(int margin) {
        this.margin = margin;
        Enumeration<Object> en = this.v.elements();
        while (en.hasMoreElements()) {
            Object obj = en.nextElement();
            if (!(obj instanceof ColumnGroup)) continue;
            ((ColumnGroup)obj).setColumnMargin(margin);
        }
    }

    public int getLength() {
        return this.v.size();
    }

    public class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setHorizontalAlignment(0);
            this.setText(value == null ? "" : value.toString());
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, ConstantesGlobaisGUI.COR_CINZA));
            UIManager.put("TableHeader.cellBorder", BorderFactory.createMatteBorder(0, 0, 1, 1, ConstantesGlobaisGUI.COR_CINZA));
            return this;
        }
    }
}

