/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class SplashScreen
extends JWindow {
    private static final String SPLASH_DEFAULT = "/icones/splash_ppgd.png";
    private boolean rodando = true;

    public SplashScreen(Frame parent, int segundos) {
        super(parent);
        URL urlSplash = UtilitariosArquivo.localizaArquivoEmClasspath((String)SPLASH_DEFAULT);
        int width = new ImageIcon(urlSplash).getIconWidth();
        int height = new ImageIcon(urlSplash).getIconHeight();
        this.init(segundos, new JLabel("<HTML><body bgcolor=white><IMG width='" + width + "' height='" + height + "'  SRC='" + urlSplash + "' ><br><p align=right><br><a href=#>Clique na imagem para fechar anima&ccedil;&atilde;o</a> <br></body></HTML>"));
    }

    public SplashScreen(Frame parent, int segundos, JLabel lblIcon) {
        this.init(segundos, lblIcon);
    }

    public SplashScreen(Frame parent, int segundos, String filename) {
        super(parent);
        URL urlSplash = UtilitariosArquivo.localizaArquivoEmClasspath((String)filename);
        int width = new ImageIcon(urlSplash).getIconWidth();
        int height = new ImageIcon(urlSplash).getIconHeight();
        this.init(segundos, new JLabel("<HTML><body bgcolor=white><IMG width='" + width + "' height='" + height + "'  SRC='" + urlSplash + "' ><br><p align=right><br><a href=#>Clique na imagem para fechar anima&ccedil;&atilde;o</a> <br></body></HTML>"));
    }

    public SplashScreen(Frame parent) {
        super(parent);
    }

    public SplashScreen(String filename, Frame parent, int segundos) {
        super(parent);
        URL urlSplash = UtilitariosArquivo.localizaArquivoEmClasspath((String)filename);
        int width = new ImageIcon(urlSplash).getIconWidth();
        int height = new ImageIcon(urlSplash).getIconHeight();
        this.init(segundos, new JLabel("<HTML><body bgcolor=white><IMG width='" + width + "' height='" + height + "'  SRC='" + urlSplash + "' ><br><p align=right><br><a href=#>Clique na imagem para fechar anima&ccedil;&atilde;o</a> <br></body></HTML>"));
    }

    protected void init(int segundos, JLabel l) {
        l.setCursor(Cursor.getPredefinedCursor(12));
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                SplashScreen.this.fecha();
            }
        });
        final int pause = segundos * 1000;
        final Runnable closerRunner = new Runnable(){

            public void run() {
                SplashScreen.this.fecha();
            }
        };
        Runnable waitRunner = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.setVisible(true);
        if (segundos > -1) {
            Thread splashThread = new Thread(waitRunner, "SplashThread");
            splashThread.start();
        }
    }

    public void fecha() {
        this.setVisible(false);
        this.dispose();
        this.setRodando(false);
    }

    public void aguardaTerminar() {
        while (this.isRodando()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void setRodando(boolean rodando) {
        this.rodando = rodando;
    }

    private synchronized boolean isRodando() {
        return this.rodando;
    }
}

