/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;

class KeySelectionCustomizado
implements JComboBox.KeySelectionManager {
    long ultimaVez = 0L;
    String filtro = "";
    int colunaFiltro;
    int maxDelayFiltroTecla = 500;

    public KeySelectionCustomizado(int aColunaFiltro) {
        this.colunaFiltro = aColunaFiltro;
        this.maxDelayFiltroTecla = Integer.parseInt(FabricaUtilitarios.getProperties().getProperty("maxDelayFiltroEditCodigo", "500"));
    }

    public void setColunaFiltro(int aColunaFiltro) {
        this.colunaFiltro = aColunaFiltro;
    }

    public int selectionForKey(char aKey, ComboBoxModel aModel) {
        int itemSelecionado = -1;
        if (this.colunaFiltro >= 0) {
            long atual = System.currentTimeMillis();
            long diferenca = atual - this.ultimaVez;
            if (diferenca < (long)this.maxDelayFiltroTecla) {
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            } else {
                this.filtro = "";
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            }
            this.ultimaVez = atual;
            if (this.filtro.length() > 100) {
                this.filtro = "";
            }
        }
        return itemSelecionado;
    }

    private synchronized int tentaSelecionar(ComboBoxModel aModel) {
        int total = aModel.getSize();
        int itemSelecionado = -1;
        String upperFiltro = this.filtro.toUpperCase();
        int i = 0;
        while (i < total) {
            ElementoTabela elem = (ElementoTabela)aModel.getElementAt(i);
            String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaFiltro));
            if (item.toUpperCase().startsWith(upperFiltro)) {
                itemSelecionado = i;
                break;
            }
            ++i;
        }
        return itemSelecionado;
    }
}

