/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.UtilitariosString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboElementoTabela
extends JComboBox {
    protected Vector<ElementoTabela> vItems;
    protected int widthTable;
    protected Vector<String> maiorLinha = new Vector();
    protected Vector<Integer> tamColunas = new Vector();

    public ComboElementoTabela(Vector<ElementoTabela> vItems) {
        super(vItems);
        this.vItems = vItems;
        int nCols = this.init();
        this.setBackground(ConstantesGlobaisGUI.COR_BRANCO);
        this.setForeground(ConstantesGlobaisGUI.COR_PRETO);
        this.setUI(this.getCustomLocalUI());
        this.setBorder(this.getCustomBorder());
        this.setRenderer(this.getCustomRenderer(nCols));
    }

    public ComboElementoTabela(Vector<ElementoTabela> vItems, int aColunaFiltro) {
        this(vItems);
        if (aColunaFiltro != -1) {
            this.setKeySelectionManager(new KeySelectionCustomizado(aColunaFiltro));
        }
    }

    public ListCellRenderer getCustomRenderer(int nCols) {
        return new LocalRenderer(this, nCols);
    }

    public EtchedBorder getCustomBorder() {
        return new EtchedBorder();
    }

    public BasicComboBoxUI getCustomLocalUI() {
        return new LocalUI();
    }

    public void setColecao(Vector<ElementoTabela> vItems) {
        this.setModel(new DefaultComboBoxModel<ElementoTabela>(vItems));
        this.vItems = vItems;
        int nCols = this.init();
        this.setRenderer(this.getCustomRenderer(nCols));
    }

    public Vector<ElementoTabela> getColecao() {
        return this.vItems;
    }

    public void setPopupWidth(int width) {
        this.widthTable = width;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        if (this.widthTable < 1) {
            this.widthTable = size.width;
        }
        return new Dimension(this.widthTable, size.height);
    }

    public void setSizeCol(int coluna, int valor) {
        this.tamColunas.set(coluna, valor);
    }

    public int init() {
        ElementoTabela elementoTabela;
        if (this.vItems.size() == 0) {
            elementoTabela = new ElementoTabela();
            elementoTabela.setConteudo(0, "  ");
            this.vItems.add(elementoTabela);
        }
        elementoTabela = this.vItems.firstElement();
        int nCols = elementoTabela.size();
        int i = 0;
        while (i < nCols) {
            this.maiorLinha.add("");
            this.tamColunas.add(0);
            ++i;
        }
        i = 0;
        while (i < this.vItems.size()) {
            elementoTabela = this.vItems.get(i);
            int j = 0;
            while (j < elementoTabela.size()) {
                if (elementoTabela.getConteudo(j).length() > this.maiorLinha.get(j).length()) {
                    this.maiorLinha.set(j, elementoTabela.getConteudo(j));
                }
                ++j;
            }
            ++i;
        }
        return nCols;
    }

    private class LocalUI
    extends BasicComboBoxUI {
        private BasicComboPopup customPopup;

        LocalUI() {
        }

        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this, this.comboBox){
                final /* synthetic */ LocalUI this$1;
                {
                    this.this$1 = localUI;
                    super($anonymous0);
                }

                protected JScrollPane createScroller() {
                    JScrollPane jscrollpane = new JScrollPane(this.list, 20, 30);
                    return jscrollpane;
                }

                public void show() {
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    Dimension popupSize = ((ComboElementoTabela)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, popupBounds.x, popupBounds.y);
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            this.customPopup = popup;
            return popup;
        }

        public BasicComboPopup getCustomPopup() {
            return this.customPopup;
        }

        public void setCustomPopup(BasicComboPopup customPopup) {
            this.customPopup = customPopup;
        }
    }

    private class LocalRenderer
    extends JTable
    implements ListCellRenderer {
        private ComboElementoTabela combo;
        private int nCols;

        public LocalRenderer(ComboElementoTabela combo, int nCols) {
            super(1, nCols);
            this.combo = combo;
            this.nCols = nCols;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            Graphics g = this.combo.getGraphics();
            int w = 0;
            int tamTotal = 0;
            int tamCol = 0;
            if (value instanceof ElementoTabela) {
                ElementoTabela elementoTabela = (ElementoTabela)value;
                int i = 0;
                while (i < this.nCols) {
                    this.getModel().setValueAt(elementoTabela.getConteudo(i), 0, i);
                    TableColumnModel columnModel = this.getColumnModel();
                    TableColumn tableColumn = columnModel.getColumn(i);
                    tamCol = ComboElementoTabela.this.tamColunas.get(i);
                    if (g != null) {
                        if (tamCol != 0) {
                            w = g.getFontMetrics(g.getFont()).charWidth('0') * tamCol;
                            w = i == 0 ? (w += 17) : (w += 8);
                        } else {
                            w = g.getFontMetrics(g.getFont()).stringWidth(ComboElementoTabela.this.maiorLinha.get(i)) + 8;
                        }
                    } else {
                        w = 50;
                    }
                    tableColumn.setMaxWidth(w);
                    tableColumn.setMinWidth(w);
                    tamTotal += w;
                    ++i;
                }
                this.setRowSelectionAllowed(true);
                ComboElementoTabela.this.setPopupWidth(tamTotal + 17);
            } else if (index == -1) {
                this.getModel().setValueAt(" ", 0, 0);
            }
            return this;
        }
    }

    private class KeySelectionCustomizado
    implements JComboBox.KeySelectionManager {
        long ultimaVez = 0L;
        String filtro = "";
        int colunaFiltro;

        public KeySelectionCustomizado(int aColunaFiltro) {
            this.colunaFiltro = aColunaFiltro;
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            long atual = System.currentTimeMillis();
            long diferenca = atual - this.ultimaVez;
            int itemSelecionado = -1;
            if (diferenca < 500L) {
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            } else {
                this.filtro = "";
                this.filtro = String.valueOf(this.filtro) + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            }
            this.ultimaVez = atual;
            if (this.filtro.length() > 100) {
                this.filtro = "";
            }
            return itemSelecionado;
        }

        private synchronized int tentaSelecionar(ComboBoxModel aModel) {
            int total = aModel.getSize();
            int itemSelecionado = -1;
            String upperFiltro = this.filtro.toUpperCase();
            int i = 0;
            while (i < total) {
                ElementoTabela elem = (ElementoTabela)aModel.getElementAt(i);
                String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaFiltro));
                if (item.toUpperCase().startsWith(upperFiltro)) {
                    itemSelecionado = i;
                    break;
                }
                ++i;
            }
            return itemSelecionado;
        }
    }
}

