/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Validador {
    public static final String NOME_BRANCO = "Nome em branco.";
    public static final String NOME_MAIS_60 = "Nome tem mais que 60 caracteres.";
    public static final String NOME_MENOS_2 = "Nome tem menos de 2 partes.";
    public static final String NOME_MAIS_15 = "Nome tem mais de 15 partes.";
    public static final String NOME_1_CARACTER = "Primeira parte do nome tem somente um caracter.";
    public static final String NOME_MAIS_20 = "Parte do nome tem mais de 20 caracteres.";
    public static final String NOME_3_CONSECUTIVOS = "Nome com 3 caracteres iguais consecutivos.";
    public static final String NOME_NUMERICO = "Nome n\u00e3o pode ter n\u00fameros.";
    public static final String NOME_INVALIDO = "Nome tem caracteres inv\u00e1lidos.";
    public static final String NOME_ESPOLIO = "Deve ser informado o nome sem a palavra ESP\u00d3LIO.";
    public static final String DATA_INVALIDO = "Data inv\u00e1lida ou em branco.";
    public static final String DATA_DIA_INVALIDO = "Data com dia inv\u00e1lido.";
    public static final String DATA_MES_INVALIDO = "Data com m\u00eas inv\u00e1lido.";
    public static final String DATA_ANO_INVALIDO = "Data com ano inv\u00e1lido.";
    public static final String VALOR_GRANDE = "Valor informado excede o tamanho do campo.";
    public static final String VALOR_NEGATIVO = "Valor n\u00e3o pode ser negativo.";
    public static final String EMAIL_INVALIDO = "Correio eletr\u00f4nico inv\u00e1lido ou em branco.";
    public static final String NI_INVALIDO = "CNPJ/CPF inv\u00e1lido ou em branco.";
    public static final String TITULO_INVALIDO = "N\u00famero do t\u00edtulo eleitoral inv\u00e1lido.";
    public static final String CNPJ_INVALIDO = "CNPJ inv\u00e1lido ou em branco.";
    public static final String CPF_INVALIDO = "CPF inv\u00e1lido ou em branco.";
    public static final String DDD_DDI_INVALIDO = "DDD/DDI inv\u00e1lido ou em branco.";
    public static final String DDD_DDI_2_DIGITOS = "O campo DDD/DDI deve ter 2 d\u00edgitos.";
    public static final String CEP_INVALIDO = "CEP inv\u00e1lido.Informe-o com oito d\u00edgitos num\u00e9ricos.";
    public static final String NIRF_INVALIDO = "N\u00famero do Im\u00f3vel na Receita inv\u00e1lido.";
    public static final String NIT_INVALIDO = "NIT inv\u00e1lido ou em branco.";
    public static final int DATA_OK = 0;
    public static final int DATA_INVALIDA_FORMATO_INVALIDO = 1;
    public static final int DATA_INVALIDA_DIA_INVALIDO = 2;
    public static final int DATA_INVALIDA_MES_INVALIDO = 3;
    public static final int DATA_INVALIDA_ANO_INVALIDO = 4;
    public static final int MOD11_CASO_0 = 0;
    public static final int MOD11_CASO_1 = 1;
    public static final int MOD11_CASO_2 = 2;

    public static int calcularModulo11(String stEnt, String stMult, int inStatus) {
        int inSoma = 0;
        if (stMult == null) {
            for (int i = 0; i < stEnt.length(); ++i) {
                inSoma += (stEnt.length() + 1 - i) * Character.getNumericValue(stEnt.charAt(i));
            }
        } else {
            for (int i = 0; i < stEnt.length(); ++i) {
                inSoma += Character.getNumericValue(stMult.charAt(i)) * Character.getNumericValue(stEnt.charAt(i));
            }
        }
        int inResto = inSoma - inSoma / 11 * 11;
        int inMod11 = 11 - inResto;
        if (inStatus == 2) {
            if (inMod11 > 9) {
                inMod11 = 0;
            }
        } else if (inStatus == 1) {
            if (inMod11 == 10) {
                inMod11 = 0;
            }
            if (inMod11 == 11) {
                inMod11 = 1;
            }
        }
        return inMod11;
    }

    public static boolean validarModulo11(String stEnt, String stMult, int inStatus) {
        String stDigVerif;
        int inDigVerif;
        String stNumero = stEnt.substring(0, stEnt.length() - 1);
        int inDigVerifCalc = Validador.calcularModulo11(stNumero, stMult, inStatus);
        return inDigVerifCalc == (inDigVerif = Integer.valueOf(stDigVerif = stEnt.substring(stEnt.length() - 1, stEnt.length())).intValue());
    }

    public static RetornoValidacao validarCPF(String stCPF) {
        if (stCPF == null || stCPF.equals("")) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        String CPFInvalidos = "00000000000 00000000191 99999999999 11111111111 22222222222 33333333333 44444444444 55555555555 66666666666 77777777777 88888888888 99999999999";
        if (CPFInvalidos.indexOf(stCPF) != -1) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (!UtilitariosString.isNumeric(stCPF)) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (stCPF.length() != 11) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        if (!Validador.validarModulo11(stCPF.substring(0, 10), null, 2) || !Validador.validarModulo11(stCPF, null, 2)) {
            return new RetornoValidacao(CPF_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNIRF(String pNIRF) {
        if (pNIRF.trim().length() < 8) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        if (pNIRF.trim().equals("00000000")) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        if (!Validador.validarModulo11(pNIRF, null, 2)) {
            return new RetornoValidacao(NIRF_INVALIDO, 2);
        }
        return null;
    }

    public static RetornoValidacao validarCNPJ(String stCNPJ) {
        if (stCNPJ == null || stCNPJ.equals("")) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (!UtilitariosString.isNumeric(stCNPJ)) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (stCNPJ.length() != 14) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (stCNPJ.equals("11111111000191") || stCNPJ.equals("00000000000000") || stCNPJ.equals("22222222000191") || stCNPJ.equals("33333333000191") || stCNPJ.equals("44444444000191") || stCNPJ.equals("55555555000191") || stCNPJ.equals("66666666000191") || stCNPJ.equals("77777777000191") || stCNPJ.equals("88888888000191") || stCNPJ.equals("99999999000191")) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        if (!Validador.validarModulo11(stCNPJ.substring(0, 13), "543298765432", 2) || !Validador.validarModulo11(stCNPJ, "6543298765432", 2)) {
            return new RetornoValidacao(CNPJ_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarTituloEleitor(String tituloEleitor) {
        if (tituloEleitor == null || tituloEleitor.equals("")) {
            return new RetornoValidacao(TITULO_INVALIDO);
        }
        int tamanho = (tituloEleitor = tituloEleitor.trim()).length();
        if (tamanho > 13 || tamanho < 3) {
            return new RetornoValidacao(TITULO_INVALIDO);
        }
        tituloEleitor = "0000000000000".substring(0, 13 - tamanho) + tituloEleitor;
        if (!UtilitariosString.isNumeric(tituloEleitor)) {
            return new RetornoValidacao(TITULO_INVALIDO);
        }
        int uf = Integer.valueOf(tituloEleitor.substring(9, 11));
        if (uf < 1 || uf > 28) {
            return new RetornoValidacao(TITULO_INVALIDO);
        }
        int mod11 = uf == 1 || uf == 2 ? 1 : 2;
        if (!Validador.validarModulo11(tituloEleitor.substring(0, 9) + tituloEleitor.substring(11, 12), null, mod11) || !Validador.validarModulo11(tituloEleitor.substring(9, 12) + tituloEleitor.substring(12, 13), null, mod11)) {
            return new RetornoValidacao(TITULO_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNI(String ni) {
        if (ni == null || ni.equals("")) {
            return new RetornoValidacao(NI_INVALIDO);
        }
        if (ni.length() == 11) {
            return Validador.validarCPF(ni);
        }
        if (ni.length() == 14) {
            return Validador.validarCNPJ(ni);
        }
        return new RetornoValidacao(NI_INVALIDO);
    }

    public static int verificaData(String data) {
        int inAno;
        int inMes;
        int inDia;
        if (data == null || data.equals("  /  /    ")) {
            return 1;
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return 1;
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 2;
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 3;
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 4;
        }
        if (inMes <= 0 || inMes >= 13) {
            return 3;
        }
        maxDia = Validador.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            return 2;
        }
        return 0;
    }

    public static RetornoValidacao validarDataComCriterio(String data, String criterio) {
        int inAno;
        int inMes;
        if (data == null || data.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String token = tokenizer.nextToken();
        try {
            int inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int exercicioWord = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (criterio.equals("<") ? inAno <= 0 || inAno >= exercicioWord || inAno < exercicioWord - 133 && inAno != 0 : (criterio.equals("=") ? inAno <= 0 || inAno != exercicioWord || inAno < exercicioWord - 133 && inAno != 0 : criterio.equals(">") && (inAno <= 0 || inAno <= exercicioWord || inAno < exercicioWord - 133 && inAno != 0))) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarData(String data, int anoLimite) {
        int inAno;
        int inMes;
        int inDia;
        if (data == null || data.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int exercicioWord = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (inAno <= 0 || inAno >= anoLimite || inAno < exercicioWord - 131 && inAno != 0) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        maxDia = Validador.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarData(String data) {
        int inAno;
        int inMes;
        int inDia;
        if (data == null || data.equals("  /  /    ")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao(DATA_MES_INVALIDO);
        }
        int exercicioWord = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (inAno <= 0 || inAno >= exercicioWord || inAno < exercicioWord - 133 && inAno != 0) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        maxDia = Validador.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            return new RetornoValidacao(DATA_DIA_INVALIDO);
        }
        if (inAno > Integer.parseInt(ConstantesGlobais.ANO_BASE)) {
            return new RetornoValidacao(DATA_ANO_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarEmail(String email) {
        if (email == null || email.equals("")) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        int TAMANHO_CAMPO_EMAIL = 50;
        int objNumeroPalavras = 0;
        int numeroArrobas = 0;
        boolean j = false;
        objNumeroPalavras = UtilitariosString.ContaPalavras(email);
        if (objNumeroPalavras > 1) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        objNumeroPalavras = UtilitariosString.ContaPalavras(email, "@");
        if (objNumeroPalavras != 2) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        if (email.length() > 50) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        if (email.charAt(0) == '@') {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        for (int i = 1; i <= email.length() - 1; ++i) {
            if (email.charAt(i) == '@') {
                ++numeroArrobas;
            }
            if (email.charAt(i) == '.' && email.charAt(i - 1) == '.') {
                return new RetornoValidacao(EMAIL_INVALIDO);
            }
            if (email.charAt(i) != ' ') continue;
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        if (numeroArrobas != 1) {
            return new RetornoValidacao(EMAIL_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarNomeCompleto(String nomeCompleto) {
        if (nomeCompleto == null || nomeCompleto.equals("")) {
            return new RetornoValidacao(NOME_BRANCO);
        }
        if (nomeCompleto.length() > 60) {
            return new RetornoValidacao(NOME_MAIS_60);
        }
        StringTokenizer testeNomeCompleto = new StringTokenizer(nomeCompleto);
        if (testeNomeCompleto.countTokens() < 2) {
            return new RetornoValidacao(NOME_MENOS_2);
        }
        if (testeNomeCompleto.countTokens() > 15) {
            return new RetornoValidacao(NOME_MAIS_15);
        }
        RetornoValidacao rValidacao = null;
        boolean primeiraVez = true;
        while (testeNomeCompleto.hasMoreTokens()) {
            String testeNome = testeNomeCompleto.nextToken();
            if (primeiraVez) {
                if (testeNome.length() < 2) {
                    return new RetornoValidacao(NOME_1_CARACTER);
                }
                primeiraVez = false;
            }
            if ((rValidacao = Validador.validarNome(testeNome)) == null) continue;
            break;
        }
        return rValidacao;
    }

    private static RetornoValidacao validarNome(String parteNomeCompleto) {
        if (parteNomeCompleto == null || parteNomeCompleto.equals("")) {
            return new RetornoValidacao(NOME_BRANCO);
        }
        if (parteNomeCompleto.length() > 20) {
            return new RetornoValidacao(NOME_MAIS_20);
        }
        int letrasRepetidas = 1;
        for (int j = 1; j < parteNomeCompleto.length(); ++j) {
            letrasRepetidas = parteNomeCompleto.charAt(j) == parteNomeCompleto.charAt(j - 1) ? ++letrasRepetidas : 1;
            if (letrasRepetidas == 3 && !parteNomeCompleto.equals("III")) {
                return new RetornoValidacao(NOME_3_CONSECUTIVOS);
            }
            if (Character.isDigit(parteNomeCompleto.charAt(j - 1))) {
                return new RetornoValidacao(NOME_NUMERICO);
            }
            if (Character.isLetter(parteNomeCompleto.charAt(j - 1))) continue;
            return new RetornoValidacao(NOME_INVALIDO);
        }
        if (Character.isDigit(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao(NOME_NUMERICO);
        }
        if (!Character.isLetter(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao(NOME_INVALIDO);
        }
        if ("ESPOLIO".equals(parteNomeCompleto.toUpperCase()) || "ESP\u00d3LIO".equals(parteNomeCompleto.toUpperCase())) {
            return new RetornoValidacao(NOME_ESPOLIO);
        }
        return null;
    }

    public static RetornoValidacao validarDataDecisaoJudicialPartilha(Date DataDecisaoJudicialPartilha) {
        if (DataDecisaoJudicialPartilha == null || DataDecisaoJudicialPartilha.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataNaoResidente(Date dataNaoResidente) {
        if (dataNaoResidente == null || dataNaoResidente.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataResidente(Date dataResidente) {
        if (dataResidente == null || dataResidente.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDataTransitoJulgado(Date informarDataTransitoJulgado) {
        if (informarDataTransitoJulgado == null || informarDataTransitoJulgado.equals("")) {
            return new RetornoValidacao(DATA_INVALIDO);
        }
        return null;
    }

    public static RetornoValidacao validarDDD_DDI(String ddd) {
        if (ddd == null || ddd.equals("")) {
            return new RetornoValidacao(DDD_DDI_INVALIDO);
        }
        try {
            int d = Integer.parseInt(ddd);
        }
        catch (NumberFormatException excecaoConversao) {
            return new RetornoValidacao(DDD_DDI_INVALIDO);
        }
        if (ddd.length() != 2) {
            return new RetornoValidacao(DDD_DDI_2_DIGITOS);
        }
        return null;
    }

    public static RetornoValidacao validarCEP(String cep) {
        if (cep == null || cep.trim().equals("-")) {
            return new RetornoValidacao(CEP_INVALIDO);
        }
        if (cep.trim().length() != 8) {
            return new RetornoValidacao(CEP_INVALIDO);
        }
        return null;
    }

    private static int calculaDiasMes(int mes, int ano) {
        int retorno = 31;
        switch (mes) {
            case 1: {
                retorno = 31;
                break;
            }
            case 2: {
                GregorianCalendar calendar = new GregorianCalendar();
                if (calendar.isLeapYear(ano)) {
                    retorno = 29;
                    break;
                }
                retorno = 28;
                break;
            }
            case 3: {
                retorno = 31;
                break;
            }
            case 4: {
                retorno = 30;
                break;
            }
            case 5: {
                retorno = 31;
                break;
            }
            case 6: {
                retorno = 30;
                break;
            }
            case 7: {
                retorno = 31;
                break;
            }
            case 8: {
                retorno = 31;
                break;
            }
            case 9: {
                retorno = 30;
                break;
            }
            case 10: {
                retorno = 31;
                break;
            }
            case 11: {
                retorno = 30;
                break;
            }
            case 12: {
                retorno = 31;
            }
        }
        return retorno;
    }

    public static RetornoValidacao validarElementoTabela(String conteudo, List<ElementoTabela> colecao, String msgValidacao) {
        if (colecao != null) {
            for (int i = 0; i < colecao.size(); ++i) {
                ElementoTabela localElementoTabela = colecao.get(i);
                if (localElementoTabela.getConteudo(0).compareTo(conteudo) != 0) continue;
                return new RetornoValidacao(0);
            }
        }
        return new RetornoValidacao(msgValidacao);
    }

    public static boolean validarNrRecibo(String value) {
        int dvPassado;
        int dvCalculado;
        if ((value = value.trim()).length() == 0 || value.length() != 12 && value.length() != 9 || !UtilitariosString.isNumeric(value)) {
            return false;
        }
        return !(value.length() == 9 ? (dvCalculado = Validador.calculaDVRecibo9Digitos(value)) != (dvPassado = Integer.parseInt(value.substring(value.length() - 1))) : !Validador.validarModulo11(value.substring(0, 11), null, 2) || !Validador.validarModulo11(value, null, 2));
    }

    private static int calculaDVRecibo9Digitos(String numRecibo) {
        int retorno = 0;
        int[] fatores = new int[]{8, 6, 4, 2, 3, 5, 9, 7};
        int totalProduto = 0;
        for (int i = 0; i < fatores.length; ++i) {
            int digitoAtual = Integer.parseInt(numRecibo.substring(i, i + 1));
            totalProduto += digitoAtual * fatores[i];
        }
        retorno = (totalProduto %= 11) == 0 ? 5 : (totalProduto == 1 ? 0 : 11 - totalProduto);
        return retorno;
    }

    public static boolean validarString(String s, String regExp) {
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(s);
        return m.find();
    }

    public static boolean validarCodImovelIncra(String pCod) {
        if (!Validador.validarModulo11(pCod, "765432765432", 2)) {
            return false;
        }
        if (!Validador.validarModulo11(pCod.substring(0, 6), "65432", 2)) {
            return false;
        }
        return Validador.validarModulo11(pCod.substring(6, 12), "65432", 2);
    }

    public static RetornoValidacao validarNIT(String pNIT) {
        if ((pNIT = pNIT.trim()).length() == 0 || pNIT.length() != 11 || !UtilitariosString.isNumeric(pNIT)) {
            return new RetornoValidacao(NIT_INVALIDO);
        }
        if (pNIT.length() == 11) {
            int dvPassado;
            if (pNIT.equals("00000000000")) {
                return new RetornoValidacao(NIT_INVALIDO);
            }
            int dvCalculado = Validador.calculaDVNIT(pNIT);
            if (dvCalculado != (dvPassado = Integer.parseInt(pNIT.substring(pNIT.length() - 1)))) {
                return new RetornoValidacao(NIT_INVALIDO);
            }
        }
        return null;
    }

    private static int calculaDVNIT(String numNIT) {
        int retorno = 0;
        int totalProduto = 0;
        int resto = 0;
        int[] pesos = new int[]{3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        for (int i = 0; i < pesos.length; ++i) {
            int digitoAtual = Integer.parseInt(numNIT.substring(i, i + 1));
            totalProduto += digitoAtual * pesos[i];
        }
        resto = totalProduto % 11;
        retorno = 11 - resto;
        if (retorno > 9) {
            retorno = 0;
        }
        return retorno;
    }

    public static void main(String[] Args) {
    }
}

