/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TabelaMensagens;

public abstract class ObjetoNegocio
extends Observador {
    protected transient IdDeclaracao idDeclaracao;
    private boolean observadorAtivo = true;
    protected TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();
    protected String ficha = "";
    protected boolean persistente = true;

    public ObjetoNegocio(IdDeclaracao idDeclaracao) {
        this.idDeclaracao = idDeclaracao;
    }

    public ObjetoNegocio() {
        this.idDeclaracao = null;
    }

    public IdDeclaracao getIdDeclaracao() {
        return this.idDeclaracao;
    }

    protected boolean testaVazio(Informacao pInfo) {
        return true;
    }

    public boolean isVazio() {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                Informacao info;
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if (Informacao.class.isAssignableFrom(f.getType()) ? this.testaVazio(info = (Informacao)f.get(this)) && !info.isVazio() : ObjetoNegocio.class.isAssignableFrom(f.getType()) && (obj = (ObjetoNegocio)f.get(this)) != null && !(obj instanceof IdDeclaracao) && !obj.isVazio()) {
                    return false;
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return true;
    }

    public List<Informacao> recuperarCamposInformacao() {
        List<Field> fields = FabricaUtilitarios.getAllFields(this.getClass());
        ArrayList<Informacao> retorno = new ArrayList<Informacao>(fields.size());
        try {
            for (Field f : fields) {
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info = (Informacao)f.get(this);
                    retorno.add(info);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
        return retorno;
    }

    public void clear() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            informacao.clear();
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent evt) {
        if (this.isObservadorAtivo()) {
            LogPPGD.debug("Disparando observador " + this + ".");
            this.implementacaoPropertyChange(evt);
        }
        super.propertyChange(evt);
    }

    protected void implementacaoPropertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
    }

    public boolean isObservadorAtivo() {
        return this.observadorAtivo;
    }

    public void setObservadorAtivo(boolean b) {
        this.observadorAtivo = b;
    }

    public void setValidadoresAtivos(boolean opcao) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessible = f.isAccessible();
                f.setAccessible(true);
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info = (Informacao)f.get(this);
                    if (info != null) {
                        info.setValidadoresAtivos(opcao);
                    }
                } else if (!IdDeclaracao.class.isAssignableFrom(f.getType()) && ObjetoNegocio.class.isAssignableFrom(f.getType()) && (obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.setValidadoresAtivos(opcao);
                }
                f.setAccessible(acessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico(e);
        }
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        ArrayList<Pendencia> listaPendencias = new ArrayList<Pendencia>(this.recuperarListaCamposPendencia().size());
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            Enumeration<RetornoValidacao> retornosValidacoes = informacao.validar().elements();
            while (retornosValidacoes.hasMoreElements()) {
                RetornoValidacao retornoValidacao = retornosValidacoes.nextElement();
                if (retornoValidacao.getSeveridade() <= 0) continue;
                Pendencia pendencia = new Pendencia(retornoValidacao.getSeveridade(), informacao, informacao.getNomeCampo(), retornoValidacao.getMensagemValidacao(), numeroItem);
                if (this instanceof ObjetoFicha) {
                    pendencia.setClassePainel(((ObjetoFicha)((Object)this)).getClasseFicha());
                }
                listaPendencias.add(pendencia);
            }
        }
        return listaPendencias;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        ArrayList<Informacao> listaCamposPendencia = new ArrayList<Informacao>(5);
        return listaCamposPendencia;
    }

    public void setFicha(String pFicha) {
        this.ficha = pFicha;
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            informacao.setFicha(this.ficha);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class<?> pClasse) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessivel;
                if (Modifier.isTransient(f.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadoresAnonimosDesnecessarios(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(f.getType()) || !ObjetoNegocio.class.isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadoresAnonimosDesnecessarios(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeObservadores(Class<?>[] pClasse) {
        try {
            for (Field f : FabricaUtilitarios.getAllFields(this.getClass())) {
                ObjetoNegocio obj;
                boolean acessivel;
                if (Modifier.isTransient(f.getModifiers())) continue;
                if (Informacao.class.isAssignableFrom(f.getType())) {
                    Informacao info;
                    acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((info = (Informacao)f.get(this)) != null) {
                        info.removeObservadores(pClasse);
                    }
                    f.setAccessible(acessivel);
                    continue;
                }
                if (IdDeclaracao.class.isAssignableFrom(f.getType()) || !ObjetoNegocio.class.isAssignableFrom(f.getType())) continue;
                acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((obj = (ObjetoNegocio)f.get(this)) != null) {
                    obj.removeObservadores(pClasse);
                }
                f.setAccessible(acessivel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPersistente() {
        return this.persistente;
    }

    public void setPersistente(boolean persistente) {
        this.persistente = persistente;
    }
}

