/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IteratorColecaoPPGD;
import serpro.ppgd.negocio.ListIteratorColecaoPPGD;
import serpro.ppgd.negocio.util.LogPPGD;

public class ListaPPGD<E>
implements List<E> {
    private List<E> implementacao;
    private Colecao owner;

    public ListaPPGD(Colecao owner) {
        this.owner = owner;
    }

    private void objetoInserido(Object o) {
        this.owner.objetoInserido(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoInserido", "alterou", o);
        }
    }

    private void objetoARemover(Object o) {
        this.owner.objetoARemover(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoAremover", "alterou", o);
        }
    }

    private void objetoRemovido(Object o) {
        this.owner.objetoRemovido(o);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoRemovido", "alterou", o);
        }
    }

    private void verificaTipoInserido(Object o) {
        if (this.owner.getTipoItens() != null && !this.owner.getTipoItens().isInstance(o)) {
            String msg = "Tentativa inv\u00e1lida de inser\u00e7\u00e3o do elemento " + o + " na cole\u00e7\u00e3o " + this.owner;
            LogPPGD.erro(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void verificaTamanho(int index) {
        if (this.owner.getTamanho() != 0 && index >= this.owner.getTamanho()) {
            String msg = "A cole\u00e7\u00e3o " + this.owner.getClass().getName() + "ultrapassou o tamanho limite de " + this.owner.getTamanho() + ", foi requerido o index " + index;
            LogPPGD.erro(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void add(int index, E element) {
        this.verificaTipoInserido(element);
        this.verificaTamanho(this.size());
        this.getImplementacao().add(index, element);
        this.objetoInserido(element);
    }

    @Override
    public boolean add(E element) {
        this.verificaTipoInserido(element);
        this.verificaTamanho(this.size());
        if (this.getImplementacao().add(element)) {
            this.objetoInserido(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> i = c.iterator();
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.getImplementacao().addAll(c)) {
            i = c.iterator();
            while (i.hasNext()) {
                this.objetoInserido(i.next());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Iterator<E> i = c.iterator();
        if (c.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.getImplementacao().addAll(index, c)) {
            i = c.iterator();
            while (i.hasNext()) {
                this.objetoInserido(i.next());
            }
            return true;
        }
        return false;
    }

    public boolean addAll(Collection<? extends E> c, boolean rodaEventoInsercao) {
        Iterator<E> i = c.iterator();
        if (this.owner.getTamanho() > 0 && c.size() + this.size() > this.owner.getTamanho()) {
            throw new IllegalArgumentException("A cole\u00e7\u00e3o ultrapassou o tamanho limite.");
        }
        while (i.hasNext()) {
            this.verificaTipoInserido(i.next());
        }
        if (this.getImplementacao().addAll(c)) {
            if (rodaEventoInsercao) {
                i = c.iterator();
                while (i.hasNext()) {
                    this.objetoInserido(i.next());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Iterator<E> i = this.getImplementacao().iterator();
        while (i.hasNext()) {
            this.objetoARemover(i.next());
        }
        this.getImplementacao().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getImplementacao().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getImplementacao().containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.getImplementacao().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getImplementacao().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getImplementacao().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorColecaoPPGD<E>(this.getImplementacao().iterator(), this.owner);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getImplementacao().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorColecaoPPGD<E>(this.getImplementacao().listIterator(), this.owner, this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIteratorColecaoPPGD<E>(this.getImplementacao().listIterator(index), this.owner, this);
    }

    @Override
    public E remove(int index) {
        Object o = null;
        if (index >= 0 && index < this.getImplementacao().size()) {
            o = this.getImplementacao().get(index);
            this.objetoARemover(o);
        }
        E result = this.getImplementacao().remove(index);
        this.objetoRemovido(o);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        if (this.getImplementacao().contains(o)) {
            this.objetoARemover(o);
            result = this.getImplementacao().remove(o);
            this.objetoRemovido(o);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            Object o = i.next();
            if (!this.getImplementacao().contains(o)) continue;
            this.objetoARemover(o);
        }
        result = this.getImplementacao().removeAll(c);
        if (result) {
            for (Object o : c) {
                if (this.getImplementacao().contains(o)) continue;
                this.objetoRemovido(o);
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        for (E e : this.getImplementacao()) {
            if (c.contains(e)) continue;
            this.objetoARemover(e);
        }
        boolean result = this.getImplementacao().retainAll(c);
        for (E e : this.getImplementacao()) {
            if (c.contains(e)) continue;
            this.objetoRemovido(e);
        }
        return result;
    }

    @Override
    public E set(int index, E element) {
        this.verificaTipoInserido(element);
        this.verificaTamanho(index);
        Object o = null;
        if (index >= 0 && index < this.getImplementacao().size()) {
            o = this.getImplementacao().get(index);
            this.objetoARemover(o);
        }
        E res = this.getImplementacao().set(index, element);
        if (index >= 0 && index < this.getImplementacao().size()) {
            this.objetoRemovido(o);
        }
        this.owner.objetoInserido(element);
        return res;
    }

    @Override
    public int size() {
        return this.getImplementacao().size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.getImplementacao().subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.getImplementacao().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getImplementacao().toArray(a);
    }

    public List<E> getImplementacao() {
        if (this.implementacao == null) {
            this.implementacao = new ArrayList(5);
        }
        return this.implementacao;
    }
}

