/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;

public class Inteiro
extends Informacao {
    public static final String PROP_LIMITE_MIN_MAX = "LIMITES";
    private int conteudoInteiro = 0;
    private int limiteMinimo = -1;
    private int limiteMaximo = -1;

    public Inteiro() {
        this(null, "");
    }

    public Inteiro(String nomeCampo) {
        this(null, nomeCampo);
    }

    public Inteiro(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public int getLimiteMaximo() {
        return this.limiteMaximo;
    }

    public void setLimiteMaximo(int limiteMaximo) {
        this.limiteMaximo = limiteMaximo;
        this.getObservadores().firePropertyChange(PROP_LIMITE_MIN_MAX, false, true);
    }

    public int getLimiteMinimo() {
        return this.limiteMinimo;
    }

    public void setLimiteMinimo(int limiteMinimo) {
        this.limiteMinimo = limiteMinimo;
        this.getObservadores().firePropertyChange(PROP_LIMITE_MIN_MAX, false, true);
    }

    public void setConteudo(int pConteudo) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(pConteudo));
        String antigo = this.asString();
        this.clearRetornosValidacoes();
        this.conteudoInteiro = pConteudo;
        this.disparaObservadores(antigo);
    }

    @Override
    public void setConteudo(String conteudo) {
        if (conteudo.trim().equals("")) {
            this.setConteudo(0);
        } else {
            int val = 0;
            try {
                val = Integer.parseInt(conteudo);
            }
            catch (Exception e) {
                val = 0;
            }
            this.setConteudo(val);
        }
    }

    @Override
    public String getConteudoFormatado() {
        return this.asString();
    }

    @Override
    public boolean isVazio() {
        return this.asInteger() == 0;
    }

    @Override
    public int compareTo(Inteiro outroInteiro) {
        if (this.conteudoInteiro < outroInteiro.asInteger()) {
            return -1;
        }
        if (this.conteudoInteiro == outroInteiro.asInteger()) {
            return 0;
        }
        return 1;
    }

    @Override
    public String asString() {
        return String.valueOf(this.conteudoInteiro);
    }

    public int asInteger() {
        return this.conteudoInteiro;
    }

    public static void main(String[] argumentos) {
        System.out.println(new Inteiro().conteudoInteiro);
    }

    @Override
    public void clear() {
        this.setConteudo(0);
    }

    public int getConteudoInteiro() {
        return this.conteudoInteiro;
    }

    public void setConteudoInteiro(int conteudoInteiro) {
        this.conteudoInteiro = conteudoInteiro;
    }
}

